/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.biome;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.ModList;
import net.paradisemod.world.biome.BiomeRegion;
import net.paradisemod.world.biome.PMBiomes;
import terrablender.api.Region;
import terrablender.api.Regions;

public class RegionGenerator {
    private final ArrayList<BiomeRegion> regions = new ArrayList();

    public RegionGenerator() {
        this.regions.add(new BiomeRegion("region_0"));
        if (ModList.get().isLoaded("quark")) {
            this.addBiome(PMBiomes.SALT_DEPOSIT, PMBiomes.GLIMMERING_WEALD);
        }
    }

    public void addBiome(BiomeManager.BiomeType type, ResourceKey<Biome> biome) {
        boolean createNewRegion = true;
        for (BiomeRegion region : this.regions) {
            if (!region.addBiome(type, biome)) continue;
            createNewRegion = false;
            break;
        }
        if (createNewRegion) {
            BiomeRegion newRegion = new BiomeRegion("region_" + this.regions.size());
            newRegion.addBiome(type, biome);
            this.regions.add(newRegion);
        }
    }

    public void addBiome(ResourceKey<Biome> biomeToReplace, ResourceKey<Biome> biome) {
        boolean createNewRegion = true;
        for (BiomeRegion region : this.regions) {
            if (!region.addBiome(biomeToReplace, biome)) continue;
            createNewRegion = false;
            break;
        }
        if (createNewRegion) {
            BiomeRegion newRegion = new BiomeRegion("region_" + this.regions.size());
            newRegion.addBiome(biomeToReplace, biome);
            this.regions.add(newRegion);
        }
    }

    public void generate() {
        for (BiomeRegion region : this.regions) {
            Regions.register((Region)region);
        }
    }
}

