/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.biome;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.paradisemod.world.biome.OverworldBiome;
import net.paradisemod.worldgen.carver.PMCarvers;
import net.paradisemod.worldgen.features.PMFeatures;
import net.paradisemod.worldgen.features.foliage.PMFoliage;

public class UndergroundBiome {
    protected static final int DEFAULT_SKY = 1344638;

    public static Biome biome(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean hasRain, float temp, int waterColor, int grassColor, boolean shroomCave) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        UndergroundBiome.defaultFeatures(spawnInfo, genSettings);
        if (temp <= 0.0f) {
            genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.GLOWING_ICE_ORE);
        } else {
            genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.GLOWSTONE_ORE);
        }
        if (shroomCave) {
            genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.OWC_SHROOMS);
        }
        if (temp >= 2.0f) {
            BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnInfo);
        }
        return UndergroundBiome.createBiome(genSettings, spawnInfo, hasRain, temp, 0.4f, grassColor, waterColor, waterColor, 1344638);
    }

    public static Biome undergroundSwamp(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        UndergroundBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.GLOWSTONE_ORE);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 1, 1, 1));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        return UndergroundBiome.createBiome(genSettings, spawnInfo, true, 0.25f, 0.4f, 6975545, 6388580, 6388580, 1344638);
    }

    public static Biome undergroundMangroveSwamp(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        UndergroundBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.GLOWSTONE_ORE);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 1, 1, 1));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        spawnInfo.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 8, 8));
        return UndergroundBiome.createBiome(genSettings, spawnInfo, true, 0.25f, 0.4f, 6975545, 3832426, 3832426, 1344638);
    }

    public static Biome saltCave(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        UndergroundBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_SALT_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.SALT_LAMP_ORE);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.SALT_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFeatures.EXTRA_SALT_CRYSTALS);
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnInfo);
        return UndergroundBiome.createBiome(genSettings, spawnInfo, false, 2.0f, 0.0f, null, 12751249, 12751249, 15286514);
    }

    public static Biome glacier(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        UndergroundBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_254863_(GenerationStep.Carving.AIR, (Holder)carverGetter.m_255043_(PMCarvers.CREVASSE));
        genSettings.m_254863_(GenerationStep.Carving.AIR, (Holder)carverGetter.m_255043_(PMCarvers.ICE_CAVES));
        return UndergroundBiome.createBiome(genSettings, spawnInfo, true, -0.25f, 1.0f, null, 4159204, 329011, 1344638);
    }

    public static Biome volcanicCave(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        UndergroundBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.VOLCANIC_LAVA_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.VOLCANIC_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_OBSIDIAN);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_MAGMA);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_BASALT);
        return UndergroundBiome.createBiome(genSettings, spawnInfo, false, 2.0f, 0.0f, 16763981, 4159204, 329011, 1344638);
    }

    public static Biome honeyCave(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        UndergroundBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.HONEY_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.HONEY_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.HONEY_CRYSTAL_ORE);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFeatures.HONEY_CRYSTALS);
        return UndergroundBiome.createBiome(genSettings, spawnInfo, true, 2.0f, 1.0f, null, 14786832, 14786832, 15456282);
    }

    protected static void defaultFeatures(MobSpawnSettings.Builder spawnInfo, BiomeGenerationSettings.Builder genSettings) {
        OverworldBiome.defaultFeatures(genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.PSYCHEDELIC_LAVA_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.LIQUID_REDSTONE_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.PSYCHEDELIC_LAVA_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.LIQUID_REDSTONE_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.OWC_TREES);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.OWC_FOLIAGE);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnInfo);
    }

    protected static Biome createBiome(BiomeGenerationSettings.Builder genSettings, MobSpawnSettings.Builder spawnInfo, boolean hasRain, float temp, float downfall, @Nullable Integer grassColor, int waterColor, int waterFogColor, int skyColor) {
        BiomeSpecialEffects.Builder effectsBuilder = new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(skyColor).m_48040_(skyColor).m_48027_(AmbientMoodSettings.f_47387_);
        if (grassColor != null) {
            effectsBuilder.m_48045_(grassColor.intValue()).m_48043_(grassColor.intValue());
        }
        return new Biome.BiomeBuilder().m_264558_(hasRain).m_47609_(temp).m_47611_(downfall).m_47603_(effectsBuilder.m_48018_()).m_47605_(spawnInfo.m_48381_()).m_47601_(genSettings.m_255380_()).m_47592_();
    }
}

