/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.biome;

import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.paradisemod.world.biome.UndergroundBiome;
import net.paradisemod.worldgen.features.PMFeatures;

public class UndergroundOcean {
    public static Biome biome(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, OceanType type) {
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126740_((MobSpawnSettings.Builder)spawnInfo, (int)1, (int)4, (int)10);
        spawnInfo.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147034_, 1, 1, 4));
        if (type == OceanType.WARM) {
            BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnInfo, (int)10, (int)4);
        }
        if (type == OceanType.FROZEN) {
            BiomeDefaultFeatures.m_126767_((BiomeGenerationSettings.Builder)genSettings);
            BiomeDefaultFeatures.m_126769_((BiomeGenerationSettings.Builder)genSettings);
        }
        UndergroundBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.SEA_LANTERN_ORE);
        return UndergroundBiome.createBiome(genSettings, spawnInfo, true, type.temp, 0.5f, null, type.waterColor, type.waterColor, type.waterColor);
    }

    protected static enum OceanType {
        NORMAL(0.5f, 4159204),
        LUKEWARM(0.7f, 4566514),
        WARM(1.0f, 4445678),
        COLD(0.0f, 4020182),
        FROZEN(-0.25f, 3750089);

        private final float temp;
        private final int waterColor;

        private OceanType(float temp, int waterColor) {
            this.temp = temp;
            this.waterColor = waterColor;
        }

        public float getTemp() {
            return this.temp;
        }
    }
}

