/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.blocks;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.paradisemod.world.blocks.SmallCaveFormation;

public class CrystalCluster
extends EndRodBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape[] CRYSTAL_UP = new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)17.5, (double)11.0), Shapes.m_83144_(), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.5, (double)11.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)18.5, (double)14.0)};
    private static final VoxelShape[] CRYSTAL_DOWN = new VoxelShape[]{Block.m_49796_((double)5.0, (double)-1.5, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Shapes.m_83144_(), Block.m_49796_((double)5.0, (double)1.5, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.m_49796_((double)2.0, (double)-2.5, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};
    private static final VoxelShape[] CRYSTAL_NORTH = new VoxelShape[]{Block.m_49796_((double)5.0, (double)5.0, (double)-1.5, (double)11.0, (double)11.0, (double)16.0), Shapes.m_83144_(), Block.m_49796_((double)5.0, (double)5.0, (double)1.5, (double)11.0, (double)11.0, (double)16.0), Block.m_49796_((double)2.0, (double)2.0, (double)-2.5, (double)14.0, (double)14.0, (double)16.0)};
    private static final VoxelShape[] CRYSTAL_SOUTH = new VoxelShape[]{Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)17.5), Shapes.m_83144_(), Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)14.0), Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)18.5)};
    private static final VoxelShape[] CRYSTAL_EAST = new VoxelShape[]{Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)17.5, (double)11.0, (double)11.0), Shapes.m_83144_(), Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0), Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)18.5, (double)14.0, (double)14.0)};
    private static final VoxelShape[] CRYSTAL_WEST = new VoxelShape[]{Block.m_49796_((double)-1.5, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Shapes.m_83144_(), Block.m_49796_((double)1.5, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.m_49796_((double)-2.5, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0)};
    private final boolean randTeleport;
    private final boolean hasRedstonePower;

    public CrystalCluster(boolean randTeleport, boolean hasRedstonePower) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152492_).m_60953_(s -> 10).m_60910_());
        this.hasRedstonePower = hasRedstonePower;
        this.randTeleport = randTeleport;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)TYPE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return SmallCaveFormation.isSupported(world, (Direction)state.m_61143_((Property)f_52588_), pos);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!SmallCaveFormation.isSupported(world, (Direction)state.m_61143_((Property)f_52588_), pos)) {
            world.m_46961_(pos, true);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Integer type = (Integer)state.m_61143_((Property)TYPE);
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        return switch (direction) {
            default -> CRYSTAL_UP[type];
            case Direction.DOWN -> CRYSTAL_DOWN[type];
            case Direction.NORTH -> CRYSTAL_NORTH[type];
            case Direction.SOUTH -> CRYSTAL_SOUTH[type];
            case Direction.EAST -> CRYSTAL_EAST[type];
            case Direction.WEST -> CRYSTAL_WEST[type];
        };
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, TYPE, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockState state = this.m_49966_();
        RandomSource rand = world.f_46441_;
        Direction facing = ctx.m_43719_();
        FluidState fluidstate = world.m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_52588_, (Comparable)facing)).m_61124_((Property)TYPE, (Comparable)Integer.valueOf(rand.m_188503_(4)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (this.randTeleport && !entity.m_20092_()) {
            ArrayList<BlockPos> otherClusters = new ArrayList<BlockPos>();
            for (int x = -7; x <= 7; ++x) {
                for (int z = -7; z <= 7; ++z) {
                    for (int y = -7; y <= 7; ++y) {
                        BlockPos newPos;
                        if (x == 0 && y == 0 && z == 0 || !world.m_8055_(newPos = pos.m_7918_(x, y, z)).m_60713_((Block)this)) continue;
                        otherClusters.add(newPos);
                    }
                }
            }
            if (otherClusters.isEmpty()) {
                return;
            }
            BlockPos newEntityPos = (BlockPos)otherClusters.get(world.f_46441_.m_188503_(otherClusters.size()));
            entity.m_20324_((double)newEntityPos.m_123341_() + 0.5, (double)newEntityPos.m_123342_(), (double)newEntityPos.m_123343_() + 0.5);
            entity.m_20091_();
        }
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        return this.hasRedstonePower ? 15 : 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.hasRedstonePower;
    }
}

