/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.blocks;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.world.fluid.CustomFluidType;
import net.paradisemod.world.fluid.PMLiquidBlock;

public class CustomCauldron
extends AbstractCauldronBlock
implements ModeledBlock {
    private final RegisteredBlock fluidBlock;
    private final boolean translucent;

    public CustomCauldron(RegisteredBlock fluidBlock, Map<Item, CauldronInteraction> interactions, boolean translucent) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_).m_60953_(s -> CustomCauldron.getFluidLight(fluidBlock)), interactions);
        this.fluidBlock = fluidBlock;
        this.translucent = translucent;
    }

    public boolean m_142596_(BlockState pState) {
        return true;
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        String fluidName = this.fluidBlock.shortName();
        CustomFluidType type = (CustomFluidType)this.getFluid().getFluidType();
        ResourceLocation content = type.cauldronTexture();
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)generator.models().withExistingParent(fluidName + "_cauldron", "block/template_cauldron_full")).texture("bottom", "minecraft:block/cauldron_bottom")).texture("inside", "minecraft:block/cauldron_inner")).texture("particle", "minecraft:block/cauldron_side")).texture("side", "minecraft:block/cauldron_side")).texture("top", "minecraft:block/cauldron_top")).texture("content", content);
        if (this.translucent) {
            model = (BlockModelBuilder)model.renderType("translucent");
        }
        generator.simpleBlock((Block)this, (ModelFile)model);
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return 3;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (this.m_151979_(state, pos, entity)) {
            this.fluidBlock.get().m_49966_().m_60682_(world, pos, entity);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        this.fluidBlock.get().m_214162_(this.fluidBlock.get().m_49966_(), world, pos, rand);
    }

    protected double m_142446_(BlockState state) {
        return 0.9375;
    }

    private ForgeFlowingFluid getFluid() {
        Block block = this.fluidBlock.get();
        if (block instanceof PMLiquidBlock) {
            PMLiquidBlock liquidBlock = (PMLiquidBlock)block;
            return liquidBlock.getFluid();
        }
        return (ForgeFlowingFluid)Utils.modErrorTyped("fluidBlock must of type PMLiquidBlock!");
    }

    private static int getFluidLight(RegisteredBlock fluidBlock) {
        Block block = fluidBlock.get();
        if (block instanceof PMLiquidBlock) {
            PMLiquidBlock liquidBlock = (PMLiquidBlock)block;
            return liquidBlock.lightLevel();
        }
        return (Integer)Utils.modErrorTyped("fluidBlock must of type PMLiquidBlock!");
    }

    public int fluidTintColor() {
        return IClientFluidTypeExtensions.of((Fluid)this.getFluid()).getTintColor();
    }
}

