/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeCaveFormation
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Size> SIZE = EnumProperty.m_61587_((String)"size", Size.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty INVERTED = BooleanProperty.m_61465_((String)"inverted");
    private static final VoxelShape SMALL = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape MEDIUM = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape LARGE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public LargeCaveFormation(Block matchingBlock) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)matchingBlock).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SIZE, (Comparable)((Object)Size.SMALL))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)INVERTED)).booleanValue()) {
            BlockState stateAbove = world.m_8055_(pos.m_7494_());
            if (stateAbove.m_60713_((Block)this)) {
                return stateAbove.m_61143_(SIZE) != Size.SMALL;
            }
            return stateAbove.m_60713_(Blocks.f_50126_) || stateAbove.m_60713_(Blocks.f_50568_) || stateAbove.m_60713_(Blocks.f_50354_) || stateAbove.m_280296_() || stateAbove.m_60713_((Block)this);
        }
        BlockState stateBelow = world.m_8055_(pos.m_7495_());
        if (stateBelow.m_60713_((Block)this)) {
            return stateBelow.m_61143_(SIZE) != Size.SMALL;
        }
        return stateBelow.m_60713_(Blocks.f_50126_) || stateBelow.m_60713_(Blocks.f_50568_) || stateBelow.m_60713_(Blocks.f_50354_) || stateBelow.m_280296_() || stateBelow.m_60713_((Block)this);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Size)((Object)state.m_61143_(SIZE))) {
            default -> SMALL;
            case Size.MEDIUM -> MEDIUM;
            case Size.LARGE -> LARGE;
        };
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (((Boolean)state.m_61143_((Property)INVERTED)).booleanValue()) {
            BlockState stateAbove = world.m_8055_(pos.m_7494_());
            if (stateAbove.m_60713_(Blocks.f_50126_) || stateAbove.m_60713_(Blocks.f_50568_) || stateAbove.m_60713_(Blocks.f_50354_) || stateAbove.m_280296_() || stateAbove.m_60713_((Block)this)) {
                return;
            }
            world.m_46961_(pos, false);
        } else {
            BlockState stateBelow = world.m_8055_(pos.m_7495_());
            if (stateBelow.m_60713_(Blocks.f_50126_) || stateBelow.m_60713_(Blocks.f_50568_) || stateBelow.m_60713_(Blocks.f_50354_) || stateBelow.m_280296_() || stateBelow.m_60713_((Block)this)) {
                return;
            }
            world.m_46961_(pos, false);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = this.m_49966_();
        BlockState stateBelow = world.m_8055_(pos.m_7495_());
        BlockState stateAbove = world.m_8055_(pos.m_7494_());
        if (stateBelow.m_60713_((Block)this)) {
            state = switch ((Size)((Object)stateBelow.m_61143_(SIZE))) {
                case Size.MEDIUM, Size.SMALL -> (BlockState)state.m_61124_(SIZE, (Comparable)((Object)Size.SMALL));
                default -> (BlockState)state.m_61124_(SIZE, (Comparable)((Object)Size.MEDIUM));
            };
        } else if (stateAbove.m_60713_((Block)this)) {
            state = (BlockState)state.m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(true));
            state = switch ((Size)((Object)stateAbove.m_61143_(SIZE))) {
                case Size.MEDIUM, Size.SMALL -> (BlockState)state.m_61124_(SIZE, (Comparable)((Object)Size.SMALL));
                default -> (BlockState)state.m_61124_(SIZE, (Comparable)((Object)Size.MEDIUM));
            };
        } else {
            state = stateAbove.m_280296_() ? (BlockState)((BlockState)state.m_61124_(SIZE, (Comparable)((Object)Size.LARGE))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(true)) : (BlockState)state.m_61124_(SIZE, (Comparable)((Object)Size.LARGE));
        }
        FluidState fluidstate = world.m_6425_(pos);
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SIZE, INVERTED, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void place(WorldGenLevel world, BlockPos pos, boolean inverted) {
        if (inverted) {
            Fluid fluid1 = world.m_6425_(pos).m_76152_();
            Fluid fluid2 = world.m_6425_(pos.m_7495_()).m_76152_();
            Fluid fluid3 = world.m_6425_(pos.m_6625_(2)).m_76152_();
            if (world.m_8055_(pos).m_60795_() || world.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SIZE, (Comparable)((Object)Size.LARGE))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid1 == Fluids.f_76193_)), 32);
            }
            if (world.m_8055_(pos.m_7495_()).m_60795_() || world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49990_)) {
                world.m_7731_(pos.m_7495_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SIZE, (Comparable)((Object)Size.MEDIUM))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid2 == Fluids.f_76193_)), 32);
            }
            if (world.m_8055_(pos.m_6625_(2)).m_60795_() || world.m_8055_(pos.m_6625_(2)).m_60713_(Blocks.f_49990_)) {
                world.m_7731_(pos.m_6625_(2), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SIZE, (Comparable)((Object)Size.SMALL))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid3 == Fluids.f_76193_)), 32);
            }
        } else {
            Fluid fluid1 = world.m_6425_(pos).m_76152_();
            Fluid fluid2 = world.m_6425_(pos.m_7494_()).m_76152_();
            Fluid fluid3 = world.m_6425_(pos.m_6630_(2)).m_76152_();
            if (world.m_8055_(pos).m_60795_() || world.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
                world.m_7731_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_(SIZE, (Comparable)((Object)Size.LARGE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid1 == Fluids.f_76193_)), 32);
            }
            if (world.m_8055_(pos.m_7494_()).m_60795_() || world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_)) {
                world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(SIZE, (Comparable)((Object)Size.MEDIUM))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid2 == Fluids.f_76193_)), 32);
            }
            if (world.m_8055_(pos.m_6630_(2)).m_60795_() || world.m_8055_(pos.m_6630_(2)).m_60713_(Blocks.f_49990_)) {
                world.m_7731_(pos.m_6630_(2), (BlockState)((BlockState)this.m_49966_().m_61124_(SIZE, (Comparable)((Object)Size.SMALL))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid3 == Fluids.f_76193_)), 32);
            }
        }
    }

    public static enum Size implements StringRepresentable
    {
        SMALL,
        MEDIUM,
        LARGE;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

