/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.ITeleporter;
import net.paradisemod.base.BlockType;
import net.paradisemod.world.dimension.PMDimensions;
import net.paradisemod.world.dimension.PMTeleporter;

public class PMPortalBlock
extends GlassBlock {
    private final PMDimensions.Type dimension;

    public PMPortalBlock(PMDimensions.Type dimension) {
        super(BlockType.GLASS.getProperties().m_60910_());
        this.dimension = dimension;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(100) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, rand.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.m_123341_() + rand.m_188500_();
            double d1 = (double)pos.m_123342_() + rand.m_188500_();
            double d2 = (double)pos.m_123343_() + rand.m_188500_();
            double d3 = ((double)rand.m_188501_() - 0.5) / 2.0;
            double d4 = ((double)rand.m_188501_() - 0.5) / 2.0;
            double d5 = ((double)rand.m_188501_() - 0.5) / 2.0;
            int j = rand.m_188503_(2) * 2 - 1;
            if (!world.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !world.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                d3 = rand.m_188501_() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                d5 = rand.m_188501_() * 2.0f * (float)j;
            }
            world.m_7106_((ParticleOptions)this.dimension.getPortalParticles(), d0, d1, d2, d3, d4, d5);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        Level entityWorld = entity.m_9236_();
        if (entity.m_20092_()) {
            entity.m_20091_();
        } else if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_() && !entityWorld.f_46443_) {
                MinecraftServer server = serverWorld.m_7654_();
                ResourceKey<Level> where2go = entityWorld.m_46472_() == Level.f_46428_ ? this.dimension.getKey() : Level.f_46428_;
                ServerLevel dest = server.m_129880_(where2go);
                entityWorld.m_46473_().m_6180_(this.dimension.name().toLowerCase());
                if (!pos.equals((Object)entity.f_19819_)) {
                    entity.f_19819_ = pos;
                }
                entity.m_20091_();
                Direction.Axis axis = entity.m_6350_().m_122434_();
                entity.changeDimension(dest, (ITeleporter)new PMTeleporter(dest, this.dimension, this, axis));
                entityWorld.m_46473_().m_7238_();
            }
        }
    }
}

