/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.Utils;

public class SpreadableBlock
extends SpreadingSnowyDirtBlock
implements BonemealableBlock {
    private final TagKey<Block> foliageTag;
    private final Block spreadToBlock;

    public SpreadableBlock(Block spreadToBlock, @Nullable TagKey<Block> foliageTag, BlockBehaviour.Properties properties) {
        super(properties.m_60977_());
        this.foliageTag = foliageTag;
        this.spreadToBlock = spreadToBlock;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return this.foliageTag != null;
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        return this.foliageTag != null;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        if (this.foliageTag == null) {
            return;
        }
        int x = pos.m_123341_() - 7;
        int y = pos.m_123342_() - 7;
        int z = pos.m_123343_() - 7;
        if (y < 0) {
            y = 0;
        }
        ITag<Block> end_foliage = Utils.getBlockTag(this.foliageTag);
        world.m_46597_(pos.m_7494_(), ((Block)end_foliage.getRandomElement(rand).get()).m_49966_());
        for (int bx = x; bx < x + 14; ++bx) {
            for (int bz = z; bz < z + 14; ++bz) {
                for (int by = y; by < y + 14; ++by) {
                    if (!world.m_8055_(new BlockPos(bx, by, bz)).m_60713_((Block)this) || !world.m_8055_(new BlockPos(bx, by + 1, bz)).m_60795_() || rand.m_188503_(8) != 0) continue;
                    world.m_46597_(new BlockPos(bx, by + 1, bz), ((Block)end_foliage.getRandomElement(rand).get()).m_49966_());
                }
            }
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        boolean hasFluid;
        BlockPos[] adjBlocks = new BlockPos[]{pos.m_122024_(), pos.m_122029_(), pos.m_122012_(), pos.m_122019_(), pos.m_7494_().m_122024_(), pos.m_7494_().m_122029_(), pos.m_7494_().m_122012_(), pos.m_7494_().m_122019_(), pos.m_7495_().m_122024_(), pos.m_7495_().m_122029_(), pos.m_7495_().m_122012_(), pos.m_7495_().m_122019_()};
        BlockPos blockToSpreadto = adjBlocks[rand.m_188503_(12)];
        Block adjBlock = world.m_8055_(blockToSpreadto).m_60734_();
        BlockState blockAbove = world.m_8055_(blockToSpreadto.m_7494_());
        boolean bl = hasFluid = !world.m_8055_(pos.m_7494_()).m_60819_().m_76178_();
        if (world.m_8055_(pos.m_7494_()).m_60804_((BlockGetter)world, pos) || hasFluid) {
            world.m_46597_(pos, this.spreadToBlock.m_49966_());
        }
        if (world.m_46803_(pos.m_7494_()) >= 9 && adjBlock == this.spreadToBlock && !blockAbove.m_60815_() && !hasFluid) {
            world.m_46597_(blockToSpreadto, this.m_49966_());
        }
    }
}

