/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.dimension;

import com.google.common.collect.ImmutableSet;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.Ores;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.PMBiomeSource;
import net.paradisemod.world.dimension.client.ClientEvents;

public class PMDimensions {
    private static final DeferredRegister<PoiType> POI_TYPES = PMRegistries.createRegistry(ForgeRegistries.POI_TYPES);
    public static final RegistryObject<PoiType> OWC_POI = POI_TYPES.register("owc_poi", () -> new PoiType((Set)ImmutableSet.of((Object)PMWorld.OVERWORLD_CORE_PORTAL.get().m_49966_()), 0, 1));
    public static final RegistryObject<PoiType> DEEP_DARK_POI = POI_TYPES.register("deep_dark_poi", () -> new PoiType((Set)ImmutableSet.of((Object)PMWorld.DEEP_DARK_PORTAL.get().m_49966_()), 0, 1));
    public static final RegistryObject<PoiType> ELYSIUM_POI = POI_TYPES.register("elysium_poi", () -> new PoiType((Set)ImmutableSet.of((Object)PMWorld.ELYSIUM_PORTAL.get().m_49966_()), 0, 1));

    public static void init(IEventBus eventbus) {
        POI_TYPES.register(eventbus);
        DeferredRegister biomeSourceRegistry = PMRegistries.createRegistry(Registries.f_256826_);
        biomeSourceRegistry.register("dimension_biomes", () -> PMBiomeSource.CODEC);
        biomeSourceRegistry.register(eventbus);
        if (FMLEnvironment.dist.isClient()) {
            eventbus.addListener(ClientEvents::regEffects);
        }
    }

    public static void buildDimensionTypes(BootstapContext<DimensionType> context) {
        ParadiseMod.LOG.debug("Generating dimension types...");
        for (Type dimType : Type.values()) {
            context.m_255272_(PMRegistries.createModResourceKey(Registries.f_256787_, dimType.getName()), (Object)dimType.buildDimType());
        }
    }

    public static void buildDimensions(BootstapContext<LevelStem> context) {
        ParadiseMod.LOG.debug("Generating dimensions...");
        HolderGetter dimTypeGetter = context.m_255420_(Registries.f_256787_);
        HolderGetter noiseSettingsGetter = context.m_255420_(Registries.f_256932_);
        for (Type dimType : Type.values()) {
            context.m_255272_(PMRegistries.createModResourceKey(Registries.f_256862_, dimType.getName()), (Object)dimType.buildDimension((HolderGetter<DimensionType>)dimTypeGetter, (HolderGetter<NoiseGeneratorSettings>)noiseSettingsGetter));
        }
    }

    public static boolean isDimOverworldLike(WorldGenLevel world) {
        ResourceKey dim = world.m_6018_().m_46472_();
        return dim == Level.f_46428_ || Type.OVERWORLD_CORE.is((ResourceKey<Level>)dim) || Type.ELYSIUM.is((ResourceKey<Level>)dim);
    }

    public static enum Type {
        OVERWORLD_CORE(ParticleTypes.f_123797_, Ores.BLAZE_BLOCK, OWC_POI),
        DEEP_DARK(ParticleTypes.f_235898_, Ores.ENDERITE_BLOCK, DEEP_DARK_POI),
        ELYSIUM(ParticleTypes.f_123767_, () -> Blocks.f_50141_, ELYSIUM_POI);

        private final ResourceLocation key = new ResourceLocation("paradisemod:" + this.name().toLowerCase());
        private final SimpleParticleType portalParticles;
        private final Supplier<Block> frame;
        private final RegistryObject<PoiType> poiType;

        private Type(SimpleParticleType portalParticles, Supplier<Block> frame, RegistryObject<PoiType> poiType) {
            this.portalParticles = portalParticles;
            this.frame = frame;
            this.poiType = poiType;
        }

        public boolean is(ResourceKey<Level> dim) {
            return dim == this.getKey();
        }

        public ResourceKey<Level> getKey() {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.key);
        }

        public ResourceKey<LevelStem> getLevelStemKey() {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)this.key);
        }

        public SimpleParticleType getPortalParticles() {
            return this.portalParticles;
        }

        public Block getFrameBlock() {
            return this.frame.get();
        }

        public ResourceKey<PoiType> getPointOfInterestType() {
            return this.poiType.getKey();
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public ItemLike portalCraftItem() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case OVERWORLD_CORE -> Items.f_42593_;
                case ELYSIUM -> Items.f_42525_;
                case DEEP_DARK -> Misc.ENDERITE_INGOT;
            };
        }

        private DimensionType buildDimType() {
            ResourceLocation effectsLoc = this == ELYSIUM ? BuiltinDimensionTypes.f_223542_ : new ResourceLocation("paradisemod", this.getName());
            int coordScale = this == OVERWORLD_CORE ? 8 : 4;
            return new DimensionType(this == ELYSIUM ? OptionalLong.empty() : OptionalLong.of(18000L), this == ELYSIUM, this == OVERWORLD_CORE, false, true, (double)coordScale, true, false, -64, 384, 384, BlockTags.f_13058_, effectsLoc, 0.0f, new DimensionType.MonsterSettings(this == OVERWORLD_CORE, this != DEEP_DARK, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 0));
        }

        private LevelStem buildDimension(HolderGetter<DimensionType> dimTypeGetter, HolderGetter<NoiseGeneratorSettings> noiseSettingsGetter) {
            Holder.Reference dimType = dimTypeGetter.m_255043_(PMRegistries.createModResourceKey(Registries.f_256787_, this.getName()));
            Holder.Reference noiseSettings = noiseSettingsGetter.m_255043_(PMRegistries.createModResourceKey(Registries.f_256932_, this.getName()));
            return new LevelStem((Holder)dimType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)new PMBiomeSource(this.getName()), (Holder)noiseSettings));
        }

        public String localizedName(boolean spanish) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case OVERWORLD_CORE -> {
                    if (spanish) {
                        yield "centro del sobremundo";
                    }
                    yield "Overworld Core";
                }
                case DEEP_DARK -> {
                    if (spanish) {
                        yield "oscuro profundo";
                    }
                    yield "Deep Dark";
                }
                case ELYSIUM -> spanish ? "el\u00edseo" : "Elysium";
            };
        }
    }
}

