/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.fluid;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.base.Events;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.world.fluid.CustomFluidType;
import net.paradisemod.world.fluid.PMFluids;
import org.joml.Vector3f;

public class FluidPropertiesBuilder {
    public static final DeferredRegister<FluidType> FLUID_TYPES = PMRegistries.createRegistry(ForgeRegistries.Keys.FLUID_TYPES);
    private boolean canBecomeSource = true;
    private int density = 1000;
    private int lightLevel = 0;
    private int temp = 300;
    private int viscosity = 1000;
    private SoundEvent bucketFillSound = SoundEvents.f_11781_;
    private SoundEvent bucketEmptySound = SoundEvents.f_11778_;
    private int tickRate = 5;
    private final RegistryObject<ForgeFlowingFluid> sourceFluid;
    private final RegistryObject<ForgeFlowingFluid> flowingFluid;
    private final Supplier<LiquidBlock> fluidBlock;
    private final RegisteredItem bucket;
    private boolean rendersLikeLava = false;
    private boolean isHot = false;
    private int tintColor = -1;
    private int fogColor = -1;

    public FluidPropertiesBuilder(RegistryObject<ForgeFlowingFluid> sourceFluid, RegistryObject<ForgeFlowingFluid> flowingFluid, Supplier<? extends Block> fluidBlock, RegisteredItem bucket) {
        this.sourceFluid = sourceFluid;
        this.flowingFluid = flowingFluid;
        this.fluidBlock = fluidBlock;
        this.bucket = bucket;
        PMFluids.COLORED_BUCKETS.put(sourceFluid, bucket);
    }

    public FluidPropertiesBuilder isHot() {
        this.isHot = true;
        return this;
    }

    public FluidPropertiesBuilder canBecomeSource(boolean canBecomeSource) {
        this.canBecomeSource = canBecomeSource;
        return this;
    }

    public FluidPropertiesBuilder density(int density) {
        this.density = density;
        return this;
    }

    public FluidPropertiesBuilder lightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
        return this;
    }

    public FluidPropertiesBuilder temperature(int temp) {
        this.temp = temp;
        return this;
    }

    public FluidPropertiesBuilder viscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public FluidPropertiesBuilder tickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public FluidPropertiesBuilder fillSound(SoundEvent sound) {
        this.bucketFillSound = sound;
        return this;
    }

    public FluidPropertiesBuilder emptySound(SoundEvent sound) {
        this.bucketEmptySound = sound;
        return this;
    }

    public FluidPropertiesBuilder rendersLikeLava() {
        this.rendersLikeLava = true;
        return this;
    }

    public FluidPropertiesBuilder tintColor(int tintColor) {
        this.tintColor = tintColor;
        this.fogColor = tintColor;
        return this;
    }

    public FluidPropertiesBuilder fogColor(int fogColor) {
        this.fogColor = fogColor;
        return this;
    }

    public ForgeFlowingFluid.Properties build() {
        final String name = this.sourceFluid.getKey().m_135782_().m_135815_();
        return new ForgeFlowingFluid.Properties((Supplier)FLUID_TYPES.register(this.sourceFluid.getKey().m_135782_().m_135815_(), () -> new CustomFluidType(FluidType.Properties.create().canConvertToSource(this.canBecomeSource).density(this.density).lightLevel(this.lightLevel).temperature(this.temp).viscosity(this.viscosity).sound(SoundActions.BUCKET_EMPTY, this.bucketEmptySound).sound(SoundActions.BUCKET_FILL, this.bucketFillSound).canSwim(!this.isHot).canDrown(!this.isHot).supportsBoating(!this.isHot)){

            public boolean canRideVehicleUnder(Entity vehicle, Entity rider) {
                return !vehicle.m_275843_() && !FluidPropertiesBuilder.this.isHot;
            }

            public boolean move(FluidState state, LivingEntity creature, Vec3 movementVector, double gravity) {
                if (FluidPropertiesBuilder.this.isHot || state.m_192917_((Fluid)PMFluids.HONEY.get()) || state.m_192917_((Fluid)PMFluids.FLOWING_HONEY.get()) || state.m_192917_((Fluid)PMFluids.TAR.get()) || state.m_192917_((Fluid)PMFluids.FLOWING_TAR.get())) {
                    double moveFactor = 0.5;
                    double fallMod = 0.8;
                    double collisionMod = 0.6;
                    if (state.m_192917_((Fluid)PMFluids.HONEY.get()) || state.m_192917_((Fluid)PMFluids.FLOWING_HONEY.get())) {
                        moveFactor /= 2.0;
                        fallMod /= 2.0;
                        collisionMod /= 2.0;
                    } else if (state.m_192917_((Fluid)PMFluids.TAR.get()) || state.m_192917_((Fluid)PMFluids.FLOWING_TAR.get())) {
                        moveFactor /= 4.0;
                        fallMod /= 4.0;
                        collisionMod /= 4.0;
                    }
                    boolean isFalling = creature.m_20184_().f_82480_ <= 0.0;
                    double creatureY = creature.m_20186_();
                    creature.m_19920_(0.02f, movementVector);
                    creature.m_6478_(MoverType.SELF, creature.m_20184_());
                    if (creature.getFluidTypeHeight((FluidType)this) <= creature.m_20204_()) {
                        creature.m_20256_(creature.m_20184_().m_82542_(moveFactor, fallMod, moveFactor));
                        Vec3 vec33 = creature.m_20994_(gravity, isFalling, creature.m_20184_());
                        creature.m_20256_(vec33);
                    } else {
                        creature.m_20256_(creature.m_20184_().m_82490_(moveFactor));
                    }
                    if (!creature.m_20068_()) {
                        creature.m_20256_(creature.m_20184_().m_82520_(0.0, -gravity / 4.0, 0.0));
                    }
                    Vec3 vec34 = creature.m_20184_();
                    if (creature.f_19862_ && creature.m_20229_(vec34.f_82479_, vec34.f_82480_ + collisionMod - creature.m_20186_() + creatureY, vec34.f_82481_)) {
                        creature.m_20334_(vec34.f_82479_, collisionMod / 2.0, vec34.f_82481_);
                    }
                    return true;
                }
                return false;
            }

            public double motionScale(Entity entity) {
                if (FluidPropertiesBuilder.this.sourceFluid.getKey() == PMFluids.HONEY.getKey()) {
                    return 0.0035;
                }
                if (FluidPropertiesBuilder.this.sourceFluid.getKey() == PMFluids.TAR.getKey()) {
                    return 8.75E-4;
                }
                if (FluidPropertiesBuilder.this.isHot) {
                    return entity.m_9236_().m_6042_().f_63857_() ? 0.007 : 0.0023333333333333335;
                }
                return 0.014;
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new FluidRenderer(name, FluidPropertiesBuilder.this.rendersLikeLava, FluidPropertiesBuilder.this.tintColor, FluidPropertiesBuilder.this.fogColor));
            }

            @Override
            public ResourceLocation cauldronTexture() {
                if (FluidPropertiesBuilder.this.rendersLikeLava) {
                    return new ResourceLocation("paradisemod", "block/fluid/lava_like");
                }
                return new ResourceLocation("paradisemod", "block/fluid/" + name);
            }
        }), this.sourceFluid, this.flowingFluid).block(this.fluidBlock).bucket((Supplier)this.bucket).slopeFindDistance(8).levelDecreasePerBlock(1).tickRate(this.tickRate);
    }

    private record FluidRenderer(String name, boolean rendersLikeLava, int tintColor, int fogColor) implements IClientFluidTypeExtensions
    {
        public ResourceLocation getStillTexture() {
            if (this.rendersLikeLava) {
                return new ResourceLocation("paradisemod", "block/fluid/lava_like");
            }
            return new ResourceLocation("paradisemod", "block/fluid/" + this.name);
        }

        public ResourceLocation getFlowingTexture() {
            if (this.rendersLikeLava) {
                return new ResourceLocation("paradisemod", "block/fluid/flowing_lava_like");
            }
            return new ResourceLocation("paradisemod", "block/fluid/flowing_" + this.name);
        }

        public int getTintColor() {
            if (this.isPsychedelic()) {
                return Events.RAINBOW_COLOR.color();
            }
            return this.tintColor;
        }

        public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
            int color = this.fogColor;
            if (this.isPsychedelic()) {
                color = Events.RAINBOW_COLOR.color();
            }
            return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }

        private boolean isPsychedelic() {
            return this.name.startsWith("psychedelic");
        }
    }
}

