/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.fluid;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.world.fluid.PMFluids;

public class PMCauldronInteractions {
    public static Map<Item, CauldronInteraction> ENDER_ACID = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> GLOWING_WATER = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> HONEY = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> PSYCHEDELIC = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> LIQUID_REDSTONE = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> MOLTEN_SALT = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> PSYCHEDELIC_LAVA = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> TAR = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> DARK_LAVA = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> MOLTEN_GOLD = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> MOLTEN_SILVER = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> MOLTEN_IRON = CauldronInteraction.m_175617_();
    public static Map<Item, CauldronInteraction> MOLTEN_COPPER = CauldronInteraction.m_175617_();

    public static void init(FMLCommonSetupEvent event) {
        PMCauldronInteractions.defaultInteractions();
        ENDER_ACID.put(Items.f_42446_, PMCauldronInteractions.emptyWaterLike(PMFluids.ENDER_ACID_CAULDRON, PMFluids.ENDER_ACID_BUCKET));
        GLOWING_WATER.put(Items.f_42446_, PMCauldronInteractions.emptyWaterLike(PMFluids.GLOWING_WATER_CAULDRON, PMFluids.GLOWING_WATER_BUCKET));
        HONEY.put(Items.f_42446_, PMCauldronInteractions.emptyWaterLike(PMFluids.HONEY_CAULDRON, PMFluids.HONEY_BUCKET));
        PSYCHEDELIC.put(Items.f_42446_, PMCauldronInteractions.emptyWaterLike(PMFluids.PSYCHEDELIC_FLUID_CAULDRON, PMFluids.PSYCHEDELIC_FLUID_BUCKET));
        LIQUID_REDSTONE.put(Items.f_42446_, PMCauldronInteractions.emptyLavaLike(PMFluids.LIQUID_REDSTONE_CAULDRON, PMFluids.LIQUID_REDSTONE_BUCKET));
        MOLTEN_SALT.put(Items.f_42446_, PMCauldronInteractions.emptyLavaLike(PMFluids.MOLTEN_SALT_CAULDRON, PMFluids.MOLTEN_SALT_BUCKET));
        PSYCHEDELIC_LAVA.put(Items.f_42446_, PMCauldronInteractions.emptyLavaLike(PMFluids.PSYCHEDELIC_LAVA_CAULDRON, PMFluids.PSYCHEDELIC_LAVA_BUCKET));
        TAR.put(Items.f_42446_, PMCauldronInteractions.emptyWaterLike(PMFluids.TAR_CAULDRON, PMFluids.TAR_BUCKET));
        DARK_LAVA.put(Items.f_42446_, PMCauldronInteractions.emptyLavaLike(PMFluids.DARK_LAVA_CAULDRON, PMFluids.DARK_LAVA_BUCKET));
        MOLTEN_GOLD.put(Items.f_42446_, PMCauldronInteractions.emptyLavaLike(PMFluids.MOLTEN_GOLD_CAULDRON, PMFluids.MOLTEN_GOLD_BUCKET));
        MOLTEN_SILVER.put(Items.f_42446_, PMCauldronInteractions.emptyLavaLike(PMFluids.MOLTEN_SILVER_CAULDRON, PMFluids.MOLTEN_SILVER_BUCKET));
        MOLTEN_IRON.put(Items.f_42446_, PMCauldronInteractions.emptyLavaLike(PMFluids.MOLTEN_IRON_CAULDRON, PMFluids.MOLTEN_IRON_BUCKET));
        MOLTEN_COPPER.put(Items.f_42446_, PMCauldronInteractions.emptyLavaLike(PMFluids.MOLTEN_COPPER_CAULDRON, PMFluids.MOLTEN_COPPER_BUCKET));
    }

    private static CauldronInteraction fillWaterLike(RegisteredBlock cauldron) {
        return (state, world, pos, player, hand, stack) -> CauldronInteraction.m_175618_((Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)cauldron.get().m_49966_(), (SoundEvent)SoundEvents.f_11778_);
    }

    private static CauldronInteraction fillLavaLike(RegisteredBlock cauldron) {
        return (state, world, pos, player, hand, stack) -> CauldronInteraction.m_175618_((Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)cauldron.get().m_49966_(), (SoundEvent)SoundEvents.f_11780_);
    }

    private static CauldronInteraction emptyLavaLike(RegisteredBlock cauldron, RegisteredItem bucket) {
        return (state, world, pos, player, hand, stack) -> CauldronInteraction.m_175635_((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)bucket), s -> true, (SoundEvent)SoundEvents.f_11783_);
    }

    private static CauldronInteraction emptyWaterLike(RegisteredBlock cauldron, RegisteredItem bucket) {
        return (state, world, pos, player, hand, stack) -> CauldronInteraction.m_175635_((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)bucket), s -> true, (SoundEvent)SoundEvents.f_11781_);
    }

    private static void defaultInteractions() {
        CauldronInteraction.f_175606_.put(PMFluids.ENDER_ACID_BUCKET.m_5456_(), PMCauldronInteractions.fillWaterLike(PMFluids.ENDER_ACID_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.GLOWING_WATER_BUCKET.m_5456_(), PMCauldronInteractions.fillWaterLike(PMFluids.GLOWING_WATER_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.HONEY_BUCKET.m_5456_(), PMCauldronInteractions.fillWaterLike(PMFluids.HONEY_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.PSYCHEDELIC_FLUID_BUCKET.m_5456_(), PMCauldronInteractions.fillWaterLike(PMFluids.PSYCHEDELIC_FLUID_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.LIQUID_REDSTONE_BUCKET.m_5456_(), PMCauldronInteractions.fillLavaLike(PMFluids.LIQUID_REDSTONE_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.MOLTEN_SALT_BUCKET.m_5456_(), PMCauldronInteractions.fillLavaLike(PMFluids.MOLTEN_SALT_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.PSYCHEDELIC_LAVA_BUCKET.m_5456_(), PMCauldronInteractions.fillLavaLike(PMFluids.PSYCHEDELIC_LAVA_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.TAR_BUCKET.m_5456_(), PMCauldronInteractions.fillWaterLike(PMFluids.TAR_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.DARK_LAVA_BUCKET.m_5456_(), PMCauldronInteractions.fillLavaLike(PMFluids.DARK_LAVA_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.MOLTEN_GOLD_BUCKET.m_5456_(), PMCauldronInteractions.fillLavaLike(PMFluids.MOLTEN_GOLD_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.MOLTEN_SILVER_BUCKET.m_5456_(), PMCauldronInteractions.fillLavaLike(PMFluids.MOLTEN_SILVER_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.MOLTEN_IRON_BUCKET.m_5456_(), PMCauldronInteractions.fillLavaLike(PMFluids.MOLTEN_IRON_CAULDRON));
        CauldronInteraction.f_175606_.put(PMFluids.MOLTEN_COPPER_BUCKET.m_5456_(), PMCauldronInteractions.fillLavaLike(PMFluids.MOLTEN_COPPER_CAULDRON));
    }
}

