/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PMFluid {
    private static void causeFire(Level world, BlockPos pos, RandomSource rand) {
        if (world.m_46469_().m_46207_(GameRules.f_46131_)) {
            int i = rand.m_188503_(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if (world.m_46749_(blockpos = blockpos.m_7918_(rand.m_188503_(3) - 1, 1, rand.m_188503_(3) - 1))) continue;
                    return;
                }
                BlockState blockstate = world.m_8055_(blockpos);
                if (blockstate.m_60795_()) {
                    if (PMFluid.hasFlammableNeighbours((LevelReader)world, blockpos)) {
                        world.m_46597_(blockpos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)world, (BlockPos)blockpos, (BlockPos)pos, (BlockState)Blocks.f_50083_.m_49966_()));
                        return;
                    }
                } else if (blockstate.m_280555_()) {
                    return;
                }
            }
        } else {
            for (int k = 0; k < 3; ++k) {
                BlockPos blockpos1 = pos.m_7918_(rand.m_188503_(3) - 1, 0, rand.m_188503_(3) - 1);
                if (!world.m_46749_(blockpos1)) {
                    return;
                }
                if (!world.m_46859_(blockpos1.m_7494_()) || !PMFluid.isFlammable((LevelReader)world, blockpos1, Direction.UP)) continue;
                world.m_46597_(blockpos1.m_7494_(), ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)world, (BlockPos)blockpos1.m_7494_(), (BlockPos)pos, (BlockState)Blocks.f_50083_.m_49966_()));
            }
        }
    }

    private static boolean hasFlammableNeighbours(LevelReader pLevel, BlockPos pPos) {
        for (Direction direction : Direction.values()) {
            if (!PMFluid.isFlammable(pLevel, pPos.m_121945_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFlammable(LevelReader world, BlockPos pos, Direction face) {
        return pos.m_123342_() >= world.m_141937_() && pos.m_123342_() < world.m_151558_() && !world.m_46805_(pos) ? false : world.m_8055_(pos).isFlammable((BlockGetter)world, pos, face);
    }

    public static class Flowing
    extends ForgeFlowingFluid.Flowing {
        private boolean isHot;

        public Flowing(ForgeFlowingFluid.Properties properties, boolean isHot) {
            super(properties);
            this.isHot = isHot;
        }

        protected void m_213812_(Level world, BlockPos pos, FluidState fluidState, RandomSource rand) {
            PMFluid.causeFire(world, pos, rand);
        }

        protected boolean m_6685_() {
            return this.isHot;
        }
    }

    public static class Source
    extends ForgeFlowingFluid.Source {
        private boolean isHot;

        public Source(ForgeFlowingFluid.Properties properties, boolean isHot) {
            super(properties);
            this.isHot = isHot;
        }

        protected void m_213812_(Level world, BlockPos pos, FluidState fluidState, RandomSource rand) {
            PMFluid.causeFire(world, pos, rand);
        }

        protected boolean m_6685_() {
            return this.isHot;
        }
    }
}

