/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.fluid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.base.Utils;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.building.Building;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.Ores;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.blocks.CustomCauldron;
import net.paradisemod.world.fluid.FluidPropertiesBuilder;
import net.paradisemod.world.fluid.PMCauldronInteractions;
import net.paradisemod.world.fluid.PMFluid;
import net.paradisemod.world.fluid.PMLiquidBlock;

public class PMFluids {
    public static final HashMap<RegistryObject<ForgeFlowingFluid>, Supplier<Item>> COLORED_BUCKETS = new HashMap();
    public static final ArrayList<RegisteredBlock> COLORED_CAULDRONS = new ArrayList();
    public static final DeferredRegister<Fluid> FLUIDS = PMRegistries.createRegistry(ForgeRegistries.FLUIDS);
    public static final RegistryObject<ForgeFlowingFluid> ENDER_ACID = PMFluids.getFluid("ender_acid", () -> ENDER_ACID_PROPERTIES, true, false);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_ENDER_ACID = PMFluids.getFluid("ender_acid", () -> ENDER_ACID_PROPERTIES, false, false);
    public static final RegisteredItem ENDER_ACID_BUCKET = PMFluids.regBucket(ENDER_ACID);
    public static final RegisteredBlock ENDER_ACID_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(ENDER_ACID, Blocks.f_49990_).lightLevel(15).animator((state, world, pos, rand) -> {
        if (rand.m_188503_(10) == 0) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123799_, (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + rand.m_188500_(), 0.0, 0.0, 0.0);
        }
    }).collideEvent((state, world, pos, entity) -> {
        if (entity instanceof ItemEntity) {
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity creature = (LivingEntity)entity;
            creature.m_6469_(world.m_269111_().m_269254_(), 2.0f);
        }
    }).translucentRender());
    public static final RegisteredBlock ENDER_ACID_CAULDRON = PMFluids.createCauldron(ENDER_ACID_BLOCK, PMCauldronInteractions.ENDER_ACID, true);
    public static final ForgeFlowingFluid.Properties ENDER_ACID_PROPERTIES = new FluidPropertiesBuilder(ENDER_ACID, FLOWING_ENDER_ACID, ENDER_ACID_BLOCK, ENDER_ACID_BUCKET).lightLevel(15).fogColor(-13631344).build();
    public static final RegistryObject<ForgeFlowingFluid> GLOWING_WATER = PMFluids.getFluid("glowing_water", () -> GLOWING_WATER_PROPERTIES, true, false);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_GLOWING_WATER = PMFluids.getFluid("glowing_water", () -> GLOWING_WATER_PROPERTIES, false, false);
    public static final RegisteredItem GLOWING_WATER_BUCKET = PMFluids.regBucket(GLOWING_WATER);
    public static final RegisteredBlock GLOWING_WATER_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(GLOWING_WATER, Blocks.f_49990_).lightLevel(15).animator((state, world, pos, rand) -> {
        if (rand.m_188503_(10) == 0) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + rand.m_188500_(), 0.0, 0.0, 0.0);
        }
    }).collideEvent((state, world, pos, entity) -> {
        if (entity instanceof LivingEntity) {
            LivingEntity creature = (LivingEntity)entity;
            creature.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100));
        }
    }).solidifyBlock(Misc.GLOWING_ICE).solidifySourceBlock(Misc.GLOWING_ICE).translucentRender());
    public static final RegisteredBlock GLOWING_WATER_CAULDRON = PMFluids.createCauldron(GLOWING_WATER_BLOCK, PMCauldronInteractions.GLOWING_WATER, true);
    public static final ForgeFlowingFluid.Properties GLOWING_WATER_PROPERTIES = new FluidPropertiesBuilder(GLOWING_WATER, FLOWING_GLOWING_WATER, GLOWING_WATER_BLOCK, GLOWING_WATER_BUCKET).fogColor(-16281970).lightLevel(15).build();
    public static final RegistryObject<ForgeFlowingFluid> PSYCHEDELIC_FLUID = PMFluids.getFluid("psychedelic_fluid", () -> PSYCHEDELIC_FLUID_PROPERTIES, true, false);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_PSYCHEDELIC_FLUID = PMFluids.getFluid("psychedelic_fluid", () -> PSYCHEDELIC_FLUID_PROPERTIES, false, false);
    public static final RegisteredItem PSYCHEDELIC_FLUID_BUCKET = PMFluids.regBucket(PSYCHEDELIC_FLUID);
    public static final RegisteredBlock PSYCHEDELIC_FLUID_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(PSYCHEDELIC_FLUID, Blocks.f_49990_).lightLevel(15));
    public static final RegisteredBlock PSYCHEDELIC_FLUID_CAULDRON = PMFluids.createCauldron(PSYCHEDELIC_FLUID_BLOCK, PMCauldronInteractions.PSYCHEDELIC, false);
    public static final ForgeFlowingFluid.Properties PSYCHEDELIC_FLUID_PROPERTIES = new FluidPropertiesBuilder(PSYCHEDELIC_FLUID, FLOWING_PSYCHEDELIC_FLUID, PSYCHEDELIC_FLUID_BLOCK, PSYCHEDELIC_FLUID_BUCKET).lightLevel(15).build();
    public static final RegistryObject<ForgeFlowingFluid> HONEY = PMFluids.getFluid("honey", () -> HONEY_PROPERTIES, true, false);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_HONEY = PMFluids.getFluid("honey", () -> HONEY_PROPERTIES, false, false);
    public static final RegisteredItem HONEY_BUCKET = PMFluids.regBucket(HONEY);
    public static final RegisteredBlock HONEY_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(HONEY, Blocks.f_49990_).solidifyBlock(Misc.HONEY_CRYSTAL_BLOCK).solidifySourceBlock(() -> Blocks.f_50719_).ambientSound(SoundEvents.f_11970_).translucentRender());
    public static final RegisteredBlock HONEY_CAULDRON = PMFluids.createCauldron(HONEY_BLOCK, PMCauldronInteractions.HONEY, true);
    public static final ForgeFlowingFluid.Properties HONEY_PROPERTIES = new FluidPropertiesBuilder(HONEY, FLOWING_HONEY, HONEY_BLOCK, HONEY_BUCKET).density(3000).temperature(500).viscosity(3000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(15).fogColor(-4022767).build();
    public static final RegistryObject<ForgeFlowingFluid> LIQUID_REDSTONE = PMFluids.getFluid("liquid_redstone", () -> LIQUID_REDSTONE_PROPERTIES, true, true);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_LIQUID_REDSTONE = PMFluids.getFluid("liquid_redstone", () -> LIQUID_REDSTONE_PROPERTIES, false, true);
    public static final RegisteredItem LIQUID_REDSTONE_BUCKET = PMFluids.regBucket(LIQUID_REDSTONE);
    public static final RegisteredBlock LIQUID_REDSTONE_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(LIQUID_REDSTONE, Blocks.f_49991_).solidifyBlock(() -> Blocks.f_50330_).solidifySourceBlock(PMWorld.SHATTERED_REDSTONE_BLOCK).hasRedstoneSignal(true).isHot(true).lightLevel(15));
    public static final RegisteredBlock LIQUID_REDSTONE_CAULDRON = PMFluids.createCauldron(LIQUID_REDSTONE_BLOCK, PMCauldronInteractions.LIQUID_REDSTONE, false);
    public static final ForgeFlowingFluid.Properties LIQUID_REDSTONE_PROPERTIES = new FluidPropertiesBuilder(LIQUID_REDSTONE, FLOWING_LIQUID_REDSTONE, LIQUID_REDSTONE_BLOCK, LIQUID_REDSTONE_BUCKET).canBecomeSource(false).density(3000).lightLevel(15).temperature(1300).viscosity(6000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(30).rendersLikeLava().tintColor(-65536).isHot().build();
    public static final RegistryObject<ForgeFlowingFluid> MOLTEN_SALT = PMFluids.getFluid("molten_salt", () -> MOLTEN_SALT_PROPERTIES, true, true);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_MOLTEN_SALT = PMFluids.getFluid("molten_salt", () -> MOLTEN_SALT_PROPERTIES, false, true);
    public static final RegisteredItem MOLTEN_SALT_BUCKET = PMFluids.regBucket(MOLTEN_SALT);
    public static final RegisteredBlock MOLTEN_SALT_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(MOLTEN_SALT, Blocks.f_49991_).solidifyBlock(Ores.COMPACT_SALT_BLOCK).solidifySourceBlock(Ores.COMPACT_SALT_BLOCK).isHot(true).lightLevel(15));
    public static final RegisteredBlock MOLTEN_SALT_CAULDRON = PMFluids.createCauldron(MOLTEN_SALT_BLOCK, PMCauldronInteractions.MOLTEN_SALT, false);
    public static final ForgeFlowingFluid.Properties MOLTEN_SALT_PROPERTIES = new FluidPropertiesBuilder(MOLTEN_SALT, FLOWING_MOLTEN_SALT, MOLTEN_SALT_BLOCK, MOLTEN_SALT_BUCKET).canBecomeSource(false).density(3000).lightLevel(15).temperature(1300).viscosity(1000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(10).rendersLikeLava().tintColor(-3116173).isHot().build();
    public static final RegistryObject<ForgeFlowingFluid> PSYCHEDELIC_LAVA = PMFluids.getFluid("psychedelic_lava", () -> PSYCHEDELIC_LAVA_PROPERTIES, true, true);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_PSYCHEDELIC_LAVA = PMFluids.getFluid("psychedelic_lava", () -> PSYCHEDELIC_LAVA_PROPERTIES, false, true);
    public static final RegisteredItem PSYCHEDELIC_LAVA_BUCKET = PMFluids.regBucket(PSYCHEDELIC_LAVA);
    public static final RegisteredBlock PSYCHEDELIC_LAVA_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(PSYCHEDELIC_LAVA, Blocks.f_49991_).isHot(true).lightLevel(15));
    public static final RegisteredBlock PSYCHEDELIC_LAVA_CAULDRON = PMFluids.createCauldron(PSYCHEDELIC_LAVA_BLOCK, PMCauldronInteractions.PSYCHEDELIC_LAVA, false);
    public static final ForgeFlowingFluid.Properties PSYCHEDELIC_LAVA_PROPERTIES = new FluidPropertiesBuilder(PSYCHEDELIC_LAVA, FLOWING_PSYCHEDELIC_LAVA, PSYCHEDELIC_LAVA_BLOCK, PSYCHEDELIC_LAVA_BUCKET).canBecomeSource(false).density(3000).lightLevel(15).temperature(1300).viscosity(6000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(30).rendersLikeLava().isHot().build();
    public static final RegistryObject<ForgeFlowingFluid> TAR = PMFluids.getFluid("tar", () -> TAR_PROPERTIES, true, false);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_TAR = PMFluids.getFluid("tar", () -> TAR_PROPERTIES, false, false);
    public static final RegisteredItem TAR_BUCKET = PMFluids.regBucket(TAR);
    public static final RegisteredBlock TAR_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(TAR, Blocks.f_49990_).solidifyBlock(Building.ASPHALT).solidifySourceBlock(Building.ASPHALT)).tag((TagKey<Block>)BlockTags.f_13058_);
    public static final RegisteredBlock TAR_CAULDRON = PMFluids.createCauldron(TAR_BLOCK, PMCauldronInteractions.TAR, false);
    public static final ForgeFlowingFluid.Properties TAR_PROPERTIES = new FluidPropertiesBuilder(TAR, FLOWING_TAR, TAR_BLOCK, TAR_BUCKET).canBecomeSource(true).viscosity(5000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(50).rendersLikeLava().tintColor(-15724528).build();
    public static final RegistryObject<ForgeFlowingFluid> DARK_LAVA = PMFluids.getFluid("dark_lava", () -> DARK_LAVA_PROPERTIES, true, true);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_DARK_LAVA = PMFluids.getFluid("dark_lava", () -> DARK_LAVA_PROPERTIES, false, true);
    public static final RegisteredItem DARK_LAVA_BUCKET = PMFluids.regBucket(DARK_LAVA);
    public static final RegisteredBlock DARK_LAVA_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(DARK_LAVA, Blocks.f_49991_).solidifyBlock(DeepDarkBlocks.DARKSTONE).solidifySourceBlock(Building.BLACK_GLOWING_OBSIDIAN).lightLevel(7).isHot(true));
    public static final RegisteredBlock DARK_LAVA_CAULDRON = PMFluids.createCauldron(DARK_LAVA_BLOCK, PMCauldronInteractions.DARK_LAVA, false);
    public static final ForgeFlowingFluid.Properties DARK_LAVA_PROPERTIES = new FluidPropertiesBuilder(DARK_LAVA, FLOWING_DARK_LAVA, DARK_LAVA_BLOCK, DARK_LAVA_BUCKET).canBecomeSource(false).density(3000).lightLevel(7).temperature(1300).viscosity(6000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(10).rendersLikeLava().tintColor(-13750738).isHot().build();
    public static final RegistryObject<ForgeFlowingFluid> MOLTEN_GOLD = PMFluids.getFluid("molten_gold", () -> MOLTEN_GOLD_PROPERTIES, true, true);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_MOLTEN_GOLD = PMFluids.getFluid("molten_gold", () -> MOLTEN_GOLD_PROPERTIES, false, true);
    public static final RegisteredItem MOLTEN_GOLD_BUCKET = PMFluids.regBucket(MOLTEN_GOLD);
    public static final RegisteredBlock MOLTEN_GOLD_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(MOLTEN_GOLD, Blocks.f_49991_).solidifyBlock(() -> Blocks.f_50074_).solidifySourceBlock(Building.GOLD_GLOWING_OBSIDIAN).lightLevel(15).isHot(true));
    public static final RegisteredBlock MOLTEN_GOLD_CAULDRON = PMFluids.createCauldron(MOLTEN_GOLD_BLOCK, PMCauldronInteractions.MOLTEN_GOLD, false);
    public static final ForgeFlowingFluid.Properties MOLTEN_GOLD_PROPERTIES = new FluidPropertiesBuilder(MOLTEN_GOLD, FLOWING_MOLTEN_GOLD, MOLTEN_GOLD_BLOCK, MOLTEN_GOLD_BUCKET).canBecomeSource(false).density(3000).lightLevel(15).temperature(1300).viscosity(6000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(10).rendersLikeLava().tintColor(-1789440).isHot().build();
    public static final RegistryObject<ForgeFlowingFluid> MOLTEN_SILVER = PMFluids.getFluid("molten_silver", () -> MOLTEN_SILVER_PROPERTIES, true, true);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_MOLTEN_SILVER = PMFluids.getFluid("molten_silver", () -> MOLTEN_SILVER_PROPERTIES, false, true);
    public static final RegisteredItem MOLTEN_SILVER_BUCKET = PMFluids.regBucket(MOLTEN_SILVER);
    public static final RegisteredBlock MOLTEN_SILVER_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(MOLTEN_SILVER, Blocks.f_49991_).solidifyBlock(Ores.SILVER_BLOCK).solidifySourceBlock(Building.SILVER_GLOWING_OBSIDIAN).lightLevel(15).isHot(true));
    public static final RegisteredBlock MOLTEN_SILVER_CAULDRON = PMFluids.createCauldron(MOLTEN_SILVER_BLOCK, PMCauldronInteractions.MOLTEN_SILVER, false);
    public static final ForgeFlowingFluid.Properties MOLTEN_SILVER_PROPERTIES = new FluidPropertiesBuilder(MOLTEN_SILVER, FLOWING_MOLTEN_SILVER, MOLTEN_SILVER_BLOCK, MOLTEN_SILVER_BUCKET).canBecomeSource(false).density(3000).lightLevel(15).temperature(1300).viscosity(6000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(10).rendersLikeLava().tintColor(-8092003).isHot().build();
    public static final RegistryObject<ForgeFlowingFluid> MOLTEN_IRON = PMFluids.getFluid("molten_iron", () -> MOLTEN_IRON_PROPERTIES, true, true);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_MOLTEN_IRON = PMFluids.getFluid("molten_iron", () -> MOLTEN_IRON_PROPERTIES, false, true);
    public static final RegisteredItem MOLTEN_IRON_BUCKET = PMFluids.regBucket(MOLTEN_IRON);
    public static final RegisteredBlock MOLTEN_IRON_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(MOLTEN_IRON, Blocks.f_49991_).solidifyBlock(() -> Blocks.f_50075_).solidifySourceBlock(Building.IRON_GLOWING_OBSIDIAN).lightLevel(15).isHot(true));
    public static final RegisteredBlock MOLTEN_IRON_CAULDRON = PMFluids.createCauldron(MOLTEN_IRON_BLOCK, PMCauldronInteractions.MOLTEN_IRON, false);
    public static final ForgeFlowingFluid.Properties MOLTEN_IRON_PROPERTIES = new FluidPropertiesBuilder(MOLTEN_IRON, FLOWING_MOLTEN_IRON, MOLTEN_IRON_BLOCK, MOLTEN_IRON_BUCKET).canBecomeSource(false).density(3000).lightLevel(15).temperature(1300).viscosity(6000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(10).rendersLikeLava().tintColor(-9276814).isHot().build();
    public static final RegistryObject<ForgeFlowingFluid> MOLTEN_COPPER = PMFluids.getFluid("molten_copper", () -> MOLTEN_COPPER_PROPERTIES, true, true);
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_MOLTEN_COPPER = PMFluids.getFluid("molten_copper", () -> MOLTEN_COPPER_PROPERTIES, false, true);
    public static final RegisteredItem MOLTEN_COPPER_BUCKET = PMFluids.regBucket(MOLTEN_COPPER);
    public static final RegisteredBlock MOLTEN_COPPER_BLOCK = PMFluids.createFluidBlock(new PMLiquidBlock.Builder(MOLTEN_COPPER, Blocks.f_49991_).solidifyBlock(() -> Blocks.f_152504_).solidifySourceBlock(Building.COPPER_GLOWING_OBSIDIAN).lightLevel(15).isHot(true));
    public static final RegisteredBlock MOLTEN_COPPER_CAULDRON = PMFluids.createCauldron(MOLTEN_COPPER_BLOCK, PMCauldronInteractions.MOLTEN_COPPER, false);
    public static final ForgeFlowingFluid.Properties MOLTEN_COPPER_PROPERTIES = new FluidPropertiesBuilder(MOLTEN_COPPER, FLOWING_MOLTEN_COPPER, MOLTEN_COPPER_BLOCK, MOLTEN_COPPER_BUCKET).canBecomeSource(false).density(3000).lightLevel(15).temperature(1300).viscosity(6000).fillSound(SoundEvents.f_11783_).emptySound(SoundEvents.f_11780_).tickRate(10).rendersLikeLava().tintColor(-8764147).isHot().build();

    public static void init(IEventBus eventbus) {
        FLUIDS.register(eventbus);
        FluidPropertiesBuilder.FLUID_TYPES.register(eventbus);
        eventbus.addListener(PMCauldronInteractions::init);
    }

    public static void initClient() {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ENDER_ACID.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FLOWING_ENDER_ACID.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)GLOWING_WATER.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FLOWING_GLOWING_WATER.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)HONEY.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FLOWING_HONEY.get()), (RenderType)RenderType.m_110466_());
    }

    private static RegisteredBlock createFluidBlock(PMLiquidBlock.Builder builder) {
        RegistryObject<ForgeFlowingFluid> stillFluid = builder.getFluid();
        String name = stillFluid.getKey().m_135782_().m_135815_();
        return ((RegisteredBlock)PMRegistries.regBlock(name, () -> builder.build()).localizedName(PMFluids.fluidName(stillFluid, false), PMFluids.fluidName(stillFluid, true))).noDrops();
    }

    private static RegisteredItem regBucket(RegistryObject<ForgeFlowingFluid> fluid) {
        return (RegisteredItem)((RegisteredItem)PMRegistries.regItem(fluid.getKey().m_135782_().m_135815_() + "_bucket", () -> new BucketItem((Supplier)fluid, new Item.Properties().m_41487_(1))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_)).model((item, generator) -> ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)generator.withExistingParent("item/" + fluid.getKey().m_135782_().m_135815_() + "_bucket", new ResourceLocation("forge", "item/bucket_drip"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid((Fluid)fluid.get())).localizedName(PMFluids.fluidName(fluid, false) + " Bucket", "Cubeta de " + PMFluids.fluidName(fluid, true).toLowerCase());
    }

    private static RegistryObject<ForgeFlowingFluid> getFluid(String name, Supplier<ForgeFlowingFluid.Properties> properties, boolean source, boolean hot) {
        return Utils.handlePossibleException(() -> FLUIDS.register((source ? "" : "flowing_") + name, () -> PMFluids.lambda$getFluid$38(source, (Supplier)properties, hot)));
    }

    private static RegisteredBlock createCauldron(RegisteredBlock fluidBlock, Map<Item, CauldronInteraction> interactions, boolean translucent) {
        RegisteredBlock cauldron = PMRegistries.regBlock(fluidBlock.shortName() + "_cauldron", () -> new CustomCauldron(fluidBlock, interactions, translucent)).dropsItem((ItemLike)Blocks.f_50256_).tag((TagKey<Block>)BlockTags.f_144269_);
        COLORED_CAULDRONS.add(cauldron);
        return cauldron;
    }

    public static String fluidName(RegistryObject<? extends Fluid> fluid, boolean spanish) {
        String name;
        return switch (name = fluid.getKey().m_135782_().m_135815_()) {
            case "ender_acid" -> {
                if (spanish) {
                    yield "\u00c1cido del Fin";
                }
                yield "Ender Acid";
            }
            case "glowing_water" -> {
                if (spanish) {
                    yield "Agua brillante";
                }
                yield "Glowing Water";
            }
            case "honey" -> {
                if (spanish) {
                    yield "Miel";
                }
                yield "Honey";
            }
            case "liquid_redstone" -> {
                if (spanish) {
                    yield "L\u00edquido de piedra roja";
                }
                yield "Liquid Redstone";
            }
            case "molten_salt" -> {
                if (spanish) {
                    yield "Sal fundida";
                }
                yield "Molten Salt";
            }
            case "psychedelic_lava" -> {
                if (spanish) {
                    yield "Lava psicod\u00e9lica";
                }
                yield "Psychedelic Lava";
            }
            case "psychedelic_fluid" -> {
                if (spanish) {
                    yield "Fluido psicod\u00e9lico";
                }
                yield "Psychedelic Fluid";
            }
            case "tar" -> {
                if (spanish) {
                    yield "Alquitr\u00e1n";
                }
                yield "Tar";
            }
            case "dark_lava" -> {
                if (spanish) {
                    yield "Lava oscura";
                }
                yield "Dark Lava";
            }
            case "molten_gold" -> {
                if (spanish) {
                    yield "Oro fundido";
                }
                yield "Molten Gold";
            }
            case "molten_silver" -> {
                if (spanish) {
                    yield "Plata fundida";
                }
                yield "Molten Silver";
            }
            case "molten_iron" -> {
                if (spanish) {
                    yield "Hierro fundido";
                }
                yield "Molten Iron";
            }
            case "molten_copper" -> {
                if (spanish) {
                    yield "Cobre fundido";
                }
                yield "Molten Copper";
            }
            default -> "";
        };
    }

    private static /* synthetic */ ForgeFlowingFluid lambda$getFluid$38(boolean source, Supplier properties, boolean hot) {
        return source ? new PMFluid.Source((ForgeFlowingFluid.Properties)properties.get(), hot) : new PMFluid.Flowing((ForgeFlowingFluid.Properties)properties.get(), hot);
    }
}

