/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.fluid;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.fluid.PMFluids;

public class PMLiquidBlock
extends LiquidBlock
implements ModeledBlock {
    @Nullable
    private List<Block> solidSourceBlocks;
    @Nullable
    private List<Block> solidBlocks;
    @Nullable
    private final SoundEvent ambientSound;
    @Nullable
    private final Animator animator;
    @Nullable
    private final EntityCollideEvent collideEvent;
    private final boolean isHot;
    private final boolean hasRedstoneSignal;
    private final RegistryObject<ForgeFlowingFluid> fluid;
    private final boolean translucentRender;
    private int lightLevel;

    private PMLiquidBlock(RegistryObject<ForgeFlowingFluid> fluid, BlockBehaviour.Properties properties, @Nullable List<Supplier<Block>> solidBlocks, @Nullable List<Supplier<Block>> solidSourceBlocks, @Nullable SoundEvent ambientSound, boolean isHot, @Nullable Animator animator, @Nullable EntityCollideEvent collideEvent, int lightLevel, boolean hasRedstoneSignal, boolean translucentRender) {
        super(fluid, properties);
        if (solidBlocks != null) {
            this.solidBlocks = solidBlocks.stream().map(Supplier::get).toList();
        }
        if (solidSourceBlocks != null) {
            this.solidSourceBlocks = solidSourceBlocks.stream().map(Supplier::get).toList();
        }
        this.ambientSound = ambientSound;
        this.isHot = isHot;
        this.animator = animator;
        this.collideEvent = collideEvent;
        this.hasRedstoneSignal = hasRedstoneSignal;
        this.fluid = fluid;
        this.translucentRender = translucentRender;
        this.lightLevel = lightLevel;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        double z;
        int y;
        double x;
        BlockPos blockpos;
        SoundEvent sound = this.ambientSound != null ? this.ambientSound : (this.isHot ? SoundEvents.f_12030_ : SoundEvents.f_12540_);
        FluidState fluid = state.m_60819_();
        if (this.animator != null) {
            this.animator.run(state, world, pos, rand);
        } else if (this.isHot) {
            blockpos = pos.m_7494_();
            if (world.m_8055_(blockpos).m_60795_() && !world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos) && rand.m_188503_(100) == 0) {
                x = (double)pos.m_123341_() + rand.m_188500_();
                y = pos.m_123342_() + 1;
                z = (double)pos.m_123343_() + rand.m_188500_();
                world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, (double)y, z, 0.0, 0.0, 0.0);
            }
        } else if (rand.m_188503_(10) == 0) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123768_, (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + rand.m_188500_(), (double)pos.m_123343_() + rand.m_188500_(), 0.0, 0.0, 0.0);
        }
        if (this.isHot) {
            blockpos = pos.m_7494_();
            if (world.m_8055_(blockpos).m_60795_() && !world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos)) {
                if (rand.m_188503_(100) == 0) {
                    x = (double)pos.m_123341_() + rand.m_188500_();
                    y = pos.m_123342_() + 1;
                    z = (double)pos.m_123343_() + rand.m_188500_();
                    world.m_7785_(x, (double)y, z, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + rand.m_188501_() * 0.2f, 0.9f + rand.m_188501_() * 0.15f, false);
                }
                if (rand.m_188503_(200) == 0) {
                    world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), sound, SoundSource.BLOCKS, 0.2f + rand.m_188501_() * 0.2f, 0.9f + rand.m_188501_() * 0.15f, false);
                }
            }
        } else if (!fluid.m_76170_() && !((Boolean)fluid.m_61143_((Property)FlowingFluid.f_75947_)).booleanValue() && rand.m_188503_(64) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, sound, SoundSource.BLOCKS, rand.m_188501_() * 0.25f + 0.75f, rand.m_188501_() + 0.5f, false);
        }
        if (this.fluid.getKey() == PMFluids.PSYCHEDELIC_LAVA.getKey() || this.fluid.getKey() == PMFluids.PSYCHEDELIC_FLUID.getKey()) {
            world.m_7260_(pos, state, state, 8);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (this.collideEvent != null) {
            this.collideEvent.process(state, world, pos, entity);
        }
        if (this.isHot) {
            RandomSource rand = world.m_213780_();
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                if (item.m_5825_()) {
                    return;
                }
                item.m_142687_(Entity.RemovalReason.KILLED);
                world.m_245747_(pos, SoundEvents.f_11937_, SoundSource.BLOCKS, rand.m_188501_() * 0.25f + 0.75f, rand.m_188501_() + 0.5f, false);
            } else {
                entity.m_7311_(300);
            }
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.solidify(world, pos, state);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.solidify(world, pos, state);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.hasRedstoneSignal ? 15 : 0;
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        String name = this.fluid.getKey().m_135782_().m_135815_();
        BlockModelBuilder model = (BlockModelBuilder)generator.models().getBuilder("block/fluid/" + name);
        if (this.translucentRender) {
            model = (BlockModelBuilder)model.renderType("translucent");
        }
        generator.simpleBlock((Block)this, (ModelFile)model);
    }

    public ForgeFlowingFluid getFluid() {
        return (ForgeFlowingFluid)this.fluid.get();
    }

    public int lightLevel() {
        return this.lightLevel;
    }

    private void solidify(Level world, BlockPos pos, BlockState curState) {
        FluidState currFluid = world.m_6425_(pos);
        if (this.solidBlocks == null || this.solidSourceBlocks == null) {
            if (this.fluid.getKey() == PMFluids.PSYCHEDELIC_LAVA.getKey()) {
                ITag<Block> sourceTagBlocks = Utils.getBlockTag(PMTags.Blocks.GLOWING_OBSIDIAN);
                ITag<Block> solidTagBlocks = Utils.getBlockTag((TagKey<Block>)Tags.Blocks.STONE);
                this.solidSourceBlocks = sourceTagBlocks.stream().toList();
                this.solidBlocks = solidTagBlocks.stream().toList();
            } else if (this.fluid.getKey() == PMFluids.PSYCHEDELIC_FLUID.getKey()) {
                this.solidSourceBlocks = List.of(Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50568_, Misc.GLOWING_ICE.get());
                this.solidBlocks = this.solidSourceBlocks;
            }
        }
        if (this.solidBlocks != null || this.solidSourceBlocks != null) {
            Block flowBlock = this.solidBlocks.get(world.f_46441_.m_188503_(this.solidBlocks.size()));
            Block sourceBlock = this.solidSourceBlocks.get(world.f_46441_.m_188503_(this.solidSourceBlocks.size()));
            for (Direction direction : Direction.values()) {
                BlockPos waterPos = pos.m_121945_(direction);
                FluidState water = world.m_6425_(waterPos);
                if (!water.m_205070_(FluidTags.f_13131_) || !this.isForeignFluid(world, waterPos)) continue;
                BlockPos placePos = pos.m_6625_(direction == Direction.DOWN ? 1 : 0);
                world.m_46597_(placePos, (currFluid.m_76170_() && direction != Direction.DOWN ? sourceBlock : flowBlock).m_49966_());
                if (this.isHot) {
                    this.m_54700_((LevelAccessor)world, placePos);
                }
                return;
            }
        }
        world.m_186469_(pos, currFluid.m_76152_(), currFluid.m_76152_().m_6718_((LevelReader)world));
    }

    private boolean isForeignFluid(Level world, BlockPos pos) {
        return !world.m_8055_(pos).m_60713_((Block)this);
    }

    private void m_54700_(LevelAccessor world, BlockPos pos) {
        world.m_46796_(1501, pos, 0);
    }

    @FunctionalInterface
    public static interface Animator {
        public void run(BlockState var1, Level var2, BlockPos var3, RandomSource var4);
    }

    @FunctionalInterface
    public static interface EntityCollideEvent {
        public void process(BlockState var1, Level var2, BlockPos var3, Entity var4);
    }

    public static class Builder {
        private final RegistryObject<ForgeFlowingFluid> fluid;
        private final Block fluidToMimic;
        private List<Supplier<Block>> solidSourceBlocks = null;
        private List<Supplier<Block>> solidBlocks = null;
        private SoundEvent ambientSound = null;
        private boolean isHot = false;
        private Animator animator = null;
        private EntityCollideEvent collideEvent = null;
        private int lightLevel = 0;
        private boolean hasRedstoneSignal = false;
        private boolean translucentRender = false;

        public Builder(RegistryObject<ForgeFlowingFluid> fluid, Block fluidToMimic) {
            this.fluid = fluid;
            this.fluidToMimic = fluidToMimic;
        }

        public Builder solidifyBlock(Supplier<Block> block) {
            this.solidBlocks = List.of(block);
            return this;
        }

        public Builder solidifySourceBlock(Supplier<Block> block) {
            this.solidSourceBlocks = List.of(block);
            return this;
        }

        public Builder ambientSound(SoundEvent sound) {
            this.ambientSound = sound;
            return this;
        }

        public Builder isHot(boolean isHot) {
            this.isHot = isHot;
            return this;
        }

        public Builder animator(Animator animator) {
            this.animator = animator;
            return this;
        }

        public Builder collideEvent(EntityCollideEvent event) {
            this.collideEvent = event;
            return this;
        }

        public Builder lightLevel(int lightLevel) {
            this.lightLevel = lightLevel;
            return this;
        }

        public Builder hasRedstoneSignal(boolean hasRedstoneSignal) {
            this.hasRedstoneSignal = hasRedstoneSignal;
            return this;
        }

        public Builder translucentRender() {
            this.translucentRender = true;
            return this;
        }

        public PMLiquidBlock build() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.fluidToMimic).m_60953_($ -> this.lightLevel).m_60910_().m_60978_(100.0f);
            if (this.isHot) {
                properties = properties.m_60977_();
            }
            return new PMLiquidBlock(this.fluid, properties, this.solidBlocks, this.solidSourceBlocks, this.ambientSound, this.isHot, this.animator, this.collideEvent, this.lightLevel, this.hasRedstoneSignal, this.translucentRender);
        }

        protected RegistryObject<ForgeFlowingFluid> getFluid() {
            return this.fluid;
        }
    }
}

