/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.trees;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.worldgen.features.foliage.PMFoliage;

public class AutumnTree
extends AbstractTreeGrower {
    public final Color color;

    public AutumnTree(Color color) {
        this.color = color;
    }

    @Nullable
    protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(RandomSource rand, boolean largeHive) {
        return largeHive ? PMFoliage.AUTUMN_SAPLING_TREES_BEES.get((Object)this.color) : PMFoliage.AUTUMN_SAPLING_TREES.get((Object)this.color);
    }

    public static enum Color {
        BLUE(4338589),
        ORANGE(15247177),
        RED(13454148),
        YELLOW(15124573);

        private final int leafColor;

        public int leafColor() {
            return this.leafColor;
        }

        private Color(int leafColor) {
            this.leafColor = leafColor;
        }

        public Block getLeaves() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BLUE -> Decoration.BLUE_AUTUMN_LEAVES.get();
                case ORANGE -> Decoration.ORANGE_AUTUMN_LEAVES.get();
                case RED -> Decoration.RED_AUTUMN_LEAVES.get();
                case YELLOW -> Decoration.YELLOW_AUTUMN_LEAVES.get();
            };
        }

        public String localizedSaplingColor(boolean spanish) {
            if (spanish) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case BLUE -> "azul";
                    case ORANGE -> "anaranjado";
                    case RED -> "rojo";
                    case YELLOW -> "amarillo";
                };
            }
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BLUE -> "Blue";
                case ORANGE -> "Orange";
                case RED -> "Red";
                case YELLOW -> "Yellow";
            };
        }

        public String localizedLeavesColor(boolean spanish) {
            if (spanish) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case BLUE -> "azules";
                    case ORANGE -> "anaranjadas";
                    case RED -> "rojas";
                    case YELLOW -> "amarillas";
                };
            }
            return this.localizedSaplingColor(false);
        }
    }

    public static enum WoodType {
        OAK(Blocks.f_49999_),
        BIRCH(Blocks.f_50001_),
        SPRUCE(Blocks.f_50000_);

        private final Block wood;

        private WoodType(Block wood) {
            this.wood = wood;
        }

        public Block getWood() {
            return this.wood;
        }
    }
}

