/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen;

import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.Ores;

public enum OreType {
    DARKSTONE_COAL(Ores.DARKSTONE_COAL_ORE, DeepDarkBlocks.DARKSTONE, 17, -48, 256, 2, "deepDark"),
    DARKSTONE_IRON(Ores.DARKSTONE_IRON_ORE, DeepDarkBlocks.DARKSTONE, 9, -48, 256, 4, "deepDark"),
    DARKSTONE_GOLD(Ores.DARKSTONE_GOLD_ORE, DeepDarkBlocks.DARKSTONE, 9, -48, 256, 8, "deepDark"),
    DARKSTONE_SILVER(Ores.DARKSTONE_SILVER_ORE, DeepDarkBlocks.DARKSTONE, 9, -48, 256, 8, "deepDark"),
    END_RUBY(Ores.END_RUBY_ORE, () -> Blocks.f_50259_, 8, 25, 70, 20, "end"),
    ENDERITE(Ores.ENDERITE_ORE, () -> Blocks.f_50259_, 4, 4, 30, 40, "end"),
    NETHER_SILVER(Ores.NETHER_SILVER_ORE, () -> Blocks.f_50134_, 9, 0, 128, 4, "netherSilver"),
    RUBY(Ores.RUBY_ORE, () -> Blocks.f_50069_, 8, 0, 16, 40, "overworld"),
    SALT(Ores.SALT_ORE, () -> Blocks.f_50069_, 8, 0, 320, 4, "overworld"),
    SILVER(Ores.SILVER_ORE, () -> Blocks.f_50069_, 9, 0, 128, 8, "overworld"),
    DEEPSLATE_RUBY(Ores.DEEPSLATE_RUBY_ORE, () -> Blocks.f_152550_, 8, -63, 0, 30, "overworld"),
    DEEPSLATE_SALT(Ores.DEEPSLATE_SALT_ORE, () -> Blocks.f_152550_, 8, -63, 0, 3, "overworld"),
    DEEPSLATE_SILVER(Ores.DEEPSLATE_SILVER_ORE, () -> Blocks.f_152550_, 9, -63, 0, 4, "overworld");

    private final Supplier<Block> ore;
    private final Supplier<Block> fillBlock;
    private final int maxVeinSize;
    private final int maxHeight;
    private final int minHeight;
    private final int rarity;
    private final String configKey;

    private OreType(Supplier<Block> ore, Supplier<Block> fillerBlock, int maxVeinSize, int minHeight, int maxHeight, int rarity, String configKey) {
        this.ore = ore;
        this.fillBlock = fillerBlock;
        this.maxVeinSize = maxVeinSize;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.rarity = rarity;
        this.configKey = configKey;
    }

    public Block getBlock() {
        return this.ore.get();
    }

    public int getRarity() {
        return this.rarity;
    }

    public int getMaxVeinSize() {
        return this.maxVeinSize;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public BlockMatchTest getGenRule() {
        return new BlockMatchTest(this.fillBlock.get());
    }

    public String configKey() {
        return this.configKey;
    }
}

