/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen;

import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.monsters.Monsters;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.carver.PMCarvers;
import net.paradisemod.worldgen.features.PMFeatures;
import net.paradisemod.worldgen.features.cave.PMCaveFeatures;
import net.paradisemod.worldgen.features.foliage.PMFoliage;
import net.paradisemod.worldgen.structures.PMStructures;

public class PMBiomeModifier
implements BiomeModifier {
    private static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = PMRegistries.createRegistry(ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS);
    public static final RegistryObject<Codec<PMBiomeModifier>> PM_BIOME_MOD_CODEC = BIOME_MODIFIER_SERIALIZERS.register("pm_biome_mod", () -> Codec.unit((Object)new PMBiomeModifier()));
    private Registry<ConfiguredWorldCarver<?>> carverRegistry;
    private Registry<PlacedFeature> placedFeatureRegistry;
    private BiomeGenerationSettingsBuilder genSettings;

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        RegistryAccess.Frozen regAccess = ServerLifecycleHooks.getCurrentServer().m_206579_();
        this.placedFeatureRegistry = regAccess.m_175515_(Registries.f_256988_);
        this.carverRegistry = regAccess.m_175515_(Registries.f_257003_);
        this.genSettings = builder.getGenerationSettings();
        if (phase == BiomeModifier.Phase.ADD) {
            if (!biome.m_203656_(BiomeTags.f_207612_)) {
                MobSpawnSettingsBuilder spawnInfo = builder.getMobSpawnSettings();
                spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(Monsters.GARGOYLE.get(), 40, 4, 4));
            }
            if (biome.m_203656_(BiomeTags.f_215818_)) {
                if (((Boolean)PMConfig.SETTINGS.betterEnd.enderAcid.get()).booleanValue()) {
                    this.addFeature(GenerationStep.Decoration.LAKES, PMFeatures.ENDER_ACID_LAKE);
                    this.addFeature(GenerationStep.Decoration.LAKES, PMFeatures.ENDER_ACID_LAKE_UNDERGROUND);
                    this.addFeature(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.ENDER_ACID_SPRING);
                }
                if (this.isVanilla(biome) && ((Boolean)PMConfig.SETTINGS.betterEnd.endFoliage.get()).booleanValue()) {
                    this.addFeature(PMFoliage.END_FOLIAGE);
                    this.addFeature(PMStructures.ROGUE_SPIKE);
                    if (biome.m_203565_(Biomes.f_48164_)) {
                        this.addFeature(PMFoliage.PM_CHORUS_PLANT);
                    }
                }
                this.addFeature(PMFeatures.RANDOM_END_CRYSTALS);
                this.addFeature(PMFeatures.MIXED_END_CRYSTALS);
                if (((Boolean)PMConfig.SETTINGS.betterEnd.enderCaves.get()).booleanValue()) {
                    this.addCarver(GenerationStep.Carving.AIR, PMCarvers.END_CAVES);
                    this.addCarver(GenerationStep.Carving.AIR, PMCarvers.END_CANYONS);
                    this.addFeature(PMFeatures.ENDERITE_GEODE);
                }
            }
            if (biome.m_203565_(PMBiomes.MESQUITE_FOREST)) {
                this.addFeature(PMFoliage.EXTRA_MESQUITE);
            }
            if (biome.m_203565_(PMBiomes.PALO_VERDE_FOREST)) {
                this.addFeature(PMFoliage.EXTRA_PALO_VERDE);
            }
            if (biome.m_203565_(Biomes.f_48182_)) {
                this.addFeature(PMFeatures.ICE_SPIRE);
            }
            if (biome.m_203565_(PMBiomes.ICE_SPIKES_CAVE)) {
                this.addFeature(PMFeatures.ICE_SPIRE_OWC);
            }
            if (biome.m_203565_(Biomes.f_48208_)) {
                this.addFeature(PMFoliage.GALLERY_FOREST);
            }
            if (biome.m_203656_(BiomeTags.f_207612_)) {
                this.addFeature(PMFoliage.SOUL_PUMPKIN_PATCH);
                this.addFeature(PMFeatures.QUARTZ_CRYSTALS);
                this.addFeature(PMFeatures.QUARTZ_GEODE_NETHER);
            } else if (!biome.m_203565_(Biomes.f_220594_)) {
                if (!biome.m_203656_(PMTags.Biomes.ROSE_FIELDS) && !biome.m_203656_(Tags.Biomes.IS_DRY) && biome.m_203656_(BiomeTags.f_215817_)) {
                    this.addFeature(PMFoliage.ROSES);
                }
                if (biome.m_203656_(BiomeTags.f_215817_) || biome.m_203656_(PMTags.Biomes.OVERWORLD_CORE) || biome.m_203656_(PMTags.Biomes.ELYSIUM)) {
                    if (biome.m_203656_(BiomeTags.f_207606_)) {
                        this.addFeature(PMFeatures.EMERALD_GEODE);
                    }
                    this.addFeature(PMStructures.HOME);
                    this.addFeature(PMStructures.RESEARCH_BASE);
                    this.addFeature(PMStructures.SMALL_STRONGHOLD);
                    this.addFeature(PMFeatures.SALT_CRYSTALS);
                    this.addFeature(PMFeatures.MIXED_CRYSTALS);
                    this.addFeature(PMFeatures.RANDOM_CRYSTALS);
                    this.addFeature(PMFeatures.TAR_SPRING);
                    this.addFeature(PMFeatures.DIAMOND_GEODE);
                    this.addFeature(PMFeatures.LAPIS_GEODE);
                    this.addFeature(PMFeatures.QUARTZ_GEODE);
                    this.addFeature(PMFeatures.REDSTONE_GEODE);
                    this.addFeature(PMFeatures.RUBY_GEODE);
                    this.addFeature(PMFeatures.SALT_GEODE);
                }
                if (biome.m_203656_(BiomeTags.f_215817_) || biome.m_203656_(PMTags.Biomes.ELYSIUM)) {
                    this.addFeature(PMFeatures.FALLEN_TREE);
                    this.addFeature(PMStructures.LANDMINE);
                    this.addFeature(PMStructures.EASTER_EGG_1);
                    this.addFeature(PMStructures.EASTER_EGG_2);
                    this.addFeature(PMStructures.REBELS_1);
                    this.addFeature(PMStructures.REBELS_2);
                    this.addFeature(PMStructures.RUNWAY);
                    this.addFeature(PMStructures.BLACK_CROSS);
                    this.addFeature(PMStructures.GOLD_CROSS);
                    this.addFeature(PMStructures.CREATOR_HEADS);
                    if (PMBiomes.isSandyDesert(biome) || biome.m_203656_(BiomeTags.f_207607_)) {
                        this.addFeature(PMFoliage.PRICKLY_PEAR);
                    }
                }
                if (biome.m_203656_(BiomeTags.f_215817_) || biome.m_203656_(PMTags.Biomes.ELYSIUM) || biome.m_203656_(PMTags.Biomes.OVERWORLD_CORE)) {
                    this.addFeature(GenerationStep.Decoration.LAKES, PMFeatures.TAR_PIT);
                    if (!biome.m_203656_(Tags.Biomes.IS_WATER)) {
                        this.addFeature(GenerationStep.Decoration.LAKES, PMFeatures.WATER_LAKE);
                        this.addFeature(GenerationStep.Decoration.LAKES, PMFeatures.WATER_LAKE_UNDERGROUND);
                    }
                }
                if (!biome.m_203656_(PMTags.Biomes.ROCKY_DESERTS) && !biome.m_203656_(BiomeTags.f_215818_)) {
                    this.addFeature(PMStructures.RUINS);
                }
                if (biome.m_203656_(BiomeTags.f_207603_)) {
                    this.addFeature(PMStructures.BUOY);
                }
            }
            for (ResourceKey<PlacedFeature> oreFeature : PMFeatures.ORES) {
                this.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, oreFeature);
            }
            this.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PMCaveFeatures.CAVE_FORMATIONS);
            this.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PMCaveFeatures.CAVE_BLOCKS);
            if (!biome.m_203656_(BiomeTags.f_207612_)) {
                this.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PMCaveFeatures.CAVE_FOLIAGE);
            }
            if (biome.m_203656_(BiomeTags.f_207610_) || biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                this.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PMCaveFeatures.CAVE_VINE);
            }
            this.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.RAW_CHUNK_PROCESSOR);
            this.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PMFeatures.VEGETAL_CHUNK_PROCESSOR);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)PM_BIOME_MOD_CODEC.get();
    }

    private void addFeature(GenerationStep.Decoration step, ResourceKey<PlacedFeature> key) {
        Holder.Reference feature = this.placedFeatureRegistry.m_246971_(key);
        this.genSettings.m_255419_(step, (Holder)feature);
    }

    private void addFeature(ResourceKey<PlacedFeature> key) {
        this.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, key);
    }

    private void addCarver(GenerationStep.Carving step, ResourceKey<ConfiguredWorldCarver<?>> key) {
        Holder.Reference carver = this.carverRegistry.m_246971_(key);
        this.genSettings.m_254863_(step, (Holder)carver);
    }

    private boolean isVanilla(Holder<Biome> biome) {
        ResourceKey key = (ResourceKey)biome.m_203543_().get();
        ResourceLocation resourceName = key.m_135782_();
        String namespace = resourceName.m_135827_();
        return namespace == "minecraft" || namespace == "";
    }

    public static void init(IEventBus eventBus) {
        BIOME_MODIFIER_SERIALIZERS.register(eventBus);
    }

    public static void buildBiomeModifier(BootstapContext<BiomeModifier> context) {
        ParadiseMod.LOG.debug("Generating biome modifiers...");
        context.m_255272_(PMRegistries.createModResourceKey(ForgeRegistries.Keys.BIOME_MODIFIERS, "pm_biome_mod"), (Object)new PMBiomeModifier());
    }
}

