/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.carver;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.TrapezoidFloat;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.base.Utils;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.PMWorld;
import net.paradisemod.worldgen.carver.PMCanyon;
import net.paradisemod.worldgen.carver.PMCave;
import net.paradisemod.worldgen.features.PMFeatures;

public class PMCarvers {
    private static final DeferredRegister<WorldCarver<?>> CARVERS = PMRegistries.createRegistry(ForgeRegistries.WORLD_CARVERS);
    public static HashMap<ResourceKey<ConfiguredWorldCarver<?>>, CarverFactory> CFG_CARVERS = new HashMap();
    public static final ResourceKey<ConfiguredWorldCarver<?>> DEEP_DARK_CAVES = PMCarvers.getCarver("deep_dark_caves", PMCave::new, () -> PMCarvers.caveConfig(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_, DeepDarkBlocks.GLOWING_NYLIUM.get(), DeepDarkBlocks.OVERGROWN_DARKSTONE.get(), DeepDarkBlocks.BLACKENED_SANDSTONE.get(), DeepDarkBlocks.BLACKENED_SAND.get()));
    public static final ResourceKey<ConfiguredWorldCarver<?>> DEEP_DARK_CANYONS = PMCarvers.getCarver("deep_dark_canyons", PMCanyon::new, () -> PMCarvers.canyonConfig(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_, DeepDarkBlocks.GLOWING_NYLIUM.get(), DeepDarkBlocks.OVERGROWN_DARKSTONE.get(), DeepDarkBlocks.BLACKENED_SANDSTONE.get(), DeepDarkBlocks.BLACKENED_SAND.get()));
    public static final ResourceKey<ConfiguredWorldCarver<?>> ICE_CAVES = PMCarvers.getCarver("ice_caves", PMCave::new, PMCarvers::iceCaveConfig);
    public static final ResourceKey<ConfiguredWorldCarver<?>> CREVASSE = PMCarvers.getCarver("crevasse", PMCanyon::new, PMCarvers::crevasseConfig);
    public static final ResourceKey<ConfiguredWorldCarver<?>> END_CAVES = PMCarvers.getCarver("end_caves", PMCave::new, () -> PMCarvers.caveConfig(Blocks.f_50259_, PMWorld.OVERGROWN_END_STONE.get()));
    public static final ResourceKey<ConfiguredWorldCarver<?>> END_CANYONS = PMCarvers.getCarver("end_canyons", PMCanyon::new, () -> PMCarvers.canyonConfig(Blocks.f_50259_, PMWorld.OVERGROWN_END_STONE.get()));

    public static void init(IEventBus eventbus) {
        CARVERS.register(eventbus);
    }

    private static <WC extends CarverConfiguration> ResourceKey<ConfiguredWorldCarver<?>> getCarver(String name, Supplier<WorldCarver<WC>> carver, Supplier<WC> config) {
        RegistryObject regCarver = Utils.handlePossibleException(() -> CARVERS.register(name, carver));
        ResourceKey key = PMRegistries.createModResourceKey(Registries.f_257003_, name);
        CFG_CARVERS.put(key, () -> ((WorldCarver)regCarver.get()).m_65063_((CarverConfiguration)config.get()));
        return key;
    }

    private static CaveCarverConfiguration iceCaveConfig() {
        return new CaveCarverConfiguration(0.75f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)-50), (VerticalAnchor)VerticalAnchor.m_158922_((int)180)), (FloatProvider)UniformFloat.m_146605_((float)0.1f, (float)0.9f), VerticalAnchor.m_158930_((int)10), CarverDebugSettings.m_159136_((boolean)false, (BlockState)Blocks.f_50214_.m_49966_()), PMFeatures.blockList(Blocks.f_50016_), (FloatProvider)UniformFloat.m_146605_((float)0.7f, (float)1.4f), (FloatProvider)UniformFloat.m_146605_((float)0.8f, (float)1.3f), (FloatProvider)UniformFloat.m_146605_((float)-1.0f, (float)-0.4f));
    }

    private static CanyonCarverConfiguration crevasseConfig() {
        return new CanyonCarverConfiguration(0.5f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)-50), (VerticalAnchor)VerticalAnchor.m_158922_((int)180)), (FloatProvider)ConstantFloat.m_146458_((float)3.0f), VerticalAnchor.m_158930_((int)10), CarverDebugSettings.m_159136_((boolean)false, (BlockState)Blocks.f_50214_.m_49966_()), PMFeatures.blockList(Blocks.f_50016_), (FloatProvider)UniformFloat.m_146605_((float)-0.125f, (float)0.125f), new CanyonCarverConfiguration.CanyonShapeConfiguration((FloatProvider)UniformFloat.m_146605_((float)0.75f, (float)1.0f), (FloatProvider)TrapezoidFloat.m_146571_((float)0.0f, (float)6.0f, (float)2.0f), 3, (FloatProvider)UniformFloat.m_146605_((float)0.75f, (float)1.0f), 1.0f, 0.0f));
    }

    private static CaveCarverConfiguration caveConfig(Block ... replaceables) {
        return new CaveCarverConfiguration(0.5f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158922_((int)180)), (FloatProvider)UniformFloat.m_146605_((float)0.1f, (float)0.9f), VerticalAnchor.m_158930_((int)10), CarverDebugSettings.m_159136_((boolean)false, (BlockState)Blocks.f_50016_.m_49966_()), PMFeatures.blockList(replaceables), (FloatProvider)UniformFloat.m_146605_((float)0.7f, (float)1.4f), (FloatProvider)UniformFloat.m_146605_((float)0.8f, (float)1.3f), (FloatProvider)UniformFloat.m_146605_((float)-1.0f, (float)-0.4f));
    }

    private static CanyonCarverConfiguration canyonConfig(Block ... replaceables) {
        return new CanyonCarverConfiguration(0.25f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158922_((int)180)), (FloatProvider)ConstantFloat.m_146458_((float)3.0f), VerticalAnchor.m_158930_((int)10), CarverDebugSettings.m_159136_((boolean)false, (BlockState)Blocks.f_50016_.m_49966_()), PMFeatures.blockList(replaceables), (FloatProvider)UniformFloat.m_146605_((float)-0.125f, (float)0.125f), new CanyonCarverConfiguration.CanyonShapeConfiguration((FloatProvider)UniformFloat.m_146605_((float)0.75f, (float)1.0f), (FloatProvider)TrapezoidFloat.m_146571_((float)0.0f, (float)6.0f, (float)2.0f), 3, (FloatProvider)UniformFloat.m_146605_((float)0.75f, (float)1.0f), 1.0f, 0.0f));
    }

    @FunctionalInterface
    public static interface CarverFactory
    extends PMWorld.WorldgenFactory<ConfiguredWorldCarver<?>> {
        public ConfiguredWorldCarver<?> get();

        @Override
        default public ConfiguredWorldCarver<?> generate(BootstapContext<ConfiguredWorldCarver<?>> context) {
            return this.get();
        }
    }
}

