/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.QuarkBlocks;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.building.Building;
import net.paradisemod.building.Doors;
import net.paradisemod.building.FenceGates;
import net.paradisemod.building.Fences;
import net.paradisemod.building.Slabs;
import net.paradisemod.building.Stairs;
import net.paradisemod.building.Trapdoors;
import net.paradisemod.decoration.ColoredLanterns;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.decoration.Tables;
import net.paradisemod.misc.Chests;
import net.paradisemod.redstone.Lamps;
import net.paradisemod.redstone.Plates;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.biome.PMBiomes;

public abstract class BasicFeature
extends Feature<NoneFeatureConfiguration> {
    private Registry<ConfiguredFeature<?, ?>> cfgFeatureRegistry;
    private Registry<PlacedFeature> placedFeatureRegistry;

    public BasicFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RegistryAccess regAccess = world.m_9598_();
        this.cfgFeatureRegistry = (Registry)regAccess.m_6632_(Registries.f_256911_).get();
        this.placedFeatureRegistry = (Registry)regAccess.m_6632_(Registries.f_256988_).get();
        return Utils.handlePossibleException(() -> this.placeFeature(world, context.m_225041_(), context.m_159777_(), context.m_159775_()));
    }

    protected final ConfiguredFeature<?, ?> getConfiguredFeature(ResourceKey<ConfiguredFeature<?, ?>> key) {
        return (ConfiguredFeature)this.cfgFeatureRegistry.m_123013_(key);
    }

    protected final Holder<ConfiguredFeature<?, ?>> getConfiguredFeatureHolder(ResourceKey<ConfiguredFeature<?, ?>> key) {
        return this.cfgFeatureRegistry.m_246971_(key);
    }

    protected final PlacedFeature getPlacedFeature(ResourceKey<PlacedFeature> key) {
        return (PlacedFeature)this.placedFeatureRegistry.m_123013_(key);
    }

    protected final Holder<PlacedFeature> getPlacedFeatureHolder(ResourceKey<PlacedFeature> key) {
        return this.placedFeatureRegistry.m_246971_(key);
    }

    protected abstract boolean placeFeature(WorldGenLevel var1, RandomSource var2, BlockPos var3, ChunkGenerator var4);

    protected static boolean isUndergroundAreaValid(WorldGenLevel world, BlockPos pos, int sizeX, int sizeY, int sizeZ) {
        List<Block> surfaceBlocks = List.of(Blocks.f_50440_, Blocks.f_50195_, Blocks.f_50599_, Blocks.f_50546_, DeepDarkBlocks.GLOWING_NYLIUM.get(), DeepDarkBlocks.OVERGROWN_DARKSTONE.get());
        int numValidBlocks = 0;
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    BlockPos newPos = pos.m_7918_(x, y, z);
                    BlockState blockstate = world.m_8055_(newPos);
                    if (surfaceBlocks.contains(blockstate.m_60734_())) {
                        return false;
                    }
                    if (!blockstate.m_60713_(DeepDarkBlocks.REGENERATION_STONE.get()) && !blockstate.m_60713_(DeepDarkBlocks.DARKSTONE.get()) && !blockstate.m_60713_(Blocks.f_152550_)) continue;
                    ++numValidBlocks;
                }
            }
        }
        return (float)numValidBlocks / (float)(sizeX * sizeY * sizeZ) >= 0.5f;
    }

    protected static boolean isFlat(WorldGenLevel world, BlockPos structurePos, int sizeX, int sizeZ, boolean checkAir) {
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                BlockPos newPosAbove;
                BlockState stateAbove;
                BlockPos newPos = structurePos.m_7918_(x, -1, z);
                if (!(checkAir ? (stateAbove = world.m_8055_(newPosAbove = structurePos.m_7918_(x, 0, z))).m_60815_() && !stateAbove.m_60713_(Blocks.f_50125_) || !world.m_8055_(newPos).m_60815_() : !world.m_8055_(newPos).m_60815_())) continue;
                return false;
            }
        }
        return true;
    }

    public static List<Block> getWood(RandomSource rand, Holder<Biome> biome) {
        Block fence = Blocks.f_50132_;
        Block fenceGate = Blocks.f_50192_;
        Block craftingTable = Blocks.f_50091_;
        Block log = Blocks.f_49999_;
        Block plate = Blocks.f_50167_;
        Block planks = Blocks.f_50705_;
        Block stairs = Blocks.f_50086_;
        Block door = Blocks.f_50154_;
        Block chest = QuarkBlocks.OAK_CHEST;
        Block trapdoor = Blocks.f_50216_;
        Block bookShelf = Blocks.f_50078_;
        Block strippedLog = Blocks.f_50010_;
        Block slab = Blocks.f_50398_;
        if (biome.m_203565_(PMBiomes.AUTUMN_FOREST) || biome.m_203565_(PMBiomes.UNDERGROUND_AUTUMN_FOREST)) {
            switch (rand.m_188503_(3)) {
                case 1: {
                    fence = Blocks.f_50480_;
                    fenceGate = Blocks.f_50475_;
                    craftingTable = Tables.BIRCH_CRAFTING_TABLE.get();
                    log = Blocks.f_50001_;
                    plate = Blocks.f_50169_;
                    planks = Blocks.f_50742_;
                    stairs = Blocks.f_50270_;
                    door = Blocks.f_50485_;
                    chest = QuarkBlocks.BIRCH_CHEST;
                    trapdoor = Blocks.f_50218_;
                    bookShelf = QuarkBlocks.BIRCH_BOOKSHELF;
                    strippedLog = Blocks.f_50006_;
                    slab = Blocks.f_50400_;
                    break;
                }
                case 2: {
                    fence = Blocks.f_50479_;
                    fenceGate = Blocks.f_50474_;
                    craftingTable = Tables.SPRUCE_CRAFTING_TABLE.get();
                    log = Blocks.f_50000_;
                    plate = Blocks.f_50168_;
                    planks = Blocks.f_50741_;
                    stairs = Blocks.f_50269_;
                    door = Blocks.f_50484_;
                    chest = QuarkBlocks.SPRUCE_CHEST;
                    trapdoor = Blocks.f_50217_;
                    bookShelf = QuarkBlocks.SPRUCE_BOOKSHELF;
                    strippedLog = Blocks.f_50005_;
                    slab = Blocks.f_50399_;
                }
            }
        } else if (biome.m_203565_(Biomes.f_48151_) || biome.m_203565_(PMBiomes.UNDERGROUND_DARK_FOREST)) {
            fence = Blocks.f_50483_;
            fenceGate = Blocks.f_50478_;
            craftingTable = Tables.DARK_OAK_CRAFTING_TABLE.get();
            log = Blocks.f_50004_;
            plate = Blocks.f_50172_;
            planks = Blocks.f_50745_;
            stairs = Blocks.f_50373_;
            door = Blocks.f_50488_;
            chest = QuarkBlocks.DARK_OAK_CHEST;
            trapdoor = Blocks.f_50221_;
            bookShelf = QuarkBlocks.DARK_OAK_BOOKSHELF;
            strippedLog = Blocks.f_50009_;
            slab = Blocks.f_50403_;
        } else if (biome.m_203565_(PMBiomes.WEEPING_FOREST) || biome.m_203565_(PMBiomes.FROZEN_WEEPING_FOREST)) {
            if (rand.m_188499_()) {
                fence = Blocks.f_50479_;
                fenceGate = Blocks.f_50474_;
                craftingTable = Tables.SPRUCE_CRAFTING_TABLE.get();
                log = Blocks.f_50000_;
                plate = Blocks.f_50168_;
                planks = Blocks.f_50741_;
                stairs = Blocks.f_50269_;
                door = Blocks.f_50484_;
                chest = QuarkBlocks.SPRUCE_CHEST;
                trapdoor = Blocks.f_50217_;
                bookShelf = QuarkBlocks.SPRUCE_BOOKSHELF;
                strippedLog = Blocks.f_50005_;
                slab = Blocks.f_50399_;
            }
        } else if (biome.m_203565_(Biomes.f_271432_) || biome.m_203565_(PMBiomes.UNDERGROUND_CHERRY_FOREST)) {
            fence = Blocks.f_271219_;
            fenceGate = Blocks.f_271274_;
            craftingTable = Tables.CHERRY_CRAFTING_TABLE.get();
            log = Blocks.f_271170_;
            plate = Blocks.f_271227_;
            planks = Blocks.f_271304_;
            stairs = Blocks.f_271206_;
            door = Blocks.f_271169_;
            chest = QuarkBlocks.CHERRY_CHEST;
            trapdoor = Blocks.f_271350_;
            bookShelf = QuarkBlocks.CHERRY_BOOKSHELF;
            strippedLog = Blocks.f_271326_;
            slab = Blocks.f_271301_;
        } else if (biome.m_203565_(Biomes.f_220595_) || biome.m_203565_(PMBiomes.UNDERGROUND_MANGROVE_SWAMP)) {
            fence = Blocks.f_220852_;
            fenceGate = Blocks.f_220850_;
            craftingTable = Tables.MANGROVE_CRAFTING_TABLE.get();
            log = Blocks.f_220832_;
            plate = Blocks.f_220840_;
            planks = Blocks.f_220865_;
            stairs = Blocks.f_220848_;
            door = Blocks.f_220853_;
            chest = QuarkBlocks.MANGROVE_CHEST;
            trapdoor = Blocks.f_220842_;
            bookShelf = QuarkBlocks.MANGROVE_BOOKSHELF;
            strippedLog = Blocks.f_220835_;
            slab = Blocks.f_220851_;
        } else if (biome.m_203565_(Biomes.f_48149_) || biome.m_203565_(Biomes.f_186762_) || biome.m_203565_(PMBiomes.UNDERGROUND_BIRCH_FOREST)) {
            fence = Blocks.f_50480_;
            fenceGate = Blocks.f_50475_;
            craftingTable = Tables.BIRCH_CRAFTING_TABLE.get();
            log = Blocks.f_50001_;
            plate = Blocks.f_50169_;
            planks = Blocks.f_50742_;
            stairs = Blocks.f_50270_;
            door = Blocks.f_50485_;
            chest = QuarkBlocks.BIRCH_CHEST;
            trapdoor = Blocks.f_50218_;
            bookShelf = QuarkBlocks.BIRCH_BOOKSHELF;
            strippedLog = Blocks.f_50006_;
            slab = Blocks.f_50400_;
        } else if (biome.m_203565_(PMBiomes.TEMPERATE_RAINFOREST) || biome.m_203565_(PMBiomes.UNDERGROUND_TEMPERATE_RAINFOREST)) {
            switch (rand.m_188503_(4)) {
                case 1: {
                    fence = Blocks.f_50480_;
                    fenceGate = Blocks.f_50475_;
                    craftingTable = Tables.BIRCH_CRAFTING_TABLE.get();
                    log = Blocks.f_50001_;
                    plate = Blocks.f_50169_;
                    planks = Blocks.f_50742_;
                    stairs = Blocks.f_50270_;
                    door = Blocks.f_50485_;
                    chest = QuarkBlocks.BIRCH_CHEST;
                    trapdoor = Blocks.f_50218_;
                    bookShelf = QuarkBlocks.BIRCH_BOOKSHELF;
                    strippedLog = Blocks.f_50006_;
                    slab = Blocks.f_50400_;
                    break;
                }
                case 2: {
                    fence = Blocks.f_50481_;
                    fenceGate = Blocks.f_50476_;
                    craftingTable = Tables.JUNGLE_CRAFTING_TABLE.get();
                    log = Blocks.f_50002_;
                    plate = Blocks.f_50170_;
                    planks = Blocks.f_50743_;
                    stairs = Blocks.f_50271_;
                    door = Blocks.f_50486_;
                    chest = QuarkBlocks.JUNGLE_CHEST;
                    trapdoor = Blocks.f_50219_;
                    bookShelf = QuarkBlocks.JUNGLE_BOOKSHELF;
                    strippedLog = Blocks.f_50007_;
                    slab = Blocks.f_50401_;
                    break;
                }
                case 3: {
                    fence = Blocks.f_50479_;
                    fenceGate = Blocks.f_50474_;
                    craftingTable = Tables.SPRUCE_CRAFTING_TABLE.get();
                    log = Blocks.f_50000_;
                    plate = Blocks.f_50168_;
                    planks = Blocks.f_50741_;
                    stairs = Blocks.f_50269_;
                    door = Blocks.f_50484_;
                    chest = QuarkBlocks.SPRUCE_CHEST;
                    trapdoor = Blocks.f_50217_;
                    bookShelf = QuarkBlocks.SPRUCE_BOOKSHELF;
                    strippedLog = Blocks.f_50005_;
                    slab = Blocks.f_50399_;
                }
            }
        } else if (biome.m_203656_(PMTags.Biomes.DEEP_DARK)) {
            fence = Fences.BLACKENED_OAK_FENCE.get();
            fenceGate = FenceGates.BLACKENED_OAK_FENCE_GATE.get();
            craftingTable = Tables.BLACKENED_OAK_CRAFTING_TABLE.get();
            log = DeepDarkBlocks.BLACKENED_OAK_LOG.get();
            plate = Plates.BLACKENED_OAK_PRESSURE_PLATE.get();
            planks = DeepDarkBlocks.BLACKENED_OAK_PLANKS.get();
            stairs = Stairs.BLACKENED_OAK_STAIRS.get();
            door = Doors.BLACKENED_OAK_DOOR.get();
            chest = Chests.BLACKENED_OAK_CHEST;
            trapdoor = Trapdoors.BLACKENED_OAK_TRAPDOOR.get();
            bookShelf = Decoration.BLACKENED_OAK_BOOKSHELF.get();
            strippedLog = DeepDarkBlocks.STRIPPED_BLACKENED_OAK_LOG.get();
            slab = Slabs.BLACKENED_OAK_SLAB.get();
            if (biome.m_203565_(PMBiomes.TAIGA_INSOMNIUM) || biome.m_203656_(PMTags.Biomes.COLD_DEEP_DARK)) {
                fence = Fences.BLACKENED_SPRUCE_FENCE.get();
                fenceGate = FenceGates.BLACKENED_SPRUCE_FENCE_GATE.get();
                craftingTable = Tables.BLACKENED_SPRUCE_CRAFTING_TABLE.get();
                log = DeepDarkBlocks.BLACKENED_SPRUCE_LOG.get();
                plate = Plates.BLACKENED_SPRUCE_PRESSURE_PLATE.get();
                planks = DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS.get();
                stairs = Stairs.BLACKENED_SPRUCE_STAIRS.get();
                door = Doors.BLACKENED_SPRUCE_DOOR.get();
                chest = Chests.BLACKENED_SPRUCE_CHEST;
                trapdoor = Trapdoors.BLACKENED_SPRUCE_TRAPDOOR.get();
                bookShelf = Decoration.BLACKENED_SPRUCE_BOOKSHELF.get();
                strippedLog = DeepDarkBlocks.STRIPPED_BLACKENED_SPRUCE_LOG.get();
                slab = Slabs.BLACKENED_SPRUCE_SLAB.get();
            } else if (biome.m_203565_(PMBiomes.GLOWING_FOREST) || biome.m_203565_(PMBiomes.CRYSTAL_FOREST)) {
                fence = Fences.GLOWING_OAK_FENCE.get();
                fenceGate = FenceGates.GLOWING_OAK_FENCE_GATE.get();
                craftingTable = Tables.GLOWING_OAK_CRAFTING_TABLE.get();
                log = DeepDarkBlocks.GLOWING_OAK_LOG.get();
                plate = Plates.GLOWING_OAK_PRESSURE_PLATE.get();
                planks = DeepDarkBlocks.GLOWING_OAK_PLANKS.get();
                stairs = Stairs.GLOWING_OAK_STAIRS.get();
                door = Doors.GLOWING_OAK_DOOR.get();
                chest = Chests.GLOWING_OAK_CHEST;
                trapdoor = Trapdoors.GLOWING_OAK_TRAPDOOR.get();
                bookShelf = Decoration.GLOWING_OAK_BOOKSHELF.get();
                strippedLog = DeepDarkBlocks.STRIPPED_BLACKENED_OAK_LOG.get();
                slab = Slabs.GLOWING_OAK_SLAB.get();
            } else if (biome.m_203565_(PMBiomes.DARK_DESERT) || biome.m_203565_(PMBiomes.DARK_VOLCANIC_FIELD)) {
                fence = Fences.GLOWING_CACTUS_FENCE.get();
                fenceGate = FenceGates.GLOWING_CACTUS_FENCE_GATE.get();
                craftingTable = Tables.GLOWING_CACTUS_CRAFTING_TABLE.get();
                log = DeepDarkBlocks.GLOWING_CACTUS_BLOCK.get();
                plate = Plates.GLOWING_CACTUS_PRESSURE_PLATE.get();
                planks = DeepDarkBlocks.GLOWING_CACTUS_BLOCK.get();
                stairs = Stairs.GLOWING_CACTUS_STAIRS.get();
                door = Doors.GLOWING_CACTUS_DOOR.get();
                chest = Chests.GLOWING_CACTUS_CHEST;
                trapdoor = Trapdoors.GLOWING_CACTUS_TRAPDOOR.get();
                bookShelf = Decoration.GLOWING_CACTUS_BOOKSHELF.get();
                strippedLog = DeepDarkBlocks.GLOWING_CACTUS_BLOCK.get();
                slab = Slabs.GLOWING_CACTUS_SLAB.get();
            }
        } else if (PMBiomes.isRockyDesert(biome)) {
            fence = Fences.PALO_VERDE_FENCE.get();
            fenceGate = FenceGates.PALO_VERDE_FENCE_GATE.get();
            craftingTable = Tables.PALO_VERDE_CRAFTING_TABLE.get();
            log = Decoration.PALO_VERDE_LOG.get();
            plate = Plates.PALO_VERDE_PRESSURE_PLATE.get();
            planks = Building.PALO_VERDE_PLANKS.get();
            stairs = Stairs.PALO_VERDE_STAIRS.get();
            door = Doors.PALO_VERDE_DOOR.get();
            chest = Chests.PALO_VERDE_CHEST;
            trapdoor = Trapdoors.PALO_VERDE_TRAPDOOR.get();
            bookShelf = Decoration.PALO_VERDE_BOOKSHELF.get();
            strippedLog = Decoration.STRIPPED_PALO_VERDE_LOG.get();
            slab = Slabs.PALO_VERDE_SLAB.get();
            if (biome.m_203565_(PMBiomes.MESQUITE_FOREST) || rand.m_188499_()) {
                fence = Fences.MESQUITE_FENCE.get();
                fenceGate = FenceGates.MESQUITE_FENCE_GATE.get();
                craftingTable = Tables.MESQUITE_CRAFTING_TABLE.get();
                log = Decoration.MESQUITE_LOG.get();
                plate = Plates.MESQUITE_PRESSURE_PLATE.get();
                planks = Building.MESQUITE_PLANKS.get();
                stairs = Stairs.MESQUITE_STAIRS.get();
                door = Doors.MESQUITE_DOOR.get();
                chest = Chests.MESQUITE_CHEST;
                trapdoor = Trapdoors.MESQUITE_TRAPDOOR.get();
                bookShelf = Decoration.MESQUITE_BOOKSHELF.get();
                strippedLog = Decoration.STRIPPED_MESQUITE_LOG.get();
                slab = Slabs.MESQUITE_SLAB.get();
            }
        } else if (biome.m_203656_(Tags.Biomes.IS_CONIFEROUS) || biome.m_203656_(Tags.Biomes.IS_COLD) || biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            fence = Blocks.f_50479_;
            fenceGate = Blocks.f_50474_;
            craftingTable = Tables.SPRUCE_CRAFTING_TABLE.get();
            log = Blocks.f_50000_;
            plate = Blocks.f_50168_;
            planks = Blocks.f_50741_;
            stairs = Blocks.f_50269_;
            door = Blocks.f_50484_;
            chest = QuarkBlocks.SPRUCE_CHEST;
            trapdoor = Blocks.f_50217_;
            bookShelf = QuarkBlocks.SPRUCE_BOOKSHELF;
            strippedLog = Blocks.f_50005_;
            slab = Blocks.f_50399_;
        } else if (biome.m_203656_(BiomeTags.f_207610_)) {
            fence = Blocks.f_50481_;
            fenceGate = Blocks.f_50476_;
            craftingTable = Tables.JUNGLE_CRAFTING_TABLE.get();
            log = Blocks.f_50002_;
            plate = Blocks.f_50170_;
            planks = Blocks.f_50743_;
            stairs = Blocks.f_50271_;
            door = Blocks.f_50486_;
            chest = QuarkBlocks.JUNGLE_CHEST;
            trapdoor = Blocks.f_50219_;
            bookShelf = QuarkBlocks.JUNGLE_BOOKSHELF;
            strippedLog = Blocks.f_50007_;
            slab = Blocks.f_50401_;
            if (biome.m_203565_(Biomes.f_48197_) && rand.m_188499_()) {
                fence = Blocks.f_244641_;
                fenceGate = Blocks.f_244313_;
                craftingTable = Tables.BAMBOO_CRAFTING_TABLE.get();
                log = Blocks.f_244477_;
                plate = Blocks.f_244183_;
                planks = Blocks.f_244477_;
                stairs = Blocks.f_243755_;
                door = Blocks.f_244648_;
                chest = Chests.BAMBOO_CHEST;
                trapdoor = Blocks.f_244549_;
                bookShelf = Decoration.BAMBOO_BOOKSHELF.get();
                strippedLog = Blocks.f_244477_;
                slab = Blocks.f_244004_;
            }
        } else if (biome.m_203656_(BiomeTags.f_215816_)) {
            fence = Blocks.f_50482_;
            fenceGate = Blocks.f_50477_;
            craftingTable = Tables.ACACIA_CRAFTING_TABLE.get();
            log = Blocks.f_50003_;
            plate = Blocks.f_50171_;
            planks = Blocks.f_50744_;
            stairs = Blocks.f_50372_;
            door = Blocks.f_50487_;
            chest = QuarkBlocks.ACACIA_CHEST;
            trapdoor = Blocks.f_50220_;
            bookShelf = QuarkBlocks.ACACIA_BOOKSHELF;
            strippedLog = Blocks.f_50008_;
            slab = Blocks.f_50402_;
        } else if (biome.m_203656_(Tags.Biomes.IS_DRY) && !biome.m_203656_(BiomeTags.f_207607_)) {
            fence = Fences.CACTUS_FENCE.get();
            fenceGate = FenceGates.CACTUS_FENCE_GATE.get();
            craftingTable = Tables.CACTUS_CRAFTING_TABLE.get();
            log = Building.CACTUS_BLOCK.get();
            plate = Plates.CACTUS_PRESSURE_PLATE.get();
            planks = Building.CACTUS_BLOCK.get();
            stairs = Stairs.CACTUS_STAIRS.get();
            door = Doors.CACTUS_DOOR.get();
            chest = Chests.CACTUS_CHEST;
            trapdoor = Trapdoors.CACTUS_TRAPDOOR.get();
            bookShelf = Decoration.CACTUS_BOOKSHELF.get();
            strippedLog = Building.CACTUS_BLOCK.get();
            slab = Slabs.CACTUS_SLAB.get();
        }
        return List.of(fence, fenceGate, craftingTable, log, plate, planks, stairs, door, chest, trapdoor, bookShelf, strippedLog, slab);
    }

    public static List<Block> getColoredBlocks(RandomSource rand, Holder<Biome> biome) {
        List<Block> roseFieldBlocks = BasicFeature.getRoseColoredBlocks(PMBiomes.ROSE_FIELDS_BY_COLOR, biome);
        List<Block> roseLandBlocks = BasicFeature.getRoseColoredBlocks(PMBiomes.ROSE_LANDS_BY_COLOR, biome);
        if (roseFieldBlocks.size() > 0) {
            return roseFieldBlocks;
        }
        if (roseLandBlocks.size() > 0) {
            return roseLandBlocks;
        }
        Block wool = Blocks.f_50108_;
        Block lantern = Blocks.f_50681_;
        Block lamp = Blocks.f_50261_;
        Block bed = Blocks.f_50028_;
        if (biome.m_203565_(PMBiomes.GLOWING_FOREST) || biome.m_203565_(PMBiomes.CRYSTAL_FOREST)) {
            wool = Blocks.f_50102_;
            lantern = ColoredLanterns.LIGHT_GRAY_LANTERN.get();
            lamp = Lamps.LIGHT_GRAY_REDSTONE_LAMP.get();
            bed = Blocks.f_50022_;
        } else if (biome.m_203565_(Biomes.f_48151_) || biome.m_203565_(PMBiomes.UNDERGROUND_DARK_FOREST)) {
            wool = Blocks.f_50105_;
            lantern = ColoredLanterns.BLUE_LANTERN.get();
            lamp = Lamps.BLUE_REDSTONE_LAMP.get();
            bed = Blocks.f_50025_;
        } else if (biome.m_203565_(Biomes.f_48149_) || biome.m_203565_(Biomes.f_186762_) || biome.m_203565_(PMBiomes.UNDERGROUND_BIRCH_FOREST)) {
            wool = Blocks.f_50103_;
            lantern = ColoredLanterns.CYAN_LANTERN.get();
            lamp = Lamps.CYAN_REDSTONE_LAMP.get();
            bed = Blocks.f_50023_;
        } else if (biome.m_203565_(PMBiomes.WEEPING_FOREST) || biome.m_203565_(PMBiomes.FROZEN_WEEPING_FOREST)) {
            wool = Blocks.f_50101_;
            lantern = ColoredLanterns.GRAY_LANTERN.get();
            lamp = Lamps.GRAY_REDSTONE_LAMP.get();
            bed = Blocks.f_50021_;
        } else if (biome.m_203565_(Biomes.f_271432_) || biome.m_203565_(PMBiomes.UNDERGROUND_CHERRY_FOREST)) {
            wool = Blocks.f_50100_;
            lantern = ColoredLanterns.PINK_LANTERN.get();
            lamp = Lamps.PINK_REDSTONE_LAMP.get();
            bed = Blocks.f_50020_;
        } else if (biome.m_203565_(PMBiomes.AUTUMN_FOREST) || biome.m_203565_(PMBiomes.UNDERGROUND_AUTUMN_FOREST)) {
            switch (rand.m_188503_(4)) {
                case 0: {
                    wool = Blocks.f_50098_;
                    lantern = ColoredLanterns.YELLOW_LANTERN.get();
                    lamp = Lamps.YELLOW_REDSTONE_LAMP.get();
                    bed = Blocks.f_50018_;
                    break;
                }
                case 1: {
                    wool = Blocks.f_50042_;
                    lantern = ColoredLanterns.ORANGE_LANTERN.get();
                    lamp = Lamps.ORANGE_REDSTONE_LAMP.get();
                    bed = Blocks.f_50067_;
                    break;
                }
                case 2: {
                    lantern = ColoredLanterns.RED_LANTERN.get();
                    lamp = Lamps.RED_REDSTONE_LAMP.get();
                    break;
                }
                case 3: {
                    wool = Blocks.f_50105_;
                    lantern = ColoredLanterns.BLUE_LANTERN.get();
                    lamp = Lamps.BLUE_REDSTONE_LAMP.get();
                    bed = Blocks.f_50025_;
                }
            }
        } else if (biome.m_203656_(PMTags.Biomes.DEEP_DARK)) {
            wool = Blocks.f_50109_;
            lantern = ColoredLanterns.BLACK_LANTERN.get();
            lamp = Lamps.BLACK_REDSTONE_LAMP.get();
            bed = Blocks.f_50029_;
        } else if (biome.m_203656_(Tags.Biomes.IS_SWAMP) || biome.m_203565_(PMBiomes.TEMPERATE_RAINFOREST) || biome.m_203565_(PMBiomes.UNDERGROUND_TEMPERATE_RAINFOREST)) {
            wool = Blocks.f_50107_;
            lantern = ColoredLanterns.GREEN_LANTERN.get();
            lamp = Lamps.GREEN_REDSTONE_LAMP.get();
            bed = Blocks.f_50027_;
        } else if (biome.m_203656_(BiomeTags.f_207607_) || PMBiomes.isRockyDesert(biome)) {
            wool = Blocks.f_50106_;
            lantern = ColoredLanterns.BROWN_LANTERN.get();
            lamp = Lamps.BROWN_REDSTONE_LAMP.get();
            bed = Blocks.f_50026_;
        } else if (biome.m_203656_(Tags.Biomes.IS_CONIFEROUS) || biome.m_203656_(Tags.Biomes.IS_COLD) || biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            wool = Blocks.f_50097_;
            lantern = ColoredLanterns.LIGHT_BLUE_LANTERN.get();
            lamp = Lamps.LIGHT_BLUE_REDSTONE_LAMP.get();
            bed = Blocks.f_50017_;
        } else if (biome.m_203656_(BiomeTags.f_207610_)) {
            wool = Blocks.f_50099_;
            lantern = ColoredLanterns.LIME_LANTERN.get();
            lamp = Lamps.LIME_REDSTONE_LAMP.get();
            bed = Blocks.f_50019_;
        } else if (biome.m_203656_(BiomeTags.f_215816_)) {
            wool = Blocks.f_50042_;
            lantern = ColoredLanterns.ORANGE_LANTERN.get();
            lamp = Lamps.ORANGE_REDSTONE_LAMP.get();
            bed = Blocks.f_50067_;
        } else if (biome.m_203656_(Tags.Biomes.IS_DRY)) {
            wool = Blocks.f_50098_;
            lantern = ColoredLanterns.YELLOW_LANTERN.get();
            lamp = Lamps.YELLOW_REDSTONE_LAMP.get();
            bed = Blocks.f_50018_;
        }
        return List.of(wool, lantern, lamp, bed);
    }

    private static List<Block> getRoseColoredBlocks(EnumMap<DyeColor, ResourceKey<Biome>> roseBiomes, Holder<Biome> biome) {
        Block wool = Blocks.f_50108_;
        Block lantern = Blocks.f_50681_;
        Block lamp = Blocks.f_50261_;
        Block bed = Blocks.f_50028_;
        for (Map.Entry<DyeColor, ResourceKey<Biome>> entry : roseBiomes.entrySet()) {
            DyeColor color = entry.getKey();
            ResourceKey<Biome> roseBiome = entry.getValue();
            if (!biome.m_203565_(roseBiome)) continue;
            lamp = Lamps.REDSTONE_LAMPS.get(color).get();
            lantern = ColoredLanterns.LANTERNS.get(color).get();
            switch (color) {
                case WHITE: {
                    wool = Blocks.f_50041_;
                    bed = Blocks.f_50066_;
                    break;
                }
                case ORANGE: {
                    wool = Blocks.f_50042_;
                    bed = Blocks.f_50067_;
                    break;
                }
                case MAGENTA: {
                    wool = Blocks.f_50096_;
                    bed = Blocks.f_50068_;
                    break;
                }
                case LIGHT_BLUE: {
                    wool = Blocks.f_50097_;
                    bed = Blocks.f_50017_;
                    break;
                }
                case YELLOW: {
                    wool = Blocks.f_50098_;
                    bed = Blocks.f_50018_;
                    break;
                }
                case LIME: {
                    wool = Blocks.f_50099_;
                    bed = Blocks.f_50019_;
                    break;
                }
                case PINK: {
                    wool = Blocks.f_50100_;
                    bed = Blocks.f_50020_;
                    break;
                }
                case GRAY: {
                    wool = Blocks.f_50101_;
                    bed = Blocks.f_50021_;
                    break;
                }
                case LIGHT_GRAY: {
                    wool = Blocks.f_50102_;
                    bed = Blocks.f_50022_;
                    break;
                }
                case CYAN: {
                    wool = Blocks.f_50103_;
                    bed = Blocks.f_50023_;
                    break;
                }
                case PURPLE: {
                    wool = Blocks.f_50104_;
                    bed = Blocks.f_50024_;
                    break;
                }
                case BLUE: {
                    wool = Blocks.f_50105_;
                    bed = Blocks.f_50025_;
                    break;
                }
                case BROWN: {
                    wool = Blocks.f_50106_;
                    bed = Blocks.f_50026_;
                    break;
                }
                case GREEN: {
                    wool = Blocks.f_50107_;
                    bed = Blocks.f_50027_;
                    break;
                }
                case BLACK: {
                    wool = Blocks.f_50109_;
                    bed = Blocks.f_50029_;
                }
            }
            return List.of(wool, lantern, lamp, bed);
        }
        return List.of();
    }
}

