/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.world.CrystalClusters;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.blocks.CrystalCluster;
import net.paradisemod.world.blocks.SmallCaveFormation;
import net.paradisemod.worldgen.features.BasicFeature;

public class CrystalGen
extends BasicFeature {
    private final Type type;

    public CrystalGen(Type type) {
        this.type = type;
    }

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        if (!this.type.shouldGenerate(rand)) {
            return false;
        }
        ITag<Block> crystals = Utils.getBlockTag(PMTags.Blocks.CRYSTAL_CLUSTERS);
        CrystalCluster crystal = (CrystalCluster)CrystalClusters.DIAMOND_CRYSTAL_CLUSTER.get();
        String dimName = world.m_6018_().m_46472_().m_135782_().toString();
        CrystalCluster[] endCrystals = new CrystalCluster[]{(CrystalCluster)CrystalClusters.EMERALD_CRYSTAL_CLUSTER.get(), (CrystalCluster)CrystalClusters.RUBY_CRYSTAL_CLUSTER.get(), (CrystalCluster)CrystalClusters.ENDER_PEARL_CLUSTER.get()};
        if (this.type == Type.RANDOM) {
            crystal = (CrystalCluster)((Object)crystals.getRandomElement(rand).get());
        } else if (this.type == Type.END_RANDOM) {
            crystal = endCrystals[rand.m_188503_(endCrystals.length)];
        }
        int sizeXZ = 16 + rand.m_188503_(8);
        int sizeY = 20 + rand.m_188503_(10);
        int height = 62;
        if (dimName.equals("paradisemod:overworld_core") || this.type == Type.HONEY) {
            height = 317;
        } else if (dimName.equals("minecraft:the_nether") || dimName.equals("minecraft:the_end")) {
            height = 126;
        }
        for (int i = 0; i < sizeXZ; ++i) {
            for (int j = 0; j < sizeXZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    if (rand.m_188503_(5) != 0) continue;
                    crystal = switch (this.type) {
                        case Type.SALT -> (CrystalCluster)CrystalClusters.SALT_CRYSTAL_CLUSTER.get();
                        case Type.MIXED -> (CrystalCluster)((Object)crystals.getRandomElement(rand).get());
                        case Type.QUARTZ -> (CrystalCluster)CrystalClusters.QUARTZ_CRYSTAL_CLUSTER.get();
                        case Type.HONEY -> (CrystalCluster)CrystalClusters.HONEY_CRYSTAL_CLUSTER.get();
                        case Type.END_MIXED -> endCrystals[rand.m_188503_(endCrystals.length)];
                        default -> crystal;
                    };
                    BlockPos newPos = pos.m_7918_(i, -k, j);
                    Holder biome = world.m_204166_(newPos);
                    if (newPos.m_123342_() > height || this.type == Type.HONEY && !biome.m_203565_(PMBiomes.HONEY_CAVE)) continue;
                    CrystalGen.genCrystal(rand, world, newPos, crystal);
                }
            }
        }
        return true;
    }

    private static void genCrystal(RandomSource rand, WorldGenLevel world, BlockPos pos, CrystalCluster crystal) {
        if (world.m_8055_(pos).m_60795_() || world.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
            if (rand.m_188503_(3) != 0) {
                return;
            }
            ArrayList<Direction> validDirs = new ArrayList<Direction>();
            for (Direction facing : Direction.values()) {
                BlockState relState = world.m_8055_(pos.m_121945_(facing));
                if (!SmallCaveFormation.isSupported((LevelReader)world, facing.m_122424_(), pos) && !relState.m_60713_(Blocks.f_50719_) || relState.m_60713_(Blocks.f_50125_)) continue;
                validDirs.add(facing);
            }
            if (validDirs.isEmpty()) {
                return;
            }
            Direction toPlaceDir = ((Direction)validDirs.get(rand.m_188503_(validDirs.size()))).m_122424_();
            boolean waterlogged = world.m_8055_(pos).m_60713_(Blocks.f_49990_);
            world.m_7731_(pos, (BlockState)((BlockState)((BlockState)crystal.m_49966_().m_61124_((Property)CrystalCluster.TYPE, (Comparable)Integer.valueOf(rand.m_188503_(4)))).m_61124_((Property)CrystalCluster.f_52588_, (Comparable)toPlaceDir)).m_61124_((Property)CrystalCluster.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 1);
        }
    }

    public static enum Type {
        SALT,
        QUARTZ,
        HONEY,
        RANDOM,
        MIXED,
        END_RANDOM,
        END_MIXED;


        public boolean shouldGenerate(RandomSource rand) {
            if (this == HONEY) {
                return rand.m_188503_(5) == 0;
            }
            PMConfig.WorldGenOption settings = switch (this) {
                case END_MIXED, END_RANDOM -> PMConfig.SETTINGS.betterEnd.endCrystals;
                default -> PMConfig.SETTINGS.caveCrystals;
            };
            return settings.shouldGenerate(rand);
        }
    }
}

