/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.blocks.LargeCaveFormation;
import net.paradisemod.world.blocks.SmallCaveFormation;
import net.paradisemod.world.dimension.PMDimensions;
import net.paradisemod.worldgen.features.chunk.ChunkProcessor;

public class IceSheet
extends ChunkProcessor {
    private static final List<RegisteredBlock> ICICLES = List.of(PMWorld.ICICLE, PMWorld.BLUE_ICICLE);
    private static final List<Supplier<LargeCaveFormation>> LARGE_ICICLES = List.of(() -> (LargeCaveFormation)PMWorld.LARGE_ICICLE.get(), () -> (LargeCaveFormation)PMWorld.LARGE_BLUE_ICICLE.get());
    @Nullable
    private final Supplier<Block> top;
    @Nullable
    private final Supplier<Block> middle;
    private final Supplier<Block> bottom;
    private final List<ResourceKey<Biome>> allowedBiomes;

    @SafeVarargs
    public IceSheet(Supplier<Block> top, Supplier<Block> middle, Supplier<Block> bottom, ResourceKey<Biome> ... allowedBiomes) {
        this.top = top;
        this.middle = middle;
        this.bottom = bottom;
        this.allowedBiomes = Arrays.asList(allowedBiomes);
    }

    @Override
    protected void processBlock(WorldGenLevel world, RandomSource rand, BlockPos pos, BlockState curState, Holder<Biome> biome, ChunkGenerator generator) {
        ResourceKey biomeKey = (ResourceKey)biome.m_203543_().orElseThrow();
        if (this.allowedBiomes.contains(biomeKey)) {
            BlockState blockBelow = world.m_8055_(pos.m_7495_());
            if ((curState.m_60713_(Blocks.f_50016_) || curState.m_60734_() instanceof LargeCaveFormation || curState.m_60734_() instanceof SmallCaveFormation || curState.m_60713_(Blocks.f_50125_)) && blockBelow.m_280296_() && !blockBelow.m_60713_(Blocks.f_50125_) && !blockBelow.m_60713_(Blocks.f_50127_) && !blockBelow.m_204336_(BlockTags.f_144287_) && !(blockBelow.m_60734_() instanceof ChestBlock) || curState.m_60713_(Blocks.f_49990_)) {
                int bound1 = 5 + rand.m_188503_(5);
                int bound2 = 15 + rand.m_188503_(10);
                for (int i = 0; i < 30; ++i) {
                    BlockPos placePos = pos.m_6630_(i);
                    BlockState blockToPlace = this.bottom.get().m_49966_();
                    if (i > bound2 && this.top != null) {
                        blockToPlace = this.top.get().m_49966_();
                    } else if (i > bound1 && this.middle != null) {
                        blockToPlace = this.middle.get().m_49966_();
                    }
                    Block toReplace = world.m_8055_(placePos).m_60734_();
                    if (toReplace == Blocks.f_50627_) continue;
                    if (toReplace instanceof AirBlock || toReplace == Blocks.f_49990_) {
                        world.m_7731_(placePos, blockToPlace, 32);
                        if (world.m_8055_(placePos.m_7495_()).m_60713_(Blocks.f_50627_) && !blockToPlace.m_60713_(Blocks.f_50127_)) {
                            if (rand.m_188503_(5) == 0) {
                                world.m_7731_(placePos.m_7495_(), (BlockState)((BlockState)ICICLES.get(rand.m_188503_(ICICLES.size())).get().m_49966_().m_61124_((Property)SmallCaveFormation.f_52588_, (Comparable)Direction.DOWN)).m_61124_((Property)SmallCaveFormation.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 32);
                                continue;
                            }
                            if (rand.m_188503_(10) != 0) continue;
                            LARGE_ICICLES.get(rand.m_188503_(LARGE_ICICLES.size())).get().place(world, placePos.m_7495_(), true);
                            continue;
                        }
                        if (!world.m_8055_(placePos.m_7494_()).m_60713_(Blocks.f_50627_) || blockToPlace.m_60713_(Blocks.f_50127_)) continue;
                        if (rand.m_188503_(5) == 0) {
                            world.m_7731_(placePos.m_7494_(), (BlockState)((BlockState)ICICLES.get(rand.m_188503_(ICICLES.size())).get().m_49966_().m_61124_((Property)SmallCaveFormation.f_52588_, (Comparable)Direction.UP)).m_61124_((Property)SmallCaveFormation.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 32);
                            continue;
                        }
                        if (rand.m_188503_(10) != 0) continue;
                        LARGE_ICICLES.get(rand.m_188503_(LARGE_ICICLES.size())).get().place(world, placePos.m_7495_(), false);
                        continue;
                    }
                    if (toReplace instanceof LargeCaveFormation || toReplace instanceof SmallCaveFormation || toReplace == Blocks.f_50125_) continue;
                    return;
                }
                BlockState blockBelowSnow = world.m_8055_(pos.m_6630_(29));
                if (blockBelowSnow.m_60815_()) {
                    world.m_7731_(pos.m_6630_(30), Blocks.f_50125_.m_49966_(), 32);
                }
            }
        }
    }

    @Override
    protected int minHeight(WorldGenLevel world) {
        ResourceKey dim = world.m_6018_().m_46472_();
        if (PMDimensions.Type.DEEP_DARK.is((ResourceKey<Level>)dim)) {
            return world.m_141937_();
        }
        return 62;
    }
}

