/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.features.BasicFeature;

public class IceSpire
extends BasicFeature {
    private static final List<ResourceKey<Biome>> ALLOWED_BIOMES = List.of(Biomes.f_48182_, PMBiomes.ICE_SPIKES_CAVE);

    private static int genFunc(RandomSource rand, int x, int y) {
        return (int)((double)(100 + rand.m_188503_(200)) * Math.cos((Math.pow(x, 2.0) + Math.pow(y, 2.0)) / 20.0) / (Math.pow(x, 2.0) + Math.pow(y, 2.0) + 1.0));
    }

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        BlockPos featurePos = pos;
        if (world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50125_)) {
            featurePos = pos.m_7495_();
        }
        Holder biome = world.m_204166_(featurePos);
        if (IceSpire.isFlat(world, featurePos.m_7918_(-4, 0, -4), 8, 8, true) && ALLOWED_BIOMES.contains(biome.m_203543_().orElseThrow())) {
            for (int x = -4; x < 4; ++x) {
                block1: for (int z = -4; z < 4; ++z) {
                    for (int y = featurePos.m_123342_(); y <= featurePos.m_123342_() + IceSpire.genFunc(rand, x, z); ++y) {
                        if (y > 310) continue;
                        BlockPos newPos = new BlockPos(featurePos.m_123341_() + x, y, featurePos.m_123343_() + z);
                        if (world.m_8055_(newPos).m_60815_()) continue block1;
                        world.m_7731_(newPos, Blocks.f_50354_.m_49966_(), 1);
                    }
                }
            }
        }
        return true;
    }
}

