/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.paradisemod.world.Ores;
import net.paradisemod.worldgen.structures.SmallStructure;

public class InsomniumFossil
extends SmallStructure {
    private static final List<ResourceLocation> FOSSILS = List.of(new ResourceLocation("fossil/spine_1"), new ResourceLocation("fossil/spine_2"), new ResourceLocation("fossil/spine_3"), new ResourceLocation("fossil/spine_4"), new ResourceLocation("fossil/skull_1"), new ResourceLocation("fossil/skull_2"), new ResourceLocation("fossil/skull_3"), new ResourceLocation("fossil/skull_4"));

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        StructureTemplate template = (StructureTemplate)world.m_6018_().m_215082_().m_230407_(FOSSILS.get(rand.m_188503_(FOSSILS.size()))).get();
        int sizeX = template.m_163801_().m_123341_();
        int sizeZ = template.m_163801_().m_123343_();
        BlockPos structurePos = pos;
        if (!world.m_8055_(pos.m_7495_()).m_60815_()) {
            structurePos = pos.m_7495_();
        }
        if (InsomniumFossil.isFlat(world, structurePos, sizeX, sizeZ, true)) {
            return this.genStructureFromTemplate(template, world, rand, structurePos, generator, true);
        }
        return false;
    }

    @Override
    protected void postProcessStructure(StructureTemplate template, WorldGenLevel world, RandomSource rand, BlockPos pos, StructurePlaceSettings settings, ChunkGenerator generator) {
        Block[] ores = new Block[]{Ores.DARKSTONE_COAL_ORE.get(), Blocks.f_152474_};
        this.postProcessByBlock(world, template, pos, (curState, curPos) -> {
            if (curState.m_60713_(Blocks.f_50453_) && rand.m_188503_(10) == 0) {
                world.m_7731_(curPos, ores[rand.m_188503_(ores.length)].m_49966_(), 32);
            }
        });
    }
}

