/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.fluid.PMFluids;
import net.paradisemod.worldgen.features.BasicFeature;

public class LavaFissure
extends BasicFeature {
    private boolean isDark;

    public LavaFissure(boolean isDark) {
        this.isDark = isDark;
    }

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        DimensionType dimType = world.m_6018_().m_6042_();
        int height = dimType.f_156648_();
        int chunkX = (pos.m_123341_() >> 4) * 16;
        int chunkZ = (pos.m_123343_() >> 4) * 16;
        BlockPos chunkCorner = new BlockPos(chunkX, 63, chunkZ);
        if (dimType.f_63856_()) {
            ArrayList<Integer> layers = new ArrayList<Integer>();
            for (int y = 0; y < height; ++y) {
                if (y % 10 != 0) continue;
                layers.add(y);
            }
            chunkCorner = new BlockPos(chunkX, ((Integer)layers.get(rand.m_188503_(layers.size()))).intValue(), chunkZ);
        }
        BlockPos toPlacePos = chunkCorner.m_7918_(rand.m_188503_(8), 0, rand.m_188503_(8));
        for (int x = 0; x < 8; ++x) {
            for (int z = 0; z < 8; ++z) {
                BlockPos newPos;
                for (int y = 0; y < 194 && (newPos = toPlacePos.m_7918_(x, y, z)).m_123342_() <= height - 10; ++y) {
                    BlockState block = world.m_8055_(newPos);
                    BlockState blockAbove = world.m_8055_(newPos.m_7494_());
                    if (!block.m_204336_(Tags.Blocks.STONE) || !blockAbove.m_60795_() && !blockAbove.m_60713_(Blocks.f_50568_) || rand.m_188503_(5) != 0) continue;
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        BlockPos adjPos = newPos.m_121945_(dir);
                        if (world.m_8055_(adjPos).m_60815_()) continue;
                        return false;
                    }
                    Holder biome = world.m_204166_(newPos);
                    if (!biome.m_203656_(PMTags.Biomes.VOLCANIC) && !biome.m_203565_(PMBiomes.DARK_VOLCANIC_FIELD)) continue;
                    world.m_7731_(newPos, (this.isDark ? PMFluids.DARK_LAVA_BLOCK.get() : Blocks.f_49991_).m_49966_(), 32);
                }
            }
        }
        return true;
    }
}

