/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.building.Building;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.CrystalClusters;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.Ores;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.blocks.CrystalCluster;
import net.paradisemod.world.fluid.PMFluids;
import net.paradisemod.worldgen.OreType;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.Boulder;
import net.paradisemod.worldgen.features.CrystalGen;
import net.paradisemod.worldgen.features.EmptyFeature;
import net.paradisemod.worldgen.features.FallenTree;
import net.paradisemod.worldgen.features.FullChristmasTree;
import net.paradisemod.worldgen.features.IceSheet;
import net.paradisemod.worldgen.features.IceSpire;
import net.paradisemod.worldgen.features.InsomniumFossil;
import net.paradisemod.worldgen.features.LavaFissure;
import net.paradisemod.worldgen.features.OWCSurfaceFixerUpper;
import net.paradisemod.worldgen.features.SnowBlanket;
import net.paradisemod.worldgen.features.cave.BaseCaveGen;
import net.paradisemod.worldgen.features.cave.PMCaveFeatures;
import net.paradisemod.worldgen.features.chunk.ChunkProcessingFeature;
import net.paradisemod.worldgen.features.chunk.ChunkProcessor;
import net.paradisemod.worldgen.features.foliage.FoliagePatch;
import net.paradisemod.worldgen.features.foliage.PMFoliage;
import net.paradisemod.worldgen.features.placement.ConfiguredOrePlacement;
import net.paradisemod.worldgen.features.placement.InfiniteCountPlacement;

public class PMFeatures {
    private static final DeferredRegister<Feature<?>> FEATURES = PMRegistries.createRegistry(ForgeRegistries.FEATURES);
    public static final HashMap<ResourceKey<ConfiguredFeature<?, ?>>, ConfiguredFeatureFactory> CFG_FEATURES = new HashMap();
    public static final HashMap<ResourceKey<PlacedFeature>, PlacedFeatureFactory> PLACED_FEATURES = new HashMap();
    private static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIERS = PMRegistries.createRegistry(Registries.f_256843_);
    public static final RegistryObject<PlacementModifierType<InfiniteCountPlacement>> INFINITE_COUNT = PMFeatures.createPlacementModifierType("infinite_count", InfiniteCountPlacement.CODEC);
    public static final RegistryObject<PlacementModifierType<ConfiguredOrePlacement>> CONFIGURED_ORE = PMFeatures.createPlacementModifierType("configured_ore", ConfiguredOrePlacement.CODEC);
    public static final PlacementModifier FULL_HEIGHT_RANGE = HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)320));
    public static final ResourceKey<PlacedFeature> EMPTY = PMFeatures.getBasicFeature("empty", EmptyFeature::new, new PlacementModifier[0]);
    public static final ResourceKey<PlacedFeature> RAW_CHUNK_PROCESSOR = PMFeatures.getBasicFeature("raw_chunk_processor", () -> new ChunkProcessingFeature(false), new PlacementModifier[0]);
    public static final ResourceKey<PlacedFeature> VEGETAL_CHUNK_PROCESSOR = PMFeatures.getBasicFeature("vegetal_chunk_processor", () -> new ChunkProcessingFeature(true), new PlacementModifier[0]);
    public static final ResourceKey<PlacedFeature> SALT_CRYSTALS = PMFeatures.getCrystalFeature(CrystalGen.Type.SALT, false);
    public static final ResourceKey<PlacedFeature> EXTRA_SALT_CRYSTALS = PMFeatures.getCrystalFeature(CrystalGen.Type.SALT, true);
    public static final ResourceKey<PlacedFeature> HONEY_CRYSTALS = PMFeatures.getCrystalFeature(CrystalGen.Type.HONEY, true);
    public static final ResourceKey<PlacedFeature> QUARTZ_CRYSTALS = PMFeatures.getCrystalFeature(CrystalGen.Type.QUARTZ, false);
    public static final ResourceKey<PlacedFeature> MIXED_CRYSTALS = PMFeatures.getCrystalFeature(CrystalGen.Type.MIXED, false);
    public static final ResourceKey<PlacedFeature> RANDOM_CRYSTALS = PMFeatures.getCrystalFeature(CrystalGen.Type.RANDOM, false);
    public static final ResourceKey<PlacedFeature> MIXED_END_CRYSTALS = PMFeatures.getCrystalFeature(CrystalGen.Type.END_MIXED, false);
    public static final ResourceKey<PlacedFeature> RANDOM_END_CRYSTALS = PMFeatures.getCrystalFeature(CrystalGen.Type.END_RANDOM, false);
    public static final ResourceKey<PlacedFeature> FALLEN_TREE = PMFeatures.getBasicFeature("fallen_tree", FallenTree::new, PlacementUtils.f_195354_);
    public static final ResourceKey<PlacedFeature> DIAMOND_GEODE = PMFeatures.createGeode("diamond", 192, CrystalClusters.DIAMOND_CRYSTAL_CLUSTER, () -> Blocks.f_50090_, () -> Blocks.f_152497_, () -> Blocks.f_152597_);
    public static final ResourceKey<PlacedFeature> EMERALD_GEODE = PMFeatures.createGeode("emerald", 96, CrystalClusters.EMERALD_CRYSTAL_CLUSTER, () -> Blocks.f_50268_, () -> Blocks.f_152497_, () -> Blocks.f_152597_);
    public static final ResourceKey<PlacedFeature> LAPIS_GEODE = PMFeatures.createGeode("lapis_lazuli", 48, CrystalClusters.LAPIS_CRYSTAL_CLUSTER, () -> Blocks.f_50060_, () -> Blocks.f_152497_, () -> Blocks.f_152597_);
    public static final ResourceKey<PlacedFeature> QUARTZ_GEODE = PMFeatures.createGeode("quartz", 48, CrystalClusters.QUARTZ_CRYSTAL_CLUSTER, () -> Blocks.f_50333_, () -> Blocks.f_152497_, () -> Blocks.f_152597_);
    public static final ResourceKey<PlacedFeature> QUARTZ_GEODE_NETHER = PMFeatures.createGeode("quartz_nether", 48, CrystalClusters.QUARTZ_CRYSTAL_CLUSTER, () -> Blocks.f_50333_, () -> Blocks.f_152597_, () -> Blocks.f_50730_);
    public static final ResourceKey<PlacedFeature> REDSTONE_GEODE = PMFeatures.createGeode("redstone", 96, CrystalClusters.REDSTONE_CRYSTAL_CLUSTER, () -> Blocks.f_50330_, () -> Blocks.f_152497_, () -> Blocks.f_152597_);
    public static final ResourceKey<PlacedFeature> RUBY_GEODE = PMFeatures.createGeode("ruby", 192, CrystalClusters.RUBY_CRYSTAL_CLUSTER, Ores.RUBY_BLOCK, () -> Blocks.f_152497_, () -> Blocks.f_152597_);
    public static final ResourceKey<PlacedFeature> SALT_GEODE = PMFeatures.createGeode("salt", 48, CrystalClusters.SALT_CRYSTAL_CLUSTER, Ores.COMPACT_SALT_BLOCK, () -> Blocks.f_152497_, () -> Blocks.f_152597_);
    public static final ResourceKey<PlacedFeature> ENDERITE_GEODE = PMFeatures.createGeode("enderite", 96, CrystalClusters.ENDER_PEARL_CLUSTER, Ores.ENDERITE_BLOCK, Building.POLISHED_END_STONE, Building.POLISHED_END_STONE);
    public static final ResourceKey<PlacedFeature> WATER_LAKE = PMFeatures.getLakeFeature("water", () -> Blocks.f_49990_, 4, false);
    public static final ResourceKey<PlacedFeature> WATER_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("water", () -> Blocks.f_49990_, 4, true);
    public static final ResourceKey<PlacedFeature> LIQUID_REDSTONE_LAKE = PMFeatures.getLakeFeature("liquid_redstone", PMFluids.LIQUID_REDSTONE_BLOCK, 40, true);
    public static final ResourceKey<PlacedFeature> PSYCHEDELIC_LAVA_LAKE = PMFeatures.getLakeFeature("psychedelic_lava", PMFluids.PSYCHEDELIC_LAVA_BLOCK, 40, true);
    public static final ResourceKey<PlacedFeature> MOLTEN_SALT_LAKE = PMFeatures.getLakeFeature("molten_salt", PMFluids.MOLTEN_SALT_BLOCK, 4, false);
    public static final ResourceKey<PlacedFeature> MOLTEN_SALT_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("molten_salt", PMFluids.MOLTEN_SALT_BLOCK, 4, true);
    public static final ResourceKey<PlacedFeature> HONEY_LAKE = PMFeatures.getLakeFeature("honey_lake", PMFluids.HONEY_BLOCK, () -> Blocks.f_50719_, 4, true);
    public static final ResourceKey<PlacedFeature> ENDER_ACID_LAKE = PMFeatures.getLakeFeature("ender_acid", PMFluids.ENDER_ACID_BLOCK, () -> Blocks.f_50016_, 8, false);
    public static final ResourceKey<PlacedFeature> ENDER_ACID_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("ender_acid", PMFluids.ENDER_ACID_BLOCK, 8, true);
    public static final ResourceKey<PlacedFeature> GLOWING_WATER_LAKE = PMFeatures.getLakeFeature("glowing_water", PMFluids.GLOWING_WATER_BLOCK, 4, false);
    public static final ResourceKey<PlacedFeature> GLOWING_WATER_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("glowing_water", PMFluids.GLOWING_WATER_BLOCK, 4, true);
    public static final ResourceKey<PlacedFeature> PSYCHEDELIC_LAKE = PMFeatures.getLakeFeature("psychedelic", PMFluids.PSYCHEDELIC_FLUID_BLOCK, 4, false);
    public static final ResourceKey<PlacedFeature> PSYCHEDELIC_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("psychedelic", PMFluids.PSYCHEDELIC_FLUID_BLOCK, 4, true);
    public static final ResourceKey<PlacedFeature> DEEP_DARK_LAVA_LAKE = PMFeatures.getLakeFeature("deep_dark_lava", () -> Blocks.f_49991_, DeepDarkBlocks.DARKSTONE, 10, false);
    public static final ResourceKey<PlacedFeature> DEEP_DARK_LAVA_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("deep_dark_lava", () -> Blocks.f_49991_, DeepDarkBlocks.DARKSTONE, 10, true);
    public static final ResourceKey<PlacedFeature> VOLCANIC_LAVA_LAKE = PMFeatures.getLakeFeature("volcanic_lava", () -> Blocks.f_49991_, 2, false);
    public static final ResourceKey<PlacedFeature> VOLCANIC_LAVA_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("volcanic_lava", () -> Blocks.f_49991_, 2, true);
    public static final ResourceKey<PlacedFeature> DARK_LAVA_LAKE = PMFeatures.getLakeFeature("dark_lava", PMFluids.DARK_LAVA_BLOCK, DeepDarkBlocks.DARK_MAGMA_BLOCK, 4, false);
    public static final ResourceKey<PlacedFeature> DARK_LAVA_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("dark_lava", PMFluids.DARK_LAVA_BLOCK, DeepDarkBlocks.DARK_MAGMA_BLOCK, 4, true);
    public static final ResourceKey<PlacedFeature> VOLCANIC_DARK_LAVA_LAKE = PMFeatures.getLakeFeature("volcanic_dark_lava", PMFluids.DARK_LAVA_BLOCK, DeepDarkBlocks.DARK_MAGMA_BLOCK, 2, false);
    public static final ResourceKey<PlacedFeature> VOLCANIC_DARK_LAVA_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("volcanic_dark_lava", PMFluids.DARK_LAVA_BLOCK, DeepDarkBlocks.DARK_MAGMA_BLOCK, 2, true);
    public static final ResourceKey<PlacedFeature> TAR_PIT = PMFeatures.getLakeFeature("tar_pit", PMFluids.TAR_BLOCK, 80, false);
    public static final ResourceKey<PlacedFeature> MOLTEN_GOLD_LAKE = PMFeatures.getLakeFeature("molten_gold", PMFluids.MOLTEN_GOLD_BLOCK, 4, false);
    public static final ResourceKey<PlacedFeature> MOLTEN_GOLD_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("molten_gold", PMFluids.MOLTEN_GOLD_BLOCK, 4, true);
    public static final ResourceKey<PlacedFeature> MOLTEN_SILVER_LAKE = PMFeatures.getLakeFeature("molten_silver", PMFluids.MOLTEN_SILVER_BLOCK, 4, false);
    public static final ResourceKey<PlacedFeature> MOLTEN_SILVER_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("molten_silver", PMFluids.MOLTEN_SILVER_BLOCK, 4, true);
    public static final ResourceKey<PlacedFeature> MOLTEN_IRON_LAKE = PMFeatures.getLakeFeature("molten_iron", PMFluids.MOLTEN_IRON_BLOCK, 4, false);
    public static final ResourceKey<PlacedFeature> MOLTEN_IRON_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("molten_iron", PMFluids.MOLTEN_IRON_BLOCK, 4, true);
    public static final ResourceKey<PlacedFeature> MOLTEN_COPPER_LAKE = PMFeatures.getLakeFeature("molten_copper", PMFluids.MOLTEN_COPPER_BLOCK, 4, false);
    public static final ResourceKey<PlacedFeature> MOLTEN_COPPER_LAKE_UNDERGROUND = PMFeatures.getLakeFeature("molten_copper", PMFluids.MOLTEN_COPPER_BLOCK, 4, true);
    private static final Supplier<SpringConfiguration> LIQUID_REDSTONE_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.LIQUID_REDSTONE.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_152496_, Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> PSYCHEDELIC_LAVA_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.PSYCHEDELIC_LAVA.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_152496_, Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> HONEY_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.HONEY.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_50720_, Blocks.f_50719_, Blocks.f_152496_, Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> GLOWING_WATER_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.GLOWING_WATER.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> DEEP_DARK_LAVA_SPRING_CONFIG = () -> new SpringConfiguration(Fluids.f_76195_.m_76145_(), true, 4, 1, PMFeatures.blockList(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> DEEP_DARK_WATER_SPRING_CONFIG = () -> new SpringConfiguration(Fluids.f_76193_.m_76145_(), true, 4, 1, PMFeatures.blockList(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> DARK_LAVA_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.DARK_LAVA.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> TAR_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.TAR.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_152496_, Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> ENDER_ACID_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.ENDER_ACID.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(Blocks.f_50259_));
    private static final Supplier<SpringConfiguration> MOLTEN_SALT_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.MOLTEN_SALT.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_152496_, Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> VOLCANIC_SPRING_CONFIG = () -> new SpringConfiguration(Fluids.f_76195_.m_76145_(), true, 4, 1, PMFeatures.blockList(Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_152496_, Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> MOLTEN_GOLD_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.MOLTEN_GOLD.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> MOLTEN_SILVER_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.MOLTEN_SILVER.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> MOLTEN_IRON_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.MOLTEN_IRON.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> MOLTEN_COPPER_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.MOLTEN_COPPER.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_));
    private static final Supplier<SpringConfiguration> PSYCHEDELIC_SPRING_CONFIG = () -> new SpringConfiguration(((ForgeFlowingFluid)PMFluids.PSYCHEDELIC_FLUID.get()).m_76145_(), true, 4, 1, PMFeatures.blockList(DeepDarkBlocks.DARKSTONE.get(), Blocks.f_152550_));
    public static final ResourceKey<PlacedFeature> LIQUID_REDSTONE_SPRING = PMFeatures.getSpringFeature("liquid_redstone", LIQUID_REDSTONE_SPRING_CONFIG, false);
    public static final ResourceKey<PlacedFeature> PSYCHEDELIC_LAVA_SPRING = PMFeatures.getSpringFeature("psychedelic_lava", PSYCHEDELIC_LAVA_SPRING_CONFIG, false);
    public static final ResourceKey<PlacedFeature> TAR_SPRING = PMFeatures.getSpringFeature("tar", TAR_SPRING_CONFIG, false);
    public static final ResourceKey<PlacedFeature> HONEY_SPRING = PMFeatures.getSpringFeature("honey", HONEY_SPRING_CONFIG, true);
    public static final ResourceKey<PlacedFeature> ENDER_ACID_SPRING = PMFeatures.getSpringFeature("ender_acid", ENDER_ACID_SPRING_CONFIG, false);
    public static final ResourceKey<PlacedFeature> SALT_SPRING = PMFeatures.getSpringFeature("salt", MOLTEN_SALT_SPRING_CONFIG, true);
    public static final ResourceKey<PlacedFeature> VOLCANIC_SPRING = PMFeatures.getSpringFeature("volcanic", VOLCANIC_SPRING_CONFIG, true);
    public static final ResourceKey<PlacedFeature> GLOWING_WATER_SPRING = PMFeatures.getSpringFeature("glowing_water", GLOWING_WATER_SPRING_CONFIG, false);
    public static final ResourceKey<PlacedFeature> DEEP_DARK_WATER_SPRING = PMFeatures.getSpringFeature("deep_dark_water", DEEP_DARK_WATER_SPRING_CONFIG, false);
    public static final ResourceKey<PlacedFeature> DEEP_DARK_LAVA_SPRING = PMFeatures.getSpringFeature("deep_dark_lava", DEEP_DARK_LAVA_SPRING_CONFIG, false);
    public static final ResourceKey<PlacedFeature> DARK_LAVA_SPRING = PMFeatures.getSpringFeature("dark_lava", DARK_LAVA_SPRING_CONFIG, false);
    public static final ResourceKey<PlacedFeature> VOLCANIC_DARK_LAVA_SPRING = PMFeatures.getSpringFeature("volcanic_dark_lava", DARK_LAVA_SPRING_CONFIG, true);
    public static final ResourceKey<PlacedFeature> GOLD_SPRING = PMFeatures.getSpringFeature("gold", MOLTEN_GOLD_SPRING_CONFIG, true);
    public static final ResourceKey<PlacedFeature> SILVER_SPRING = PMFeatures.getSpringFeature("silver", MOLTEN_SILVER_SPRING_CONFIG, true);
    public static final ResourceKey<PlacedFeature> IRON_SPRING = PMFeatures.getSpringFeature("iron", MOLTEN_IRON_SPRING_CONFIG, true);
    public static final ResourceKey<PlacedFeature> COPPER_SPRING = PMFeatures.getSpringFeature("copper", MOLTEN_COPPER_SPRING_CONFIG, true);
    public static final ResourceKey<PlacedFeature> PSYCHEDELIC_SPRING = PMFeatures.getSpringFeature("psychedelic", PSYCHEDELIC_SPRING_CONFIG, true);
    public static final ResourceKey<PlacedFeature> GLOWSTONE_ORE = PMFeatures.getBlobFeature("ore/glowstone", () -> Blocks.f_50141_, () -> new TagMatchTest(Tags.Blocks.STONE));
    public static final ResourceKey<PlacedFeature> SALT_LAMP_ORE = PMFeatures.getBlobFeature("ore/salt_lamp", Misc.SALT_LAMP, () -> new TagMatchTest(Tags.Blocks.STONE));
    public static final ResourceKey<PlacedFeature> GLOWING_ICE_ORE = PMFeatures.getBlobFeature("ore/glowing_ice_ore", Misc.GLOWING_ICE, () -> new TagMatchTest(Tags.Blocks.STONE));
    public static final ResourceKey<PlacedFeature> HONEY_CRYSTAL_ORE = PMFeatures.getBlobFeature("ore/honey_crystal_", Misc.HONEY_CRYSTAL_BLOCK, () -> new TagMatchTest(Tags.Blocks.STONE));
    public static final ResourceKey<PlacedFeature> SEA_LANTERN_ORE = PMFeatures.getBlobFeature("ore/sea_lantern", () -> Blocks.f_50386_, () -> new TagMatchTest(Tags.Blocks.STONE));
    public static final ResourceKey<PlacedFeature> INSOMNIUM_FOSSIL = PMFeatures.getBasicFeature("insomnium_fossil", InsomniumFossil::new, new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)1), RarityFilter.m_191900_((int)2), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> INSOMNIUM_ROCK = PMFeatures.getBasicFeature("insomnium_rock", () -> new Boulder(Blocks.f_152550_, Blocks.f_152551_), new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)2), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> ICE_CHUNK = PMFeatures.getBasicFeature("ice_chunk", () -> new Boulder(Blocks.f_50354_, Blocks.f_50568_), new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)2), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> DDF_CRYSTALS = PMFeatures.getBasicFeature("ddf_crystals", () -> new FoliagePatch(PMTags.Blocks.CRYSTAL_CLUSTERS), new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)5), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> CRYSTAL_FOREST_CRYSTALS = PMFeatures.getBasicFeature("crystal_forest_crystals", () -> new FoliagePatch(PMTags.Blocks.CRYSTAL_CLUSTERS), new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)5), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> REGEN_STONE_BLOB = PMFeatures.getBlobFeature("regen_stone_blob", DeepDarkBlocks.REGENERATION_STONE, () -> new BlockMatchTest(DeepDarkBlocks.DARKSTONE.get()));
    public static final ResourceKey<PlacedFeature> DEEP_DARK_DEEPSLATE_BLOB = PMFeatures.getBlobFeature("deepslate_blob", () -> Blocks.f_152550_, () -> new BlockMatchTest(DeepDarkBlocks.DARKSTONE.get()));
    public static final ResourceKey<PlacedFeature> FULL_CHRISTMAS_TREE = PMFeatures.getBasicFeature("full_christmas_tree", FullChristmasTree::new, new PlacementModifier[]{InfiniteCountPlacement.of(512), InSquarePlacement.m_191715_(), FULL_HEIGHT_RANGE, InfiniteCountPlacement.of((IntProvider)UniformInt.m_146622_((int)1, (int)5)), RandomOffsetPlacement.m_191879_((IntProvider)ClampedNormalInt.m_185879_((float)0.0f, (float)3.0f, (int)-10, (int)10), (IntProvider)ClampedNormalInt.m_185879_((float)0.0f, (float)0.6f, (int)-2, (int)2)), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> ICE_SPIRE = PMFeatures.getBasicFeature("ice_spire", IceSpire::new, new PlacementModifier[]{InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)40), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> ICE_SPIRE_OWC = PMFeatures.getBasicFeature("ice_spire_owc", IceSpire::new, new PlacementModifier[]{InSquarePlacement.m_191715_(), CountOnEveryLayerPlacement.m_191604_((int)20), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> FISSURE = PMFeatures.getBasicFeature("fissure", () -> new LavaFissure(false), new PlacementModifier[]{InSquarePlacement.m_191715_(), CountOnEveryLayerPlacement.m_191604_((int)10), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> DARK_FISSURE = PMFeatures.getBasicFeature("dark_fissure", () -> new LavaFissure(true), new PlacementModifier[]{InSquarePlacement.m_191715_(), CountOnEveryLayerPlacement.m_191604_((int)10), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> VOLCANIC_OBSIDIAN = PMFeatures.getBlobFeature("volcanic_obsidian", () -> Blocks.f_50080_, () -> new TagMatchTest(Tags.Blocks.STONE));
    public static final ResourceKey<PlacedFeature> VOLCANIC_OBSIDIAN_DEEPSLATE = PMFeatures.getBlobFeature("volcanic_obsidian_ds", () -> Blocks.f_50080_, () -> new BlockMatchTest(Blocks.f_152550_));
    public static final ResourceKey<PlacedFeature> VOLCANIC_TUFF = PMFeatures.getBlobFeature("volcanic_tuff", () -> Blocks.f_152496_, () -> new TagMatchTest(Tags.Blocks.STONE));
    public static final ResourceKey<PlacedFeature> VOLCANIC_TUFF_DEEPSLATE = PMFeatures.getBlobFeature("volcanic_tuff_ds", () -> Blocks.f_152496_, () -> new BlockMatchTest(Blocks.f_152550_));
    public static final ResourceKey<PlacedFeature> VOLCANIC_MAGMA = PMFeatures.getBlobFeature("volcanic_magma", () -> Blocks.f_50450_, () -> new TagMatchTest(Tags.Blocks.STONE));
    public static final ResourceKey<PlacedFeature> VOLCANIC_MAGMA_DEEPSLATE = PMFeatures.getBlobFeature("volcanic_magma_ds", () -> Blocks.f_50450_, () -> new BlockMatchTest(Blocks.f_152550_));
    public static final ResourceKey<PlacedFeature> DARK_MAGMA = PMFeatures.getBlobFeature("dark_magma", DeepDarkBlocks.DARK_MAGMA_BLOCK, () -> new BlockMatchTest(DeepDarkBlocks.DARKSTONE.get()));
    public static final ResourceKey<PlacedFeature> VOLCANIC_BASALT = PMFeatures.getBlobFeature("volcanic_basalt", () -> Blocks.f_50137_, () -> new TagMatchTest(Tags.Blocks.STONE));
    public static final ResourceKey<PlacedFeature> VOLCANIC_BASALT_DEEPSLATE = PMFeatures.getBlobFeature("volcanic_basalt_ds", () -> Blocks.f_50137_, () -> new BlockMatchTest(Blocks.f_152550_));
    public static final ResourceKey<PlacedFeature> DESERT_ROCK = PMFeatures.getBasicFeature("desert_rock", () -> new Boulder(Blocks.f_50069_, Blocks.f_50652_), new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> VOLCANIC_BLACK_GLOWING_OBSIDIAN = PMFeatures.getBlobFeature("volcanic_black_glowing_obsidian", () -> Building.BLACK_GLOWING_OBSIDIAN.get(), () -> new BlockMatchTest(DeepDarkBlocks.DARKSTONE.get()));
    public static final ResourceKey<PlacedFeature> VOLCANIC_GOLD_GLOWING_OBSIDIAN = PMFeatures.getBlobFeature("volcanic_gold_glowing_obsidian", () -> Building.GOLD_GLOWING_OBSIDIAN.get(), () -> new BlockMatchTest(DeepDarkBlocks.DARKSTONE.get()));
    public static final ResourceKey<PlacedFeature> VOLCANIC_SILVER_GLOWING_OBSIDIAN = PMFeatures.getBlobFeature("volcanic_silver_glowing_obsidian", () -> Building.SILVER_GLOWING_OBSIDIAN.get(), () -> new BlockMatchTest(DeepDarkBlocks.DARKSTONE.get()));
    public static final ResourceKey<PlacedFeature> VOLCANIC_IRON_GLOWING_OBSIDIAN = PMFeatures.getBlobFeature("volcanic_iron_glowing_obsidian", () -> Building.IRON_GLOWING_OBSIDIAN.get(), () -> new BlockMatchTest(DeepDarkBlocks.DARKSTONE.get()));
    public static final ResourceKey<PlacedFeature> VOLCANIC_COPPER_GLOWING_OBSIDIAN = PMFeatures.getBlobFeature("volcanic_copper_glowing_obsidian", () -> Building.COPPER_GLOWING_OBSIDIAN.get(), () -> new BlockMatchTest(DeepDarkBlocks.DARKSTONE.get()));
    public static final List<ResourceKey<PlacedFeature>> ORES = PMFeatures.createOreFeatures();
    public static final EnumMap<DyeColor, ResourceKey<PlacedFeature>> ROSE_FIELD_PATCHES = PMFeatures.createColorFlowerPatches();

    public static void init(IEventBus eventbus) {
        PMFoliage.init();
        PMCaveFeatures.init(eventbus);
        FEATURES.register(eventbus);
        PLACEMENT_MODIFIERS.register(eventbus);
        ChunkProcessor.addRawProcessor(new BaseCaveGen());
        ChunkProcessor.addRawProcessor(new OWCSurfaceFixerUpper());
        ChunkProcessor.addRawProcessor(new IceSheet(() -> Blocks.f_50127_, Misc.GLOWING_ICE, Misc.GLOWING_ICE, PMBiomes.GLOWING_GLACIER));
        ChunkProcessor.addRawProcessor(new IceSheet(() -> Blocks.f_50127_, () -> Blocks.f_50354_, () -> Blocks.f_50568_, PMBiomes.POLAR_WINTER, PMBiomes.GLACIER, PMBiomes.SUBGLACIAL_VOLCANIC_FIELD, PMBiomes.UNDERGROUND_GLACIER));
        ChunkProcessor.addVegetalProcessor(new SnowBlanket(PMBiomes.GLOWING_GLACIER, PMBiomes.POLAR_WINTER, PMBiomes.GLACIER, PMBiomes.SUBGLACIAL_VOLCANIC_FIELD, PMBiomes.UNDERGROUND_GLACIER));
    }

    private static <T extends PlacementModifier> RegistryObject<PlacementModifierType<T>> createPlacementModifierType(String name, Codec<T> codec) {
        return PLACEMENT_MODIFIERS.register(name, () -> () -> codec);
    }

    private static ResourceKey<PlacedFeature> createGeode(String name, int chance, Supplier<Block> crystal, Supplier<Block> inner, Supplier<Block> middle, Supplier<Block> outer) {
        String geodeName = "geode/" + name;
        ResourceKey<ConfiguredFeature<?, ?>> feature = PMFeatures.regConfFeature(geodeName, Feature.f_159728_, (cfgFeatureGetter, featureGetter) -> {
            List<BlockState> crystals = List.of((BlockState)((Block)crystal.get()).m_49966_().m_61124_((Property)CrystalCluster.TYPE, (Comparable)Integer.valueOf(0)), (BlockState)((Block)crystal.get()).m_49966_().m_61124_((Property)CrystalCluster.TYPE, (Comparable)Integer.valueOf(1)), (BlockState)((Block)crystal.get()).m_49966_().m_61124_((Property)CrystalCluster.TYPE, (Comparable)Integer.valueOf(2)), (BlockState)((Block)crystal.get()).m_49966_().m_61124_((Property)CrystalCluster.TYPE, (Comparable)Integer.valueOf(3)));
            return new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50016_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)inner.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)inner.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)middle.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)outer.get())), crystals, BlockTags.f_144287_, BlockTags.f_144289_), new GeodeLayerSettings(1.7, 2.2, 3.2, 4.2), new GeodeCrackSettings(0.95, 2.0, 2), 0.35, 0.083, true, (IntProvider)UniformInt.m_146622_((int)4, (int)6), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)1, (int)2), -16, 16, 0.05, 1);
        });
        return PMFeatures.regPlacedFeature(geodeName, feature, new PlacementModifier[]{RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)6), (VerticalAnchor)VerticalAnchor.m_158922_((int)30)), BiomeFilter.m_191561_()});
    }

    private static ResourceKey<PlacedFeature> getSpringFeature(String name, Supplier<SpringConfiguration> config, boolean biomeSpecific) {
        return PMFeatures.regPlacedFeature("spring/" + name, Feature.f_65765_, (HolderGetter<ConfiguredFeature<?, ?>> cfgFeatureGetter, HolderGetter<PlacedFeature> featureGetter) -> (SpringConfiguration)config.get(), new PlacementModifier[]{CountPlacement.m_191628_((int)(biomeSpecific ? 150 : 25)), InSquarePlacement.m_191715_(), FULL_HEIGHT_RANGE, BiomeFilter.m_191561_()});
    }

    private static ResourceKey<PlacedFeature> getBlobFeature(String name, Supplier<Block> block, Supplier<RuleTest> targetBlocks) {
        return PMFeatures.regPlacedFeature(name, Feature.f_65731_, (HolderGetter<ConfiguredFeature<?, ?>> cfgFeatureGetter, HolderGetter<PlacedFeature> featureGetter) -> new OreConfiguration((RuleTest)targetBlocks.get(), ((Block)block.get()).m_49966_(), 33), new PlacementModifier[]{FULL_HEIGHT_RANGE, CountPlacement.m_191628_((int)256), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
    }

    private static ResourceKey<PlacedFeature> getLakeFeature(String name, Supplier<? extends Block> fluidBlock, int chance, boolean underground) {
        return PMFeatures.getLakeFeature(name, fluidBlock, () -> Blocks.f_50016_, chance, underground);
    }

    private static ResourceKey<PlacedFeature> getLakeFeature(String name, Supplier<? extends Block> fluidBlock, Supplier<? extends Block> barrier, int chance, boolean underground) {
        PlacementModifier[] placements = underground ? new PlacementModifier[]{RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), FULL_HEIGHT_RANGE, EnvironmentScanPlacement.m_191653_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.f_190393_), (BlockPredicate)BlockPredicate.m_190433_((Vec3i)new BlockPos(0, -5, 0))), (int)32), SurfaceRelativeThresholdFilter.m_191930_((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, (int)Integer.MIN_VALUE, (int)-5), BiomeFilter.m_191561_()} : new PlacementModifier[]{RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()};
        return PMFeatures.regPlacedFeature("lake/" + name + (underground ? "_underground" : ""), Feature.f_65783_, (HolderGetter<ConfiguredFeature<?, ?>> cfgFeatureGetter, HolderGetter<PlacedFeature> featureGetter) -> new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)fluidBlock.get()).m_49966_()), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)barrier.get()).m_49966_())), placements);
    }

    private static ResourceKey<PlacedFeature> getCrystalFeature(CrystalGen.Type type, boolean genExtra) {
        PlacementModifier[] placementModifierArray;
        int height = type == CrystalGen.Type.END_MIXED || type == CrystalGen.Type.END_RANDOM || type == CrystalGen.Type.QUARTZ ? 129 : 310;
        String featureName = "crystals/" + (genExtra ? "extra_" : "") + type.name().toLowerCase();
        Supplier<CrystalGen> supplier = () -> new CrystalGen(type);
        FeatureConfigSupplier<NoneFeatureConfiguration> featureConfigSupplier = (cfgFeatureGetter, featureGetter) -> FeatureConfiguration.f_67737_;
        if (genExtra) {
            PlacementModifier[] placementModifierArray2 = new PlacementModifier[6];
            placementModifierArray2[0] = InfiniteCountPlacement.of(type == CrystalGen.Type.HONEY ? 64 : 128);
            placementModifierArray2[1] = InSquarePlacement.m_191715_();
            placementModifierArray2[2] = FULL_HEIGHT_RANGE;
            placementModifierArray2[3] = InfiniteCountPlacement.of((IntProvider)UniformInt.m_146622_((int)1, (int)5));
            placementModifierArray2[4] = RandomOffsetPlacement.m_191879_((IntProvider)ClampedNormalInt.m_185879_((float)0.0f, (float)3.0f, (int)-10, (int)10), (IntProvider)ClampedNormalInt.m_185879_((float)0.0f, (float)0.6f, (int)-2, (int)2));
            placementModifierArray = placementModifierArray2;
            placementModifierArray2[5] = BiomeFilter.m_191561_();
        } else {
            PlacementModifier[] placementModifierArray3 = new PlacementModifier[1];
            placementModifierArray = placementModifierArray3;
            placementModifierArray3[0] = HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)height));
        }
        return PMFeatures.regPlacedFeature(featureName, supplier, featureConfigSupplier, placementModifierArray);
    }

    public static ResourceKey<PlacedFeature> getBasicFeature(String name, Supplier<? extends BasicFeature> feature, PlacementModifier ... placements) {
        return PMFeatures.regPlacedFeature(name, feature, (HolderGetter<ConfiguredFeature<?, ?>> cfgFeatureGetter, HolderGetter<PlacedFeature> featureGetter) -> FeatureConfiguration.f_67737_, placements);
    }

    public static ResourceKey<PlacedFeature> getBigFoliagePlacer(String name, boolean sparse, boolean multilayer, List<ResourceKey<PlacedFeature>> commonPlants, List<ResourceKey<PlacedFeature>> rarePlants, List<ResourceKey<ConfiguredFeature<?, ?>>> inlinePlants) {
        int chance = sparse ? 5 : 10;
        ArrayList<CountOnEveryLayerPlacement> placements = multilayer ? new ArrayList<CountOnEveryLayerPlacement>(List.of(CountOnEveryLayerPlacement.m_191604_((int)chance))) : new ArrayList(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)chance, (float)0.1f, (int)1)));
        placements.add((CountOnEveryLayerPlacement)BiomeFilter.m_191561_());
        return PMFeatures.regPlacedFeature(name, Feature.f_65754_, (HolderGetter<ConfiguredFeature<?, ?>> cfgFeatureGetter, HolderGetter<PlacedFeature> featureGetter) -> {
            ArrayList<WeightedPlacedFeature> plants = new ArrayList<WeightedPlacedFeature>(commonPlants.stream().map(plant -> new WeightedPlacedFeature((Holder)featureGetter.m_255043_(plant), 1.0f / (float)commonPlants.size())).toList());
            plants.addAll(rarePlants.stream().map(plant -> new WeightedPlacedFeature((Holder)featureGetter.m_255043_(plant), 1.0f / (float)((commonPlants.size() + inlinePlants.size()) * 2))).toList());
            for (ResourceKey inlinePlant : inlinePlants) {
                plants.add(new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)cfgFeatureGetter.m_255043_(inlinePlant), (PlacementModifier[])new PlacementModifier[0]), 1.0f / (float)((commonPlants.size() + inlinePlants.size()) * 2)));
            }
            return new RandomFeatureConfiguration(plants, (Holder)featureGetter.m_255043_((ResourceKey)commonPlants.get(0)));
        }, (PlacementModifier[])placements.toArray(PlacementModifier[]::new));
    }

    @SafeVarargs
    public static ResourceKey<PlacedFeature> getBigFoliagePlacer(String name, boolean sparse, boolean multilayer, List<ResourceKey<PlacedFeature>> plants, ResourceKey<ConfiguredFeature<?, ?>> ... inlinePlants) {
        int chance = sparse ? 5 : 10;
        ArrayList<CountOnEveryLayerPlacement> placements = multilayer ? new ArrayList<CountOnEveryLayerPlacement>(List.of(CountOnEveryLayerPlacement.m_191604_((int)chance))) : new ArrayList(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)chance, (float)0.1f, (int)1)));
        placements.add((CountOnEveryLayerPlacement)BiomeFilter.m_191561_());
        return PMFeatures.regPlacedFeature(name, Feature.f_65754_, (HolderGetter<ConfiguredFeature<?, ?>> cfgFeatureGetter, HolderGetter<PlacedFeature> featureGetter) -> {
            ArrayList<WeightedPlacedFeature> plantList = new ArrayList<WeightedPlacedFeature>(plants.stream().map(plant -> new WeightedPlacedFeature((Holder)featureGetter.m_255043_(plant), 1.0f / (float)(plants.size() + inlinePlants.length))).toList());
            for (ResourceKey inlinePlant : inlinePlants) {
                plantList.add(new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)cfgFeatureGetter.m_255043_(inlinePlant), (PlacementModifier[])new PlacementModifier[0]), 1.0f / (float)(plants.size() + inlinePlants.length)));
            }
            ResourceKey plant2 = !plants.isEmpty() ? (ResourceKey)plants.get(0) : EMPTY;
            return new RandomFeatureConfiguration(plantList, (Holder)featureGetter.m_255043_(plant2));
        }, (PlacementModifier[])placements.toArray(PlacementModifier[]::new));
    }

    public static HolderSet<Block> blockList(Block ... blocks) {
        return HolderSet.m_205806_(Block::m_204297_, (Object[])blocks);
    }

    private static EnumMap<DyeColor, ResourceKey<PlacedFeature>> createColorFlowerPatches() {
        EnumMap<DyeColor, ResourceKey<PlacedFeature>> flowerPatches = new EnumMap<DyeColor, ResourceKey<PlacedFeature>>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            flowerPatches.put(color, PMFeatures.regPlacedFeature("rose_patch/" + color.m_41065_(), Feature.f_65763_, (HolderGetter<ConfiguredFeature<?, ?>> cfgFeatureGetter, HolderGetter<PlacedFeature> featureGetter) -> FeatureUtils.m_206470_((int)192, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(PMFeatures.getFlowers(color))))), new PlacementModifier[]{CountPlacement.m_191628_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}));
        }
        return flowerPatches;
    }

    private static SimpleWeightedRandomList<BlockState> getFlowers(DyeColor color) {
        SimpleWeightedRandomList.Builder flowers = new SimpleWeightedRandomList.Builder();
        switch (color) {
            case BLACK: {
                flowers.m_146271_((Object)Blocks.f_50070_.m_49966_(), 10);
                break;
            }
            case RED: {
                flowers.m_146271_((Object)Blocks.f_50112_.m_49966_(), 10).m_146271_((Object)Blocks.f_50116_.m_49966_(), 10);
                break;
            }
            case BLUE: {
                flowers.m_146271_((Object)Blocks.f_50121_.m_49966_(), 10);
                break;
            }
            case PINK: {
                flowers.m_146271_((Object)Blocks.f_50119_.m_49966_(), 10);
                break;
            }
            case WHITE: {
                flowers.m_146271_((Object)Blocks.f_50071_.m_49966_(), 10);
                break;
            }
            case ORANGE: {
                flowers.m_146271_((Object)Blocks.f_50117_.m_49966_(), 10);
                break;
            }
            case YELLOW: {
                flowers.m_146271_((Object)Blocks.f_50111_.m_49966_(), 10);
                break;
            }
            case MAGENTA: {
                flowers.m_146271_((Object)Blocks.f_50114_.m_49966_(), 10);
                break;
            }
            case LIGHT_BLUE: {
                flowers.m_146271_((Object)Blocks.f_50113_.m_49966_(), 10);
                break;
            }
            case LIGHT_GRAY: {
                flowers.m_146271_((Object)Blocks.f_50115_.m_49966_(), 10).m_146271_((Object)Blocks.f_50120_.m_49966_(), 10).m_146271_((Object)Blocks.f_50118_.m_49966_(), 10);
            }
        }
        BlockState rose = Decoration.ROSES.get(color).get().m_49966_();
        flowers.m_146271_((Object)rose, 20);
        return flowers.m_146270_();
    }

    private static List<ResourceKey<PlacedFeature>> createOreFeatures() {
        ArrayList<ResourceKey<PlacedFeature>> featureList = new ArrayList<ResourceKey<PlacedFeature>>();
        for (OreType ore : OreType.values()) {
            featureList.add(PMFeatures.regPlacedFeature("ore/" + ore.name().toLowerCase(), Feature.f_65731_, (HolderGetter<ConfiguredFeature<?, ?>> cfgFeatureGetter, HolderGetter<PlacedFeature> featureGetter) -> new OreConfiguration((RuleTest)ore.getGenRule(), ore.getBlock().m_49966_(), ore.getMaxVeinSize()), new PlacementModifier[]{InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)10), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)ore.getMinHeight()), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.getMaxHeight())), RarityFilter.m_191900_((int)ore.getRarity()), new ConfiguredOrePlacement(ore.configKey())}));
        }
        return featureList;
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> regConfFeature(String name, F feature, FeatureConfigSupplier<FC> config) {
        ResourceKey key = PMRegistries.createModResourceKey(Registries.f_256911_, name);
        CFG_FEATURES.put(key, (cfgFeatureGetter, featureGetter) -> new ConfiguredFeature(feature, config.get(cfgFeatureGetter, (HolderGetter<PlacedFeature>)featureGetter)));
        return key;
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<PlacedFeature> regPlacedFeature(String name, F feature, FeatureConfigSupplier<FC> config, PlacementModifier ... placements) {
        ResourceKey<ConfiguredFeature<?, ?>> confFeature = PMFeatures.regConfFeature(name, feature, config);
        ResourceKey key = PMRegistries.createModResourceKey(Registries.f_256988_, name);
        PLACED_FEATURES.put(key, (cfgFeatureGetter, featureGetter) -> new PlacedFeature((Holder)cfgFeatureGetter.m_255043_(confFeature), List.of(placements)));
        return key;
    }

    public static <FC extends FeatureConfiguration> ResourceKey<PlacedFeature> regPlacedFeature(String name, Supplier<? extends Feature<FC>> feature, FeatureConfigSupplier<FC> config, PlacementModifier ... placements) {
        RegistryObject regFeature = Utils.handlePossibleException(() -> FEATURES.register(name.replace("/", "_"), feature));
        ResourceKey cfgFeatureKey = PMRegistries.createModResourceKey(Registries.f_256911_, name);
        CFG_FEATURES.put(cfgFeatureKey, (cfgFeatureGetter, featureGetter) -> new ConfiguredFeature((Feature)regFeature.get(), config.get(cfgFeatureGetter, (HolderGetter<PlacedFeature>)featureGetter)));
        ResourceKey key = PMRegistries.createModResourceKey(Registries.f_256988_, name);
        PLACED_FEATURES.put(key, (cfgFeatureGetter, featureGetter) -> new PlacedFeature((Holder)cfgFeatureGetter.m_255043_(cfgFeatureKey), List.of(placements)));
        return key;
    }

    public static ResourceKey<PlacedFeature> regPlacedFeature(String name, ResourceKey<ConfiguredFeature<?, ?>> confFeature, PlacementModifier ... placements) {
        ResourceKey key = PMRegistries.createModResourceKey(Registries.f_256988_, name);
        PLACED_FEATURES.put(key, (cfgFeatureGetter, featureGetter) -> new PlacedFeature((Holder)cfgFeatureGetter.m_255043_(confFeature), List.of(placements)));
        return key;
    }

    @FunctionalInterface
    public static interface FeatureConfigSupplier<FC extends FeatureConfiguration> {
        public FC get(HolderGetter<ConfiguredFeature<?, ?>> var1, HolderGetter<PlacedFeature> var2);
    }

    @FunctionalInterface
    public static interface ConfiguredFeatureFactory
    extends PMWorld.WorldgenFactory<ConfiguredFeature<?, ?>> {
        @Override
        default public ConfiguredFeature<?, ?> generate(BootstapContext<ConfiguredFeature<?, ?>> context) {
            HolderGetter cfgFeatureGetter = context.m_255420_(Registries.f_256911_);
            HolderGetter featureGetter = context.m_255420_(Registries.f_256988_);
            return this.create(cfgFeatureGetter, (HolderGetter<PlacedFeature>)featureGetter);
        }

        public ConfiguredFeature<?, ?> create(HolderGetter<ConfiguredFeature<?, ?>> var1, HolderGetter<PlacedFeature> var2);
    }

    @FunctionalInterface
    public static interface PlacedFeatureFactory
    extends PMWorld.WorldgenFactory<PlacedFeature> {
        @Override
        default public PlacedFeature generate(BootstapContext<PlacedFeature> context) {
            HolderGetter cfgFeatureGetter = context.m_255420_(Registries.f_256911_);
            HolderGetter featureGetter = context.m_255420_(Registries.f_256988_);
            return this.create(cfgFeatureGetter, (HolderGetter<PlacedFeature>)featureGetter);
        }

        public PlacedFeature create(HolderGetter<ConfiguredFeature<?, ?>> var1, HolderGetter<PlacedFeature> var2);
    }
}

