/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.fluid.PMFluids;
import net.paradisemod.worldgen.features.chunk.ChunkProcessor;

public class SnowBlanket
extends ChunkProcessor {
    private final List<ResourceKey<Biome>> ignoredBiomes;

    @SafeVarargs
    public SnowBlanket(ResourceKey<Biome> ... ignoredBiomes) {
        this.ignoredBiomes = List.of(ignoredBiomes);
    }

    @Override
    protected void processBlock(WorldGenLevel world, RandomSource rand, BlockPos pos, BlockState curState, Holder<Biome> biome, ChunkGenerator generator) {
        BlockState stateAbove = world.m_8055_(pos.m_7494_());
        if (stateAbove.m_60795_() && biome.m_203656_(Tags.Biomes.IS_SNOWY) && !this.ignoredBiomes.contains(biome.m_203543_().get())) {
            if (curState.m_204336_(BlockTags.f_13035_)) {
                world.m_7731_(pos.m_7494_(), Blocks.f_50125_.m_49966_(), 32);
            } else if (world.m_46801_(pos)) {
                world.m_7731_(pos, Blocks.f_50126_.m_49966_(), 32);
            } else if (world.m_6425_(pos).m_192917_((Fluid)PMFluids.GLOWING_WATER.get())) {
                world.m_7731_(pos, Misc.GLOWING_ICE.get().m_49966_(), 32);
            } else if (curState.m_204336_(BlockTags.f_144274_)) {
                if (curState.m_61138_((Property)SnowyDirtBlock.f_56637_)) {
                    world.m_7731_(pos, (BlockState)curState.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 32);
                }
                world.m_7731_(pos.m_7494_(), Blocks.f_50125_.m_49966_(), 32);
            }
        }
    }
}

