/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.cave;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.Ores;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.blocks.LargeCaveFormation;
import net.paradisemod.world.blocks.SmallCaveFormation;
import net.paradisemod.world.dimension.PMDimensions;
import net.paradisemod.world.fluid.PMFluids;
import net.paradisemod.worldgen.features.cave.PMCaveFeatures;
import net.paradisemod.worldgen.features.chunk.ChunkProcessor;

public class BaseCaveGen
extends ChunkProcessor {
    @Override
    protected void processBlock(WorldGenLevel world, RandomSource rand, BlockPos pos, BlockState curState, Holder<Biome> biome, ChunkGenerator generator) {
        block24: {
            ResourceKey dim;
            block23: {
                BlockState stateAbove = world.m_8055_(pos.m_7494_());
                Block surface = null;
                Block underSurface = null;
                dim = world.m_6018_().m_46472_();
                if (PMBiomes.isSandyDesert(biome) && PMDimensions.isDimOverworldLike(world) && pos.m_123342_() <= 80) {
                    surface = Blocks.f_50062_;
                } else if (PMBiomes.isRockyDesert(biome)) {
                    surface = Blocks.f_50546_;
                    underSurface = Blocks.f_50546_;
                } else if (biome.m_203565_(PMBiomes.UNDERGROUND_MANGROVE_SWAMP) || biome.m_203565_(Biomes.f_220595_)) {
                    surface = Blocks.f_220864_;
                    underSurface = Blocks.f_220864_;
                } else if (biome.m_203656_(BiomeTags.f_207610_) || biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                    surface = Blocks.f_50440_;
                    underSurface = Blocks.f_50493_;
                } else if (biome.m_203656_(Tags.Biomes.IS_MUSHROOM) && !biome.m_203565_(PMBiomes.GLIMMERING_WEALD)) {
                    surface = Blocks.f_50195_;
                    underSurface = Blocks.f_50493_;
                } else if (biome.m_203656_(PMTags.Biomes.SALT)) {
                    surface = Ores.SALT_BLOCK.get();
                    underSurface = Ores.COMPACT_SALT_BLOCK.get();
                } else if (biome.m_203656_(BiomeTags.f_207607_)) {
                    if (pos.m_123342_() <= 80) {
                        surface = Blocks.f_50394_;
                    }
                    if (PMCaveFeatures.isValidBlock(curState) && PMWorld.isBlockInWall((LevelAccessor)world, pos)) {
                        this.genBadlandStripes(world, pos);
                        return;
                    }
                } else if (biome.m_203565_(PMBiomes.HONEY_CAVE) && PMCaveFeatures.isValidBlock(curState) && PMWorld.isBlockInWall((LevelAccessor)world, pos)) {
                    this.genHiveWall(world, pos, rand);
                    return;
                }
                if (!PMCaveFeatures.isValidBlock(curState) || !stateAbove.m_60819_().m_192917_(Fluids.f_76191_) || stateAbove.m_280296_() || stateAbove.m_60734_() instanceof LargeCaveFormation || stateAbove.m_60734_() instanceof SmallCaveFormation) break block23;
                if (rand.m_188503_(1000) == 0) {
                    world.m_7731_(pos.m_7494_(), Blocks.f_50033_.m_49966_(), 32);
                }
                if (surface == null) break block24;
                world.m_7731_(pos, surface.m_49966_(), 32);
                if (underSurface == null || !world.m_8055_(pos.m_7495_()).m_280296_()) break block24;
                world.m_7731_(pos.m_7495_(), underSurface.m_49966_(), 32);
                break block24;
            }
            if (curState.m_60819_().m_192917_((Fluid)Fluids.f_76195_) || curState.m_60713_(Blocks.f_50080_)) {
                if (PMDimensions.Type.OVERWORLD_CORE.is((ResourceKey<Level>)dim) && pos.m_123342_() <= -54) {
                    Block blockToPlace = PMFluids.PSYCHEDELIC_LAVA_BLOCK.get();
                    if (pos.m_123342_() == -54) {
                        ITag<Block> glowingObsidian = Utils.getBlockTag(PMTags.Blocks.GLOWING_OBSIDIAN);
                        blockToPlace = (Block)glowingObsidian.getRandomElement(rand).get();
                    }
                    world.m_7731_(pos, blockToPlace.m_49966_(), 16);
                } else {
                    for (Direction dir : Direction.values()) {
                        BlockPos relPos = pos.m_121945_(dir);
                        if (!world.m_8055_(relPos).m_204336_(Tags.Blocks.STONE) || !PMDimensions.isDimOverworldLike(world)) continue;
                        world.m_7731_(relPos, Blocks.f_50450_.m_49966_(), 32);
                    }
                }
            }
        }
    }

    @Override
    protected int maxHeight(WorldGenLevel world) {
        return PMCaveFeatures.dimWorldgenLimit(world);
    }

    private void genBadlandStripes(WorldGenLevel world, BlockPos pos) {
        Block block = Blocks.f_50352_;
        int y = pos.m_123342_();
        if (y % 5 == 0) {
            block = Blocks.f_50288_;
        } else if (y % 6 == 0) {
            block = Blocks.f_50287_;
        } else if (y % 7 == 0) {
            block = Blocks.f_50299_;
        } else if (y % 8 == 0) {
            block = Blocks.f_50291_;
        } else if (y % 9 == 0) {
            block = Blocks.f_50301_;
        }
        world.m_7731_(pos, block.m_49966_(), 32);
    }

    private void genHiveWall(WorldGenLevel world, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(15) == 0 && BaseCaveGen.supportsBeehive((LevelAccessor)world, pos) && PMWorld.isBlockInWall((LevelAccessor)world, pos)) {
            world.m_7731_(pos, (BlockState)((BlockState)Blocks.f_50717_.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)BaseCaveGen.exposedBeehiveDirection((LevelAccessor)world, pos))).m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(rand.m_188503_(6))), 32);
            BeehiveBlockEntity hive = (BeehiveBlockEntity)world.m_7702_(pos);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_((Object)EntityType.f_20550_).toString());
            hive.m_155157_(nbt, rand.m_188503_(599), false);
        } else if (rand.m_188503_(5) == 0) {
            world.m_7731_(pos, Misc.HONEY_CRYSTAL_BLOCK.get().m_49966_(), 32);
        } else {
            world.m_7731_(pos, Blocks.f_50720_.m_49966_(), 32);
        }
    }

    private static boolean supportsBeehive(LevelAccessor world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState curState = world.m_8055_(pos.m_121945_(direction));
            if (!curState.m_60795_()) continue;
            return true;
        }
        return false;
    }

    private static Direction exposedBeehiveDirection(LevelAccessor world, BlockPos pos) {
        RandomSource rand = world.m_213780_();
        ArrayList<Direction> exposedDirs = new ArrayList<Direction>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState curState = world.m_8055_(pos.m_121945_(direction));
            if (!curState.m_60795_()) continue;
            exposedDirs.add(direction);
        }
        return (Direction)exposedDirs.get(rand.m_188503_(exposedDirs.size()));
    }
}

