/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.cave;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.Ores;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.dimension.PMDimensions;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.cave.PMCaveFeatures;

public class CaveBlocks
extends BasicFeature {
    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        BlockState curState = world.m_8055_(pos);
        Holder biome = world.m_204166_(pos);
        ResourceKey dim = world.m_6018_().m_46472_();
        int worldgenLimit = PMCaveFeatures.dimWorldgenLimit(world);
        if ((pos.m_123342_() <= worldgenLimit || !PMCaveFeatures.seesSky(world, pos)) && PMWorld.isBlockExposed((LevelAccessor)world, pos) && PMCaveFeatures.isValidBlock(curState)) {
            Block blockToPlace = null;
            if (curState.m_60713_(Blocks.f_152550_)) {
                blockToPlace = Blocks.f_152551_;
            } else if (curState.m_60713_(Blocks.f_50069_)) {
                Block block = blockToPlace = PMCaveFeatures.shouldBeMossy(rand, (Holder<Biome>)world.m_204166_(pos)) ? Blocks.f_50079_ : Blocks.f_50652_;
            }
            if (PMBiomes.isSandyDesert((Holder<Biome>)biome) && PMDimensions.isDimOverworldLike(world) && rand.m_188503_(5) == 0) {
                blockToPlace = Blocks.f_50062_;
            }
            if (biome.m_203565_(PMBiomes.DARK_DESERT)) {
                blockToPlace = DeepDarkBlocks.BLACKENED_SANDSTONE.get();
            }
            if (biome.m_203656_(BiomeTags.f_207610_) || biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                if (biome.m_203656_(Tags.Biomes.IS_SWAMP) && rand.m_188503_(5) == 0) {
                    blockToPlace = Blocks.f_50374_;
                }
                if (rand.m_188499_()) {
                    blockToPlace = Blocks.f_50079_;
                }
                if (rand.m_188503_(5) == 0) {
                    blockToPlace = Blocks.f_50141_;
                }
            }
            if (biome.m_203656_(BiomeTags.f_207607_) && rand.m_188499_()) {
                blockToPlace = Blocks.f_50394_;
            }
            if (biome.m_203656_(PMTags.Biomes.VOLCANIC) && rand.m_188503_(5) == 0) {
                blockToPlace = Blocks.f_50450_;
            }
            if (biome.m_203656_(BiomeTags.f_207603_)) {
                if (rand.m_188499_()) {
                    blockToPlace = Blocks.f_50377_;
                }
                if (rand.m_188503_(5) == 0) {
                    Block block = blockToPlace = rand.m_188499_() ? Misc.PRISMARINE_CRYSTAL_BLOCK.get() : Blocks.f_50386_;
                }
            }
            if (biome.m_203656_(PMTags.Biomes.SALT)) {
                if (rand.m_188499_()) {
                    blockToPlace = Ores.COMPACT_SALT_BLOCK.get();
                }
                if (rand.m_188499_()) {
                    if (curState.m_60713_(Blocks.f_50069_)) {
                        blockToPlace = Ores.SALT_ORE.get();
                    } else if (curState.m_60713_(Blocks.f_152550_)) {
                        blockToPlace = Ores.DEEPSLATE_SALT_ORE.get();
                    }
                }
                if (rand.m_188503_(5) == 0) {
                    blockToPlace = Misc.SALT_LAMP.get();
                }
            }
            if ((biome.m_203656_(Tags.Biomes.IS_COLD) || biome.m_203656_(Tags.Biomes.IS_SNOWY)) && (PMDimensions.isDimOverworldLike(world) || PMDimensions.Type.DEEP_DARK.is((ResourceKey<Level>)dim))) {
                if (rand.m_188503_(5) == 0) {
                    blockToPlace = Blocks.f_50568_;
                } else if (rand.m_188499_()) {
                    blockToPlace = Blocks.f_50354_;
                }
                if (PMDimensions.Type.OVERWORLD_CORE.is((ResourceKey<Level>)dim) && rand.m_188503_(5) == 0) {
                    blockToPlace = Misc.GLOWING_ICE.get();
                }
            }
            if (PMDimensions.Type.OVERWORLD_CORE.is((ResourceKey<Level>)dim) && rand.m_188503_(5) == 0) {
                blockToPlace = Blocks.f_50141_;
            }
            if (blockToPlace != null) {
                world.m_7731_(pos, blockToPlace.m_49966_(), 32);
                return true;
            }
        }
        return false;
    }
}

