/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.cave;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.dimension.PMDimensions;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.cave.PMCaveFeatures;
import net.paradisemod.worldgen.features.foliage.PMFoliage;

public class CaveFoliage
extends BasicFeature {
    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        BlockState curState = world.m_8055_(pos);
        BlockState stateBelow = world.m_8055_(pos.m_7495_());
        Holder biome = world.m_204166_(pos);
        ResourceKey dim = world.m_6018_().m_46472_();
        int worldgenLimit = PMCaveFeatures.dimWorldgenLimit(world);
        boolean shouldThin = PMDimensions.Type.ELYSIUM.is((ResourceKey<Level>)dim);
        if ((!shouldThin || shouldThin && rand.m_188503_(3) == 0) && (pos.m_123342_() <= worldgenLimit || !PMCaveFeatures.seesSky(world, pos)) && curState.m_60795_() && (PMCaveFeatures.isValidBlock(stateBelow) || stateBelow.m_204336_(BlockTags.f_144274_) || stateBelow.m_204336_(BlockTags.f_13029_))) {
            ArrayList<Object> trees = new ArrayList<Object>();
            ArrayList<Block> plants = new ArrayList<Block>();
            Block soil = null;
            if (PMBiomes.isRockyDesert((Holder<Biome>)biome)) {
                soil = Blocks.f_50546_;
                plants.add(Blocks.f_50036_);
                plants.add(Blocks.f_50034_);
                plants.add(Blocks.f_50359_);
                if (!PMDimensions.Type.OVERWORLD_CORE.is((ResourceKey<Level>)dim)) {
                    if (!biome.m_203565_(PMBiomes.PALO_VERDE_FOREST)) {
                        trees.add(PMFoliage.MESQUITE_PLACER);
                    }
                    if (biome.m_203656_(PMTags.Biomes.COLD_ROCKY_DESERTS)) {
                        trees.add(TreePlacements.f_195378_);
                    } else if (!biome.m_203565_(PMBiomes.MESQUITE_FOREST)) {
                        trees.add(PMFoliage.PALO_VERDE_PLACER);
                    }
                }
                if (rand.m_188503_(5) == 0) {
                    world.m_7731_(pos.m_7495_(), Blocks.f_49992_.m_49966_(), 32);
                    return CaveFoliage.placeCactus(world, pos, rand, false);
                }
            } else if (biome.m_203656_(Tags.Biomes.IS_MUSHROOM) && !biome.m_203565_(PMBiomes.GLIMMERING_WEALD)) {
                soil = Blocks.f_50195_;
                plants.add(Blocks.f_50073_);
                plants.add(Blocks.f_50072_);
                plants.add(DeepDarkBlocks.GLOWSHROOM.get());
                if (!PMDimensions.Type.OVERWORLD_CORE.is((ResourceKey<Level>)dim)) {
                    trees.add(PMFoliage.BROWN_MUSHROOM);
                    trees.add(PMFoliage.RED_MUSHROOM);
                    trees.add(PMFoliage.HUGE_GLOWSHROOM_PLACER);
                }
            } else if (biome.m_203565_(PMBiomes.DARK_DESERT)) {
                plants.add(Blocks.f_50036_);
                soil = DeepDarkBlocks.BLACKENED_SAND.get();
                if (rand.m_188503_(5) == 0) {
                    world.m_7731_(pos.m_7495_(), soil.m_49966_(), 16);
                    return CaveFoliage.placeCactus(world, pos, rand, true);
                }
            } else if (biome.m_203656_(BiomeTags.f_207607_) || PMBiomes.isSandyDesert((Holder<Biome>)biome)) {
                soil = Blocks.f_49993_;
                if (PMBiomes.isSandyDesert((Holder<Biome>)biome)) {
                    soil = Blocks.f_49992_;
                }
                plants.add(Blocks.f_50036_);
                if (rand.m_188503_(5) == 0) {
                    world.m_7731_(pos.m_7495_(), soil.m_49966_(), 16);
                    return CaveFoliage.placeCactus(world, pos, rand, false);
                }
            } else if (biome.m_203656_(BiomeTags.f_207610_) || biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                soil = Blocks.f_50440_;
                if (biome.m_203656_(BiomeTags.f_207610_)) {
                    if (biome.m_203565_(PMBiomes.TEMPERATE_RAINFOREST) || biome.m_203565_(PMBiomes.UNDERGROUND_TEMPERATE_RAINFOREST)) {
                        trees.add(PMFoliage.TR_OAK);
                        trees.add(PMFoliage.TR_BIRCH);
                        trees.add(TreePlacements.f_195384_);
                    } else {
                        trees.add(TreePlacements.f_195384_);
                        trees.add(TreePlacements.f_195389_);
                        trees.add(PMFoliage.TR_OAK);
                    }
                    plants.add(Blocks.f_50186_);
                    ITag<Block> flowers = Utils.getBlockTag((TagKey<Block>)BlockTags.f_13041_);
                    plants.add((Block)flowers.getRandomElement(rand).get());
                } else if (biome.m_203565_(PMBiomes.UNDERGROUND_MANGROVE_SWAMP) || biome.m_203565_(Biomes.f_220595_)) {
                    soil = Blocks.f_220864_;
                    plants.add(Blocks.f_152543_);
                    plants.add(Blocks.f_50036_);
                    trees.add(TreePlacements.f_236771_);
                } else {
                    trees.add(PMFoliage.TR_OAK);
                }
                plants.add(Blocks.f_50034_);
                plants.add(Blocks.f_50359_);
                plants.add(Blocks.f_50035_);
            } else if (PMDimensions.Type.ELYSIUM.is((ResourceKey<Level>)dim) && stateBelow.m_204336_(BlockTags.f_144274_)) {
                plants.add(Blocks.f_50034_);
                plants.add(Blocks.f_50359_);
            }
            if ((biome.m_203656_(Tags.Biomes.IS_COLD) || biome.m_203656_(Tags.Biomes.IS_SNOWY)) && (PMDimensions.isDimOverworldLike(world) || PMDimensions.Type.DEEP_DARK.is((ResourceKey<Level>)dim)) && rand.m_188499_()) {
                world.m_7731_(pos, Blocks.f_50125_.m_49966_(), 16);
                return true;
            }
            if (!trees.isEmpty() && rand.m_188499_() && soil != null) {
                world.m_7731_(pos.m_7495_(), soil.m_49966_(), 16);
                Block prevBlock = world.m_8055_(pos).m_60734_();
                world.m_7731_(pos, Blocks.f_50627_.m_49966_(), 16);
                boolean placed = this.getPlacedFeature((ResourceKey<PlacedFeature>)((ResourceKey)trees.get(rand.m_188503_(trees.size())))).m_226357_(world, generator, rand, pos);
                if (!placed) {
                    world.m_7731_(pos, prevBlock.m_49966_(), 16);
                }
                return placed;
            }
            if (!plants.isEmpty()) {
                Block plant = (Block)plants.get(rand.m_188503_(plants.size()));
                if (soil != null) {
                    world.m_7731_(pos.m_7495_(), soil.m_49966_(), 16);
                }
                if (stateBelow.m_204336_(BlockTags.f_144274_) || stateBelow.m_204336_(BlockTags.f_13029_) || soil != null) {
                    world.m_7731_(pos, plant.m_49966_(), 16);
                }
                if (plant.m_49966_().m_61138_((Property)BlockStateProperties.f_61401_)) {
                    world.m_7731_(pos.m_7494_(), (BlockState)plant.m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 32);
                }
                return true;
            }
        } else if (biome.m_203656_(Tags.Biomes.IS_SWAMP) && pos.m_123342_() <= worldgenLimit && curState.m_60795_() && world.m_46801_(pos.m_7495_())) {
            world.m_7731_(pos, Blocks.f_50196_.m_49966_(), 16);
        }
        return false;
    }

    private static boolean placeCactus(WorldGenLevel world, BlockPos pos, RandomSource rand, boolean glowing) {
        int height = rand.m_188503_(3);
        for (int i = 0; i <= height; ++i) {
            BlockPos newPos = pos.m_6630_(i);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos adjPos = newPos.m_121945_(dir);
                BlockState adjState = world.m_8055_(adjPos);
                if (adjState.m_60795_() || adjState.m_60713_(Blocks.f_50125_)) continue;
                return false;
            }
            world.m_7731_(newPos, (glowing ? DeepDarkBlocks.GLOWING_CACTUS.get() : Blocks.f_50128_).m_49966_(), 16);
        }
        return true;
    }
}

