/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.cave;

import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.blocks.LargeCaveFormation;
import net.paradisemod.world.blocks.SmallCaveFormation;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.cave.PMCaveFeatures;

public class CaveFormation
extends BasicFeature {
    protected static final HashMap<Block, Block> FORMATIONS = new HashMap();
    protected static final HashMap<Block, Block> LARGE_FORMATIONS = new HashMap();

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        int worldgenLimit = PMCaveFeatures.dimWorldgenLimit(world);
        Optional<Boolean> maybeInverted = this.isInverted(world, pos);
        if (maybeInverted.isPresent() && (!PMCaveFeatures.seesSky(world, pos) || pos.m_123342_() <= worldgenLimit) && (world.m_8055_(pos).m_60795_() || world.m_46801_(pos))) {
            Holder biome = world.m_204166_(pos);
            boolean isLarge = rand.m_188499_();
            Boolean isInverted = maybeInverted.get();
            if (PMCaveFeatures.seesSky(world, pos) && (biome.m_203565_(PMBiomes.GLOWING_GLACIER) || biome.m_203565_(PMBiomes.POLAR_WINTER) || biome.m_203565_(PMBiomes.GLACIER) || biome.m_203565_(PMBiomes.SUBGLACIAL_VOLCANIC_FIELD))) {
                return false;
            }
            if (isLarge) {
                LargeCaveFormation formation = (LargeCaveFormation)PMWorld.LARGE_STONE_FORMATION.get();
                if (biome.m_203656_(PMTags.Biomes.DEEP_DARK)) {
                    formation = (LargeCaveFormation)PMWorld.LARGE_DARKSTONE_FORMATION.get();
                }
                if (PMCaveFeatures.shouldBeMossy(rand, (Holder<Biome>)biome)) {
                    formation = (LargeCaveFormation)PMWorld.LARGE_MOSSY_COBBLESTONE_FORMATION.get();
                } else if (this.shouldBeIcicle(rand, (Holder<Biome>)biome)) {
                    formation = (LargeCaveFormation)(rand.m_188499_() ? PMWorld.LARGE_ICICLE : PMWorld.LARGE_BLUE_ICICLE).get();
                } else if (biome.m_203565_(Biomes.f_48203_) && rand.m_188503_(5) == 0) {
                    formation = (LargeCaveFormation)PMWorld.LARGE_SANDSTONE_FORMATION.get();
                } else if (biome.m_203565_(PMBiomes.DARK_DESERT) && rand.m_188499_()) {
                    formation = (LargeCaveFormation)PMWorld.LARGE_BLACKENED_SANDSTONE_FORMATION.get();
                } else if (biome.m_203656_(BiomeTags.f_207607_) && rand.m_188503_(5) == 0) {
                    formation = (LargeCaveFormation)PMWorld.LARGE_RED_SANDSTONE_FORMATION.get();
                } else {
                    BlockState facingState = world.m_8055_(pos.m_6630_(isInverted != false ? 1 : -1));
                    Block newFormation = LARGE_FORMATIONS.get(facingState.m_60734_());
                    if (newFormation != null) {
                        formation = (LargeCaveFormation)newFormation;
                    }
                }
                formation.place(world, pos, isInverted);
            } else {
                boolean isWater = world.m_46801_(pos);
                Block formation = PMWorld.STONE_FORMATION.get();
                if (biome.m_203656_(PMTags.Biomes.DEEP_DARK)) {
                    formation = PMWorld.DARKSTONE_FORMATION.get();
                }
                if (PMCaveFeatures.shouldBeMossy(rand, (Holder<Biome>)biome)) {
                    formation = PMWorld.MOSSY_COBBLESTONE_FORMATION.get();
                }
                if (this.shouldBeIcicle(rand, (Holder<Biome>)biome)) {
                    formation = (rand.m_188499_() ? PMWorld.ICICLE : PMWorld.BLUE_ICICLE).get();
                } else if (biome.m_203565_(Biomes.f_48203_) && rand.m_188503_(5) == 0) {
                    formation = PMWorld.SANDSTONE_FORMATION.get();
                } else if (biome.m_203565_(PMBiomes.DARK_DESERT) && rand.m_188499_()) {
                    formation = PMWorld.BLACKENED_SANDSTONE_FORMATION.get();
                } else if (biome.m_203656_(BiomeTags.f_207607_) && rand.m_188503_(5) == 0) {
                    formation = PMWorld.RED_SANDSTONE_FORMATION.get();
                } else {
                    BlockState facingState = world.m_8055_(pos.m_6630_(isInverted != false ? 1 : -1));
                    Block newFormation = FORMATIONS.get(facingState.m_60734_());
                    if (newFormation != null) {
                        formation = newFormation;
                    }
                }
                world.m_7731_(pos, (BlockState)((BlockState)formation.m_49966_().m_61124_((Property)SmallCaveFormation.f_52588_, (Comparable)(isInverted != false ? Direction.DOWN : Direction.UP))).m_61124_((Property)SmallCaveFormation.WATERLOGGED, (Comparable)Boolean.valueOf(isWater)), 32);
            }
            return true;
        }
        return false;
    }

    private boolean shouldBeIcicle(RandomSource rand, Holder<Biome> biome) {
        return (biome.m_203656_(Tags.Biomes.IS_COLD) || biome.m_203656_(Tags.Biomes.IS_SNOWY)) && rand.m_188503_(5) == 0 && !biome.m_203656_(BiomeTags.f_215818_);
    }

    private Optional<Boolean> isInverted(WorldGenLevel world, BlockPos pos) {
        if (PMCaveFeatures.isValidBlock(world.m_8055_(pos.m_7494_()))) {
            return Optional.of(true);
        }
        if (PMCaveFeatures.isValidBlock(world.m_8055_(pos.m_7495_()))) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    protected static void initStoneFormations(FMLCommonSetupEvent event) {
        FORMATIONS.put(Blocks.f_50334_, PMWorld.ANDESITE_FORMATION.get());
        FORMATIONS.put(Blocks.f_50137_, PMWorld.BASALT_FORMATION.get());
        FORMATIONS.put(DeepDarkBlocks.DARKSTONE.get(), PMWorld.DARKSTONE_FORMATION.get());
        FORMATIONS.put(Blocks.f_152550_, PMWorld.DEEPSLATE_FORMATION.get());
        FORMATIONS.put(Blocks.f_152496_, PMWorld.TUFF_FORMATION.get());
        FORMATIONS.put(Blocks.f_50228_, PMWorld.DIORITE_FORMATION.get());
        FORMATIONS.put(Blocks.f_50122_, PMWorld.GRANITE_FORMATION.get());
        FORMATIONS.put(Blocks.f_50134_, PMWorld.NETHERRACK_FORMATION.get());
        FORMATIONS.put(Blocks.f_50069_, PMWorld.STONE_FORMATION.get());
        FORMATIONS.put(Blocks.f_50259_, PMWorld.END_STONE_FORMATION.get());
        FORMATIONS.put(Blocks.f_50062_, PMWorld.SANDSTONE_FORMATION.get());
        FORMATIONS.put(Blocks.f_50394_, PMWorld.RED_SANDSTONE_FORMATION.get());
        FORMATIONS.put(DeepDarkBlocks.BLACKENED_SANDSTONE.get(), PMWorld.BLACKENED_SANDSTONE_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_50334_, PMWorld.LARGE_ANDESITE_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_50137_, PMWorld.LARGE_BASALT_FORMATION.get());
        LARGE_FORMATIONS.put(DeepDarkBlocks.DARKSTONE.get(), PMWorld.LARGE_DARKSTONE_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_152550_, PMWorld.LARGE_DEEPSLATE_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_152496_, PMWorld.LARGE_TUFF_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_50228_, PMWorld.LARGE_DIORITE_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_50122_, PMWorld.LARGE_GRANITE_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_50134_, PMWorld.LARGE_NETHERRACK_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_50069_, PMWorld.LARGE_STONE_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_50259_, PMWorld.LARGE_END_STONE_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_50062_, PMWorld.LARGE_SANDSTONE_FORMATION.get());
        LARGE_FORMATIONS.put(Blocks.f_50394_, PMWorld.LARGE_RED_SANDSTONE_FORMATION.get());
        LARGE_FORMATIONS.put(DeepDarkBlocks.BLACKENED_SANDSTONE.get(), PMWorld.LARGE_BLACKENED_SANDSTONE_FORMATION.get());
    }
}

