/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.cave;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.paradisemod.base.Utils;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.cave.PMCaveFeatures;

public class CaveVine
extends BasicFeature {
    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        int worldgenLimit = PMCaveFeatures.dimWorldgenLimit(world);
        if (PMCaveFeatures.isValidBlock(world.m_8055_(pos.m_7494_())) && world.m_8055_(pos).m_60795_() && pos.m_123342_() <= worldgenLimit) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos newPos = pos.m_121945_(dir);
                if (!world.m_8055_(newPos).m_280296_()) continue;
                BlockState vineState = Blocks.f_50191_.m_49966_();
                vineState = switch (dir) {
                    case Direction.NORTH -> (BlockState)vineState.m_61124_((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true));
                    case Direction.SOUTH -> (BlockState)vineState.m_61124_((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true));
                    case Direction.WEST -> (BlockState)vineState.m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true));
                    case Direction.EAST -> (BlockState)vineState.m_61124_((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true));
                    default -> (BlockState)Utils.modErrorTyped("Vines can't face down!");
                };
                world.m_7731_(newPos, (BlockState)vineState.m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)), 32);
                int length = rand.m_188503_(4);
                if (length > 0) {
                    BlockPos extPos;
                    BlockState existingBlock;
                    for (int i = 1; i <= length && (existingBlock = world.m_8055_(extPos = newPos.m_6625_(i))).m_60795_(); ++i) {
                        world.m_7731_(extPos, vineState, 32);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

