/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.cave;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.paradisemod.world.dimension.PMDimensions;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.PMFeatures;
import net.paradisemod.worldgen.features.cave.CaveBlocks;
import net.paradisemod.worldgen.features.cave.CaveFoliage;
import net.paradisemod.worldgen.features.cave.CaveFormation;
import net.paradisemod.worldgen.features.cave.CaveVine;
import net.paradisemod.worldgen.features.placement.InfiniteCountPlacement;

public class PMCaveFeatures {
    public static final ResourceKey<PlacedFeature> CAVE_FORMATIONS = PMCaveFeatures.createScatteredCaveFeature("formations", CaveFormation::new);
    public static final ResourceKey<PlacedFeature> CAVE_BLOCKS = PMCaveFeatures.createScatteredCaveFeature("blocks", CaveBlocks::new);
    public static final ResourceKey<PlacedFeature> CAVE_FOLIAGE = PMCaveFeatures.createScatteredCaveFeature("foliage", CaveFoliage::new);
    public static final ResourceKey<PlacedFeature> CAVE_VINE = PMCaveFeatures.createScatteredCaveFeature("vine", CaveVine::new);

    public static void init(IEventBus eventbus) {
        eventbus.addListener(CaveFormation::initStoneFormations);
    }

    public static int dimWorldgenLimit(WorldGenLevel world) {
        ResourceKey dim = world.m_6018_().m_46472_();
        int worldgenLimit = 62;
        if (dim == Level.f_46429_) {
            worldgenLimit = 127;
        }
        if (PMDimensions.Type.OVERWORLD_CORE.is((ResourceKey<Level>)dim) || PMDimensions.Type.DEEP_DARK.is((ResourceKey<Level>)dim)) {
            worldgenLimit = 319;
        }
        return worldgenLimit;
    }

    protected static boolean shouldBeMossy(RandomSource rand, Holder<Biome> biome) {
        return (biome.m_203656_(Tags.Biomes.IS_SWAMP) || biome.m_203656_(BiomeTags.f_207610_)) && rand.m_188503_(5) == 0;
    }

    protected static boolean isValidBlock(BlockState state) {
        return state.m_204336_(Tags.Blocks.STONE) || state.m_60713_(Blocks.f_50134_) || state.m_60713_(Blocks.f_50137_) || state.m_204336_(Tags.Blocks.COBBLESTONE) || state.m_204336_(Tags.Blocks.SANDSTONE) || state.m_204336_(BlockTags.f_198156_) || CaveFormation.FORMATIONS.containsKey(state.m_60734_()) || CaveFormation.LARGE_FORMATIONS.containsKey(state.m_60734_());
    }

    protected static boolean seesSky(WorldGenLevel world, BlockPos pos) {
        for (int y = pos.m_123342_() + 1; y < 320; ++y) {
            BlockPos newPos = pos.m_175288_(y);
            if (world.m_8055_(newPos).m_60795_()) continue;
            return false;
        }
        return true;
    }

    private static ResourceKey<PlacedFeature> createScatteredCaveFeature(String name, Supplier<? extends BasicFeature> feature) {
        InfiniteCountPlacement count = InfiniteCountPlacement.of(2048);
        if (name == "foliage") {
            count = InfiniteCountPlacement.of(8192);
        }
        return PMFeatures.getBasicFeature("cave/" + name, feature, new PlacementModifier[]{count, InSquarePlacement.m_191715_(), PMFeatures.FULL_HEIGHT_RANGE, InfiniteCountPlacement.of((IntProvider)UniformInt.m_146622_((int)1, (int)5)), RandomOffsetPlacement.m_191879_((IntProvider)ClampedNormalInt.m_185879_((float)0.0f, (float)3.0f, (int)-10, (int)10), (IntProvider)ClampedNormalInt.m_185879_((float)0.0f, (float)0.6f, (int)-2, (int)2)), BiomeFilter.m_191561_()});
    }
}

