/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.chunk;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.chunk.ChunkProcessor;

public class ChunkProcessingFeature
extends BasicFeature {
    private final boolean isVegetal;

    public ChunkProcessingFeature(boolean isVegetal) {
        this.isVegetal = isVegetal;
    }

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        int chunkX = (pos.m_123341_() >> 4) * 16;
        int chunkZ = (pos.m_123343_() >> 4) * 16;
        BlockPos chunkCorner = new BlockPos(chunkX, 0, chunkZ);
        for (int x = 0; x <= 15; ++x) {
            for (int z = 0; z <= 15; ++z) {
                for (int y = world.m_141937_(); y < world.m_151558_(); ++y) {
                    BlockPos newPos = chunkCorner.m_7918_(x, y, z);
                    Holder biome = world.m_204166_(newPos);
                    BlockState curState = world.m_8055_(newPos);
                    for (ChunkProcessor processor : this.isVegetal ? ChunkProcessor.VEGETAL_PROCESSORS : ChunkProcessor.RAW_PROCESSORS) {
                        if (y <= processor.minHeight(world) || y >= processor.maxHeight(world) || !processor.isValidWorld(world)) continue;
                        processor.processBlock(world, rand, newPos, curState, (Holder<Biome>)biome, generator);
                    }
                }
            }
        }
        return true;
    }
}

