/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.chunk;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.paradisemod.world.dimension.PMDimensions;

public abstract class ChunkProcessor {
    protected static final ArrayList<ChunkProcessor> RAW_PROCESSORS = new ArrayList();
    protected static final ArrayList<ChunkProcessor> VEGETAL_PROCESSORS = new ArrayList();

    protected abstract void processBlock(WorldGenLevel var1, RandomSource var2, BlockPos var3, BlockState var4, Holder<Biome> var5, ChunkGenerator var6);

    protected int maxHeight(WorldGenLevel world) {
        return world.m_151558_();
    }

    protected int minHeight(WorldGenLevel world) {
        return world.m_141937_();
    }

    protected boolean isValidWorld(WorldGenLevel world) {
        ResourceKey dim = world.m_6018_().m_46472_();
        return PMDimensions.isDimOverworldLike(world) || PMDimensions.Type.DEEP_DARK.is((ResourceKey<Level>)dim);
    }

    public static void addRawProcessor(ChunkProcessor processor) {
        RAW_PROCESSORS.add(processor);
    }

    public static void addVegetalProcessor(ChunkProcessor processor) {
        VEGETAL_PROCESSORS.add(processor);
    }
}

