/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.foliage;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.blocks.CrystalCluster;
import net.paradisemod.worldgen.features.BasicFeature;

public class FoliagePatch
extends BasicFeature {
    @Nullable
    private final TagKey<Block> tagName;
    private final ArrayList<BlockState> blocks = new ArrayList();

    public FoliagePatch(@Nullable TagKey<Block> tagName) {
        this.tagName = tagName;
    }

    public FoliagePatch(Block ... blocks) {
        this.tagName = null;
        this.blocks.addAll(Arrays.stream(blocks).map(Block::m_49966_).toList());
    }

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        if (this.blocks.isEmpty()) {
            this.blocks.addAll(Utils.getBlockTag(this.tagName).stream().map(Block::m_49966_).toList());
        }
        ResourceKey dim = world.m_6018_().m_46472_();
        DimensionType dimType = world.m_6018_().m_6042_();
        int minY = world.m_6018_().m_6042_().f_156647_();
        int height = dimType.f_156648_();
        String dimName = dim.m_135782_().toString();
        int chunkX = (pos.m_123341_() >> 4) * 16;
        int chunkZ = (pos.m_123343_() >> 4) * 16;
        BlockPos chunkCorner = new BlockPos(chunkX, 63, chunkZ);
        Holder origBiome = world.m_204166_(pos);
        if (dimType.f_63856_() || dimName.contains("paradisemod")) {
            ArrayList<Integer> layers = new ArrayList<Integer>();
            for (int y = 0; y < height; ++y) {
                BlockPos layerPos;
                Holder layerBiome;
                if (y % 10 != 0 || !(layerBiome = world.m_204166_(layerPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_()))).m_203565_((ResourceKey)origBiome.m_203543_().get())) continue;
                layers.add(y);
            }
            if (!layers.isEmpty()) {
                chunkCorner = new BlockPos(chunkX, minY + (Integer)layers.get(rand.m_188503_(layers.size())), chunkZ);
            }
        }
        if (dimName.equals("minecraft:the_end")) {
            chunkCorner = new BlockPos(chunkX, 0, chunkZ);
        }
        BlockState blockToPlace = this.blocks.get(rand.m_188503_(this.blocks.size()));
        BlockPos toPlacePos = chunkCorner.m_7918_(rand.m_188503_(8), 0, rand.m_188503_(8));
        int chance = 5 * this.blocks.size();
        if (this.blocks.get(0).m_60734_() instanceof PumpkinBlock) {
            chance = 10;
        }
        for (int x = 0; x < 8; ++x) {
            block2: for (int z = 0; z < 8; ++z) {
                for (int y = 0; y < 194; ++y) {
                    boolean validBlock;
                    BlockPos newPos = toPlacePos.m_7918_(x, y, z);
                    Holder biome = world.m_204166_(newPos);
                    if (newPos.m_123342_() > height - 10) continue block2;
                    BlockState blockstate = world.m_8055_(newPos);
                    BlockState blockstateAbove = world.m_8055_(newPos.m_7494_());
                    boolean validBottomBlock = !blockstate.m_60713_(DeepDarkBlocks.DARKSTONE.get()) || this.tagName == PMTags.Blocks.CRYSTAL_CLUSTERS;
                    boolean bl = validBlock = blockstateAbove.m_60795_() || blockstateAbove.m_60713_(Blocks.f_50125_);
                    if (!blockstate.m_204336_(BlockTags.f_144274_) && !blockstate.m_60713_(PMWorld.OVERGROWN_END_STONE.get()) || !validBottomBlock || !validBlock || rand.m_188503_(chance) != 0) continue;
                    if (this.tagName == PMTags.Blocks.CRYSTAL_CLUSTERS) {
                        blockToPlace = this.blocks.get(rand.m_188503_(this.blocks.size()));
                        CrystalCluster crystal = (CrystalCluster)blockToPlace.m_60734_();
                        blockToPlace = (BlockState)crystal.m_49966_().m_61124_((Property)CrystalCluster.TYPE, (Comparable)Integer.valueOf(rand.m_188503_(4)));
                    } else if (this.tagName == PMTags.Blocks.BLACKENED_FOLIAGE || this.tagName == PMTags.Blocks.GLOWING_FOLIAGE || this.tagName == PMTags.Blocks.END_FOLIAGE || this.tagName == PMTags.Blocks.LANTERNS) {
                        blockToPlace = this.blocks.get(rand.m_188503_(this.blocks.size()));
                    }
                    if (!biome.m_203565_((ResourceKey)origBiome.m_203543_().get())) continue;
                    world.m_7731_(newPos.m_7494_(), blockToPlace, 32);
                    if (!blockToPlace.m_61138_((Property)BlockStateProperties.f_61401_)) continue;
                    world.m_7731_(newPos.m_6630_(2), (BlockState)blockToPlace.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 32);
                }
            }
        }
        return true;
    }
}

