/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.foliage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.features.BasicFeature;

public class OWCFoliage
extends BasicFeature {
    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        BlockPos featurePos = pos;
        if (world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50125_)) {
            featurePos = pos.m_7495_();
        }
        Holder biome = world.m_204166_(featurePos);
        boolean placeFoliage = true;
        int foliageChance = 3;
        int flowerChance = 10;
        ArrayList<Block> foliage = new ArrayList<Block>(List.of(Blocks.f_50034_, Blocks.f_50359_));
        ArrayList<Block> flowers = new ArrayList(Utils.getBlockTag((TagKey<Block>)BlockTags.f_13041_).stream().toList());
        if (biome.m_203565_(PMBiomes.SNOWY_UNDERGROUND_TAIGA) || biome.m_203565_(PMBiomes.UNDERGROUND_TAIGA) || biome.m_203565_(PMBiomes.UNDERGROUND_TUNDRA) || biome.m_203565_(PMBiomes.FROZEN_UNDERGROUND_OCEAN)) {
            foliage.add(Blocks.f_50035_);
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_FLOWER_FOREST)) {
            flowerChance = 3;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_AUTUMN_FOREST)) {
            foliage.add(Blocks.f_50035_);
            foliage.add(Blocks.f_50133_);
        } else if (biome.m_203656_(Tags.Biomes.IS_SWAMP) || biome.m_203656_(BiomeTags.f_207610_) || PMBiomes.isRockyDesert((Holder<Biome>)biome) || biome.m_203565_(PMBiomes.SALT_CAVE) || biome.m_203656_(PMTags.Biomes.VOLCANIC) || biome.m_203565_(PMBiomes.TERRACOTTA_CAVE) || biome.m_203565_(PMBiomes.UNDERGROUND_DESERT) || biome.m_203656_(Tags.Biomes.IS_MUSHROOM) || biome.m_203656_(BiomeTags.f_207603_) || biome.m_203565_(PMBiomes.HONEY_CAVE) || biome.m_203656_(Tags.Biomes.IS_COLD) || biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            placeFoliage = false;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_CHERRY_FOREST)) {
            foliage.add(Blocks.f_271445_);
        }
        if (biome.m_203565_(PMBiomes.UNDERGROUND_TUNDRA) || biome.m_203565_(PMBiomes.FROZEN_UNDERGROUND_OCEAN)) {
            foliageChance = 10;
        }
        for (Map.Entry<DyeColor, ResourceKey<Biome>> entry : PMBiomes.ROSE_LANDS_BY_COLOR.entrySet()) {
            DyeColor color = entry.getKey();
            ResourceKey<Biome> roseLand = entry.getValue();
            if (!biome.m_203565_(roseLand)) continue;
            flowers = new ArrayList<Block>(this.getRoselandFoliage(color));
            flowerChance = 2;
            foliageChance = 7;
            break;
        }
        BlockState curState = world.m_8055_(featurePos);
        BlockPos posBelow = featurePos.m_7495_();
        BlockState curStateBelow = world.m_8055_(posBelow);
        if (featurePos.m_123342_() < 61) {
            if (rand.m_188503_(5) == 0) {
                if (world.m_6425_(featurePos).m_192917_((Fluid)Fluids.f_76193_) && curStateBelow.m_280296_()) {
                    world.m_7731_(featurePos, Blocks.f_50037_.m_49966_(), 32);
                }
                return true;
            }
            if (rand.m_188503_(5) == 0) {
                for (int iy = featurePos.m_123342_(); iy < featurePos.m_123342_() + rand.m_188503_(10); ++iy) {
                    BlockPos newPos = featurePos.m_175288_(iy);
                    BlockState oldState = world.m_8055_(newPos.m_6630_(2));
                    BlockPos newPosAbove = newPos.m_7494_();
                    if (newPos.m_123342_() >= 60 || oldState.m_60815_() || oldState.m_60795_()) {
                        return true;
                    }
                    world.m_7731_(newPos, Blocks.f_50576_.m_49966_(), 32);
                    world.m_7731_(newPosAbove, Blocks.f_50575_.m_49966_(), 32);
                }
            }
            return true;
        }
        if ((placeFoliage || featurePos.m_123342_() > 62) && OWCFoliage.m_159759_((BlockState)curStateBelow) && !curState.m_280296_()) {
            if (rand.m_188503_(foliageChance) == 0 && placeFoliage) {
                OWCFoliage.placePlant(world, rand, foliage, featurePos);
                return true;
            }
            if (rand.m_188503_(flowerChance) == 0 && placeFoliage) {
                OWCFoliage.placePlant(world, rand, flowers, featurePos);
                return true;
            }
        }
        return false;
    }

    private List<Block> getRoselandFoliage(DyeColor color) {
        ArrayList<Block> plants = new ArrayList<Block>();
        plants.add(Decoration.ROSES.get(color).get());
        switch (color) {
            case WHITE: {
                plants.add(Blocks.f_50071_);
                break;
            }
            case ORANGE: {
                plants.add(Blocks.f_50117_);
                break;
            }
            case MAGENTA: {
                plants.add(Blocks.f_50114_);
                break;
            }
            case LIGHT_BLUE: {
                plants.add(Blocks.f_50113_);
                break;
            }
            case YELLOW: {
                plants.add(Blocks.f_50111_);
                break;
            }
            case PINK: {
                plants.add(Blocks.f_50119_);
                break;
            }
            case BLACK: {
                plants.add(Blocks.f_50070_);
                break;
            }
            case BLUE: {
                plants.add(Blocks.f_50121_);
                break;
            }
            case LIGHT_GRAY: {
                plants.addAll(List.of(Blocks.f_50115_, Blocks.f_50120_, Blocks.f_50118_));
                break;
            }
            case RED: {
                plants.addAll(List.of(Blocks.f_50112_, Blocks.f_50116_));
            }
        }
        return plants;
    }

    private static void placePlant(WorldGenLevel world, RandomSource rand, List<Block> plants, BlockPos plantPos) {
        BlockState plant = plants.get(rand.m_188503_(plants.size())).m_49966_();
        if (!plant.m_60713_(Blocks.f_50070_)) {
            world.m_7731_(plantPos, plant, 32);
            if (plant.m_61138_((Property)BlockStateProperties.f_61401_)) {
                world.m_7731_(plantPos.m_7494_(), (BlockState)plant.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 32);
            }
            world.m_7731_(plantPos.m_7495_(), Blocks.f_50440_.m_49966_(), 32);
        }
    }
}

