/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.foliage;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.foliage.PMFoliage;

public class OWCTrees
extends BasicFeature {
    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        BlockState testState;
        BlockPos featurePos = pos;
        if (world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50125_)) {
            featurePos = pos.m_7495_();
        }
        if (!(testState = world.m_8055_(featurePos)).m_60795_() && !testState.m_60713_(Blocks.f_50125_)) {
            return false;
        }
        Holder biome = world.m_204166_(featurePos);
        Object tree = null;
        int treeSpacing = 10;
        if (biome.m_203565_(PMBiomes.UNDERGROUND_JUNGLE)) {
            tree = TreePlacements.f_195389_;
            if (rand.m_188499_()) {
                tree = TreePlacements.f_195384_;
            } else if (rand.m_188499_()) {
                tree = TreePlacements.f_195386_;
            }
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_BIRCH_FOREST)) {
            treeSpacing = 20;
            tree = TreePlacements.f_195376_;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_DARK_FOREST)) {
            treeSpacing = 15;
            tree = rand.m_188503_(5) == 0 ? (rand.m_188499_() ? TreePlacements.f_195376_ : TreePlacements.f_195374_) : TreePlacements.f_195375_;
        } else if (biome.m_203565_(PMBiomes.SNOWY_UNDERGROUND_TAIGA) || biome.m_203565_(PMBiomes.UNDERGROUND_TAIGA)) {
            if (biome.m_203565_(PMBiomes.SNOWY_UNDERGROUND_TAIGA)) {
                treeSpacing = 15;
            }
            tree = TreePlacements.f_195378_;
            if (rand.m_188499_()) {
                tree = TreePlacements.f_195387_;
            } else if (rand.m_188499_()) {
                tree = TreePlacements.f_195388_;
            }
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_SAVANNA)) {
            treeSpacing = 40;
            tree = TreePlacements.f_195377_;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_FOREST) || biome.m_203565_(PMBiomes.UNDERGROUND_FLOWER_FOREST)) {
            treeSpacing = 20;
            tree = rand.m_188499_() ? TreePlacements.f_195376_ : TreePlacements.f_195374_;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_ROCKY_DESERT)) {
            treeSpacing = 25;
            tree = rand.m_188499_() ? PMFoliage.MESQUITE_PLACER : PMFoliage.PALO_VERDE_PLACER;
        } else if (biome.m_203656_(PMTags.Biomes.COLD_ROCKY_DESERTS)) {
            treeSpacing = 25;
            tree = rand.m_188499_() ? TreePlacements.f_195378_ : (rand.m_188499_() ? TreePlacements.f_195387_ : (rand.m_188499_() ? TreePlacements.f_195388_ : PMFoliage.MESQUITE_PLACER));
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_PALO_VERDE_FOREST)) {
            treeSpacing = 25;
            tree = PMFoliage.PALO_VERDE_PLACER;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_MESQUITE_FOREST)) {
            treeSpacing = 25;
            tree = PMFoliage.MESQUITE_PLACER;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_CHERRY_FOREST)) {
            treeSpacing = 25;
            tree = TreePlacements.f_271402_;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_AUTUMN_FOREST)) {
            List<ResourceKey<PlacedFeature>> trees = PMFoliage.allAutumnTrees();
            tree = trees.get(rand.m_188503_(trees.size()));
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_SWAMP)) {
            tree = PMFoliage.TR_OAK;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_MANGROVE_SWAMP)) {
            tree = rand.m_188499_() ? TreePlacements.f_236771_ : TreePlacements.f_236772_;
        } else if (biome.m_203565_(PMBiomes.UNDERGROUND_TEMPERATE_RAINFOREST)) {
            switch (rand.m_188503_(4)) {
                case 0: {
                    tree = PMFoliage.TR_BIRCH;
                    break;
                }
                case 1: {
                    tree = PMFoliage.TR_OAK;
                    break;
                }
                case 2: {
                    tree = rand.m_188499_() ? TreePlacements.f_195378_ : TreePlacements.f_195387_;
                    break;
                }
                case 3: {
                    ResourceKey resourceKey = tree = rand.m_188499_() ? TreePlacements.f_195384_ : TreePlacements.f_195386_;
                }
            }
        }
        if (biome.m_203656_(BiomeTags.f_207611_) && !biome.m_203565_(PMBiomes.UNDERGROUND_AUTUMN_FOREST) && rand.m_188503_(5) == 0) {
            tree = PMFoliage.RED_MUSHROOM;
            if (rand.m_188499_()) {
                tree = PMFoliage.BROWN_MUSHROOM;
            } else if (rand.m_188499_()) {
                tree = PMFoliage.HUGE_GLOWSHROOM_PLACER;
            }
        }
        if (tree == null) {
            return false;
        }
        if (rand.m_188503_(treeSpacing) == 0) {
            world.m_7731_(featurePos, Blocks.f_50016_.m_49966_(), 32);
            world.m_7731_(featurePos.m_7494_(), Blocks.f_50016_.m_49966_(), 32);
            world.m_7731_(featurePos.m_6630_(2), Blocks.f_50016_.m_49966_(), 32);
            PlacedFeature treeToPlace = this.getPlacedFeature((ResourceKey<PlacedFeature>)tree);
            treeToPlace.m_226357_(world, generator, rand, featurePos);
            return true;
        }
        return false;
    }
}

