/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.foliage;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.ThreeLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.DarkOakFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.DarkOakTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.bonus.Bonus;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.trees.AutumnTree;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.PMFeatures;
import net.paradisemod.worldgen.features.foliage.Cactus;
import net.paradisemod.worldgen.features.foliage.FoliagePatch;
import net.paradisemod.worldgen.features.foliage.OWCFoliage;
import net.paradisemod.worldgen.features.foliage.OWCTrees;
import net.paradisemod.worldgen.features.foliage.PMChorusPlant;
import net.paradisemod.worldgen.features.foliage.PricklyPearGen;
import net.paradisemod.worldgen.features.placement.InfiniteCountPlacement;

public class PMFoliage {
    public static final ArrayListMultimap<AutumnTree.Color, ResourceKey<PlacedFeature>> AUTUMN_TREES = PMFoliage.createAutumnTrees();
    public static final EnumMap<AutumnTree.Color, ResourceKey<ConfiguredFeature<?, ?>>> AUTUMN_SAPLING_TREES = PMFoliage.createAutumnSaplingTrees(false);
    public static final EnumMap<AutumnTree.Color, ResourceKey<ConfiguredFeature<?, ?>>> AUTUMN_SAPLING_TREES_BEES = PMFoliage.createAutumnSaplingTrees(true);
    public static final ResourceKey<ConfiguredFeature<?, ?>> AUTUMN_TREE = PMFeatures.regConfFeature("tree/autumn", Feature.f_65754_, (cfgFeatureGetter, featureGetter) -> {
        List<ResourceKey<PlacedFeature>> trees = PMFoliage.allAutumnTrees();
        List<WeightedPlacedFeature> tree = trees.stream().map(treeKey -> new WeightedPlacedFeature((Holder)featureGetter.m_255043_(treeKey), 1.0f / (float)trees.size())).toList();
        return new RandomFeatureConfiguration(tree, (Holder)featureGetter.m_255043_((ResourceKey)AUTUMN_TREES.get((Object)AutumnTree.Color.BLUE).get(0)));
    });
    public static final ResourceKey<PlacedFeature> AUTUMN_PLACER = PMFeatures.regPlacedFeature("tree/autumn", AUTUMN_TREE, (PlacementModifier[])VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1)).toArray(PlacementModifier[]::new));
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACKENED_OAK_TREE = PMFeatures.regConfFeature("tree/blackened_oak", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)DeepDarkBlocks.BLACKENED_OAK_LOG.get()), (TrunkPlacer)new DarkOakTrunkPlacer(6, 2, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)DeepDarkBlocks.BLACKENED_OAK_LEAVES.get()), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new ThreeLayersFeatureSize(1, 1, 0, 1, 2, OptionalInt.empty())).m_68244_().m_68251_());
    public static final ResourceKey<PlacedFeature> BLACKENED_OAK_PLACER = PMFeatures.regPlacedFeature("tree/blackened_oak", BLACKENED_OAK_TREE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACKENED_SPRUCE_TREE = PMFeatures.regConfFeature("tree/blackened_spruce", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)DeepDarkBlocks.BLACKENED_SPRUCE_LOG.get()), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)DeepDarkBlocks.BLACKENED_SPRUCE_LEAVES.get()), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)UniformInt.m_146622_((int)2, (int)3), (IntProvider)UniformInt.m_146622_((int)0, (int)2), (IntProvider)UniformInt.m_146622_((int)1, (int)2)), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68244_().m_68251_());
    public static final ResourceKey<PlacedFeature> BLACKENED_SPRUCE_PLACER = PMFeatures.regPlacedFeature("tree/blackened_spruce", BLACKENED_SPRUCE_TREE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWING_OAK_TREE = PMFeatures.regConfFeature("tree/glowing_oak", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)DeepDarkBlocks.GLOWING_OAK_LOG.get()), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)DeepDarkBlocks.GLOWING_OAK_LEAVES.get()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68251_());
    public static final ResourceKey<ConfiguredFeature<?, ?>> FANCY_GLOWING_OAK_TREE = PMFeatures.regConfFeature("tree/fancy_glowing_oak", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)DeepDarkBlocks.GLOWING_OAK_LOG.get()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)DeepDarkBlocks.GLOWING_OAK_LEAVES.get()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68251_());
    public static final ResourceKey<PlacedFeature> GLOWING_OAK_PLACER = PMFeatures.regPlacedFeature("tree/glowing_oak", GLOWING_OAK_TREE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<PlacedFeature> FANCY_GLOWING_OAK_PLACER = PMFeatures.regPlacedFeature("tree/fancy_glowing_oak", FANCY_GLOWING_OAK_TREE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<ConfiguredFeature<?, ?>> MESQUITE_TREE = PMFeatures.regConfFeature("tree/mequite", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Decoration.MESQUITE_LOG.get()), (TrunkPlacer)new ForkingTrunkPlacer(3, 1, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Decoration.MESQUITE_LEAVES.get()), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)1), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68251_());
    public static final ResourceKey<PlacedFeature> MESQUITE_PLACER = PMFeatures.regPlacedFeature("tree/mesquite", MESQUITE_TREE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALO_VERDE_TREE = PMFeatures.regConfFeature("tree/palo_verde", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> PMFoliage.paloVerdeConfig(false));
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALO_VERDE_TREE_BEES = PMFeatures.regConfFeature("tree/palo_verde_bees", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> PMFoliage.paloVerdeConfig(true));
    public static final ResourceKey<PlacedFeature> PALO_VERDE_PLACER = PMFeatures.regPlacedFeature("tree/palo_verde_tree", PALO_VERDE_TREE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<ConfiguredFeature<?, ?>> XMAS_TREE = PMFeatures.regConfFeature("tree/christmas", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50000_), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Bonus.CHRISTMAS_LEAVES.get()), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)UniformInt.m_146622_((int)2, (int)3), (IntProvider)UniformInt.m_146622_((int)0, (int)2), (IntProvider)UniformInt.m_146622_((int)1, (int)2)), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68251_());
    public static final ResourceKey<PlacedFeature> XMAS_PLACER = PMFeatures.regPlacedFeature("tree/christmas", XMAS_TREE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<PlacedFeature> RED_MUSHROOM = PMFeatures.regPlacedFeature("red_mushroom", TreeFeatures.f_195122_, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<PlacedFeature> BROWN_MUSHROOM = PMFeatures.regPlacedFeature("brown_mushroom", TreeFeatures.f_195121_, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_GLOWSHROOM = PMFeatures.regConfFeature("huge_glowshroom", Feature.f_65771_, (cfgFeatureGetter, featureGetter) -> new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)DeepDarkBlocks.GLOWSHROOM_BLOCK.get().m_49966_().m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)))), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((BlockState)DeepDarkBlocks.GLOWSHROOM_STEM.get().m_49966_().m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)))), 2));
    public static final ResourceKey<PlacedFeature> HUGE_GLOWSHROOM_PLACER = PMFeatures.regPlacedFeature("huge_glowshroom", HUGE_GLOWSHROOM, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<PlacedFeature> TR_BIRCH = PMFeatures.regPlacedFeature("tree/tr_birch", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> PMFoliage.tempRainforestTree(Blocks.f_50001_, Blocks.f_50052_, false), new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<PlacedFeature> TR_BIRCH_BEES = PMFeatures.regPlacedFeature("tree/tr_birch_bees", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> PMFoliage.tempRainforestTree(Blocks.f_50001_, Blocks.f_50052_, true), new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<PlacedFeature> TR_OAK = PMFeatures.regPlacedFeature("tree/tr_oak", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> PMFoliage.tempRainforestTree(Blocks.f_49999_, Blocks.f_50050_, false), new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<PlacedFeature> TR_OAK_BEES = PMFeatures.regPlacedFeature("tree/tr_oak_bees", Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> PMFoliage.tempRainforestTree(Blocks.f_49999_, Blocks.f_50050_, true), new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    public static final ResourceKey<PlacedFeature> TEMP_RAINFOREST_TREES = PMFeatures.getBigFoliagePlacer("tree/temp_rainforest_trees", false, false, List.of(TR_BIRCH, TR_BIRCH_BEES, TR_OAK, TR_OAK_BEES, TreePlacements.f_195384_, TreePlacements.f_195378_, TreePlacements.f_195386_, TreePlacements.f_195387_, TreePlacements.f_195388_), new ResourceKey[0]);
    public static final ResourceKey<PlacedFeature> GALLERY_FOREST = PMFeatures.getBigFoliagePlacer("gallery_forest", false, false, List.of(TreePlacements.f_195392_, TreePlacements.f_195395_, TreePlacements.f_195384_), new ResourceKey[0]);
    public static final ResourceKey<PlacedFeature> WEEPING_FOREST_TREES = PMFeatures.getBigFoliagePlacer("weeping_forest_trees", false, false, List.of(TreePlacements.f_195378_, TreePlacements.f_195387_, TreePlacements.f_195388_, TreePlacements.f_195393_, TreePlacements.f_195374_, TreePlacements.f_195371_, TreePlacements.f_195385_), new ResourceKey[0]);
    public static final ResourceKey<PlacedFeature> EXTRA_PALO_VERDE = PMFeatures.getBigFoliagePlacer("extra_palo_verde", false, false, List.of(PALO_VERDE_PLACER), new ResourceKey[0]);
    public static final ResourceKey<PlacedFeature> EXTRA_MESQUITE = PMFeatures.getBigFoliagePlacer("extra_mesquite", false, false, List.of(MESQUITE_PLACER), new ResourceKey[0]);
    public static final ResourceKey<PlacedFeature> DESERT_TREES = PMFeatures.getBigFoliagePlacer("desert_trees", true, false, List.of(MESQUITE_PLACER, PALO_VERDE_PLACER), new ResourceKey[0]);
    public static final ResourceKey<PlacedFeature> COLD_DESERT_TREES = PMFeatures.getBigFoliagePlacer("cold_desert_trees", true, false, List.of(MESQUITE_PLACER, TreePlacements.f_195378_, TreePlacements.f_195387_, TreePlacements.f_195388_), new ResourceKey[0]);
    public static final ResourceKey<PlacedFeature> ORIGIN_TREES = PMFeatures.getBigFoliagePlacer("origin_trees", false, false, List.of(TreePlacements.f_195374_), new ResourceKey[0]);
    public static final ResourceKey<PlacedFeature> GLOWING_FOLIAGE = PMFeatures.getBasicFeature("glowing_foliage", () -> new FoliagePatch(PMTags.Blocks.GLOWING_FOLIAGE), new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)24), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> BLACKENED_FOLIAGE = PMFeatures.getBasicFeature("blackened_foliage", () -> new FoliagePatch(PMTags.Blocks.BLACKENED_FOLIAGE), new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)24), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> LARGE_GLOWING_FOLIAGE = PMFeatures.getBigFoliagePlacer("large_glowing_foliage", false, true, List.of(GLOWING_OAK_PLACER, FANCY_GLOWING_OAK_PLACER), List.of(BLACKENED_OAK_PLACER), List.of(HUGE_GLOWSHROOM, TreeFeatures.f_195122_, TreeFeatures.f_195121_));
    public static final ResourceKey<PlacedFeature> BLACKENED_SPRUCE_COVER = PMFeatures.getBigFoliagePlacer("blackened_spruce_cover", false, true, List.of(BLACKENED_SPRUCE_PLACER), new ResourceKey[0]);
    public static final ResourceKey<PlacedFeature> LARGE_BLACKENED_FOLIAGE = PMFeatures.getBigFoliagePlacer("large_blackened_foliage", false, true, List.of(BLACKENED_OAK_PLACER, BLACKENED_OAK_PLACER), List.of(GLOWING_OAK_PLACER, FANCY_GLOWING_OAK_PLACER), List.of(HUGE_GLOWSHROOM, TreeFeatures.f_195122_, TreeFeatures.f_195121_));
    public static final ResourceKey<PlacedFeature> OWC_TREES = PMFeatures.getBasicFeature("owc_trees", OWCTrees::new, new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)128)});
    public static final ResourceKey<PlacedFeature> OWC_FOLIAGE = PMFeatures.getBasicFeature("owc_foliage", OWCFoliage::new, new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)128)});
    public static final ResourceKey<PlacedFeature> OWC_SHROOMS = PMFeatures.getBigFoliagePlacer("owc_shrooms", true, true, List.of(), HUGE_GLOWSHROOM, TreeFeatures.f_195121_, TreeFeatures.f_195122_);
    public static final ResourceKey<PlacedFeature> CHRISTMAS_LANTERNS = PMFoliage.countedFoliageFeature("christmas_lanterns", () -> new FoliagePatch(PMTags.Blocks.LANTERNS), 10);
    public static final ResourceKey<PlacedFeature> CHRISTMAS_CRYSTALS = PMFoliage.countedFoliageFeature("christmas_crystals", () -> new FoliagePatch(PMTags.Blocks.CRYSTAL_CLUSTERS), 10);
    public static final ResourceKey<PlacedFeature> ROSES = PMFoliage.rarityFoliageFeature("roses", () -> new FoliagePatch(PMTags.Blocks.ROSES), 10);
    public static final ResourceKey<PlacedFeature> PRICKLY_PEAR = PMFoliage.rarityFoliageFeature("prickly_pear", PricklyPearGen::new, 15);
    public static final ResourceKey<PlacedFeature> RD_CACTUS = PMFoliage.countedFoliageFeature("rd_cactus", Cactus::new, 192);
    public static final ResourceKey<PlacedFeature> END_FOLIAGE = PMFoliage.countedFoliageFeature("end_foliage", () -> new FoliagePatch(PMTags.Blocks.END_FOLIAGE), 10);
    public static final ResourceKey<PlacedFeature> RD_FOLIAGE = PMFoliage.countedFoliageFeature("rd_foliage", () -> new FoliagePatch(Blocks.f_50034_, Blocks.f_50359_), 10);
    public static final ResourceKey<PlacedFeature> AUTUMN_PUMPKINS = PMFoliage.countedFoliageFeature("autumn_pumpkins", () -> new FoliagePatch(Blocks.f_50133_), 5);
    public static final ResourceKey<PlacedFeature> SOUL_PUMPKIN_PATCH = PMFeatures.getBasicFeature("soul_pumpkin_patch", () -> new FoliagePatch(Decoration.SOUL_PUMPKIN.get()), new PlacementModifier[]{InSquarePlacement.m_191715_(), RarityFilter.m_191900_((int)10), BiomeFilter.m_191561_()});
    public static final ResourceKey<PlacedFeature> PM_CHORUS_PLANT = PMFeatures.getBasicFeature("pm_chorus_plant", PMChorusPlant::new, new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)0, (int)4)), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});

    public static void init() {
    }

    private static ResourceKey<PlacedFeature> countedFoliageFeature(String name, Supplier<? extends BasicFeature> feature, int count) {
        return PMFeatures.getBasicFeature(name, feature, new PlacementModifier[]{PlacementUtils.f_195354_, InSquarePlacement.m_191715_(), InfiniteCountPlacement.of(count), BiomeFilter.m_191561_()});
    }

    private static ResourceKey<PlacedFeature> rarityFoliageFeature(String name, Supplier<? extends BasicFeature> feature, int rarity) {
        return PMFeatures.getBasicFeature(name, feature, new PlacementModifier[]{PlacementUtils.f_195354_, InSquarePlacement.m_191715_(), RarityFilter.m_191900_((int)rarity), BiomeFilter.m_191561_()});
    }

    private static TreeConfiguration tempRainforestTree(Block wood, Block leaves, boolean bees) {
        TreeConfiguration.TreeConfigurationBuilder builder = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)wood), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
        ArrayList<TrunkVineDecorator> decorators = new ArrayList<TrunkVineDecorator>(List.of(new LeaveVineDecorator(0.25f), TrunkVineDecorator.f_70056_));
        if (bees) {
            decorators.add((TrunkVineDecorator)new BeehiveDecorator(0.5f));
        }
        builder.m_68249_(decorators);
        return builder.m_68251_();
    }

    private static TreeConfiguration paloVerdeConfig(boolean bees) {
        TreeConfiguration.TreeConfigurationBuilder builder = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Decoration.PALO_VERDE_LOG.get()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Decoration.PALO_VERDE_LEAVES.get()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_();
        if (bees) {
            builder = builder.m_68249_(List.of(new BeehiveDecorator(0.5f)));
        }
        return builder.m_68251_();
    }

    public static List<ResourceKey<PlacedFeature>> allAutumnTrees() {
        ArrayList<ResourceKey<PlacedFeature>> trees = new ArrayList<ResourceKey<PlacedFeature>>();
        for (AutumnTree.Color color : AutumnTree.Color.values()) {
            trees.addAll(AUTUMN_TREES.get((Object)color));
        }
        return trees;
    }

    private static ArrayListMultimap<AutumnTree.Color, ResourceKey<PlacedFeature>> createAutumnTrees() {
        ArrayListMultimap trees = ArrayListMultimap.create();
        for (AutumnTree.Color color : AutumnTree.Color.values()) {
            for (AutumnTree.WoodType woodType : AutumnTree.WoodType.values()) {
                trees.put((Object)color, PMFoliage.createAutumnTree(woodType, color, false, false));
                trees.put((Object)color, PMFoliage.createAutumnTree(woodType, color, false, true));
                trees.put((Object)color, PMFoliage.createAutumnTree(woodType, color, true, false));
                trees.put((Object)color, PMFoliage.createAutumnTree(woodType, color, true, true));
            }
        }
        return trees;
    }

    private static EnumMap<AutumnTree.Color, ResourceKey<ConfiguredFeature<?, ?>>> createAutumnSaplingTrees(boolean bees) {
        EnumMap trees = new EnumMap(AutumnTree.Color.class);
        for (AutumnTree.Color color : AutumnTree.Color.values()) {
            trees.put(color, PMFoliage.createAutumnSaplingTree(color, bees));
        }
        return trees;
    }

    private static ResourceKey<PlacedFeature> createAutumnTree(AutumnTree.WoodType type, AutumnTree.Color color, boolean fancy, boolean bees) {
        String name = color.name().toLowerCase() + "_autumn_";
        if (fancy) {
            name = "fancy_" + name;
        }
        name = name + type.name().toLowerCase();
        if (bees) {
            name = name + "_bees";
        }
        return PMFeatures.regPlacedFeature("tree/" + name, Feature.f_65760_, (cfgFeatureGetter, featureGetter) -> PMFoliage.autumnTreeConfig(type, color, fancy, bees), new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createAutumnSaplingTree(AutumnTree.Color color, boolean bees) {
        String name = "tree/" + color.name().toLowerCase() + "_autumn";
        List trees = AUTUMN_TREES.get((Object)color);
        if (bees) {
            name = name + "_bees";
        }
        return PMFeatures.regConfFeature(name, Feature.f_65754_, (cfgFeatureGetter, featureGetter) -> new RandomFeatureConfiguration(trees.stream().map(tree -> new WeightedPlacedFeature((Holder)featureGetter.m_255043_(tree), 0.2f)).toList(), (Holder)featureGetter.m_255043_((ResourceKey)trees.get(0))));
    }

    private static TreeConfiguration autumnTreeConfig(AutumnTree.WoodType type, AutumnTree.Color color, boolean bees, boolean fancy) {
        TreeConfiguration.TreeConfigurationBuilder builder = fancy ? new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)type.getWood()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)color.getLeaves()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))) : new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)type.getWood()), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)color.getLeaves()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
        if (bees) {
            builder.m_68249_(List.of(new BeehiveDecorator(0.5f)));
        }
        return builder.m_68244_().m_68251_();
    }
}

