/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.features.foliage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.decoration.blocks.PricklyPear;
import net.paradisemod.worldgen.features.BasicFeature;

public class PricklyPearGen
extends BasicFeature {
    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        return PricklyPearGen.placeCactus(world, rand, pos);
    }

    protected static boolean placeCactus(WorldGenLevel world, RandomSource rand, BlockPos pos) {
        int heightY = world.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
        BlockPos blockpos = new BlockPos(pos.m_123341_(), heightY, pos.m_123343_());
        Direction.Axis[] axes = new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z};
        if (!world.m_8055_(blockpos.m_7495_()).m_204336_(PMTags.Blocks.GROUND_BLOCKS)) {
            return true;
        }
        world.m_7731_(blockpos, (BlockState)((BlockState)Decoration.PRICKLY_PEAR.get().m_49966_().m_61124_(PricklyPear.AXIS, (Comparable)axes[rand.m_188503_(2)])).m_61124_((Property)PricklyPear.HAS_FRUIT, (Comparable)Boolean.valueOf(rand.m_188499_())), 4);
        for (int i = 0; i < 5; ++i) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = 0; y <= 1; ++y) {
                        BlockState state = world.m_8055_(blockpos.m_7918_(x, y, z));
                        if (!(state.m_60734_() instanceof PricklyPear)) continue;
                        PricklyPearGen.genPlant(state, world, blockpos.m_7918_(x, y, z), rand);
                    }
                }
            }
        }
        return true;
    }

    private static void genPlant(BlockState state, WorldGenLevel world, BlockPos pos, RandomSource rand) {
        BlockPos newpos;
        BlockPos[] spreadTo = new BlockPos[]{pos.m_7494_().m_122029_(), pos.m_7494_().m_122024_(), pos.m_7494_()};
        if (state.m_61143_(PricklyPear.AXIS) == Direction.Axis.Z) {
            spreadTo[0] = pos.m_7494_().m_122012_();
            spreadTo[1] = pos.m_7494_().m_122019_();
        }
        if (world.m_8055_(newpos = spreadTo[rand.m_188503_(3)]).m_60734_() != Blocks.f_50016_) {
            return;
        }
        if (world.m_8055_(newpos).m_60734_() instanceof PricklyPear) {
            return;
        }
        BlockState newState = PricklyPearGen.updateState(world, newpos, state);
        world.m_7731_(newpos, (BlockState)newState.m_61124_((Property)PricklyPear.HAS_FRUIT, (Comparable)Boolean.valueOf(rand.m_188499_())), 1);
    }

    private static BlockState updateState(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world.m_8055_(pos.m_122029_()).m_60713_(Decoration.PRICKLY_PEAR.get()) && world.m_8055_(pos.m_122024_()).m_60713_(Decoration.PRICKLY_PEAR.get()) || world.m_8055_(pos.m_122012_()).m_60713_(Decoration.PRICKLY_PEAR.get()) && world.m_8055_(pos.m_122019_()).m_60713_(Decoration.PRICKLY_PEAR.get())) {
            return (BlockState)state.m_61124_(PricklyPear.TILT_DIR, (Comparable)((Object)PricklyPear.TiltDir.NONE));
        }
        if (world.m_8055_(pos.m_7495_().m_122029_()).m_60713_(Decoration.PRICKLY_PEAR.get())) {
            return (BlockState)state.m_61124_(PricklyPear.TILT_DIR, (Comparable)((Object)PricklyPear.TiltDir.WEST));
        }
        if (world.m_8055_(pos.m_7495_().m_122024_()).m_60713_(Decoration.PRICKLY_PEAR.get())) {
            return (BlockState)state.m_61124_(PricklyPear.TILT_DIR, (Comparable)((Object)PricklyPear.TiltDir.EAST));
        }
        if (world.m_8055_(pos.m_7495_().m_122012_()).m_60713_(Decoration.PRICKLY_PEAR.get())) {
            return (BlockState)state.m_61124_(PricklyPear.TILT_DIR, (Comparable)((Object)PricklyPear.TiltDir.SOUTH));
        }
        if (world.m_8055_(pos.m_7495_().m_122019_()).m_60713_(Decoration.PRICKLY_PEAR.get())) {
            return (BlockState)state.m_61124_(PricklyPear.TILT_DIR, (Comparable)((Object)PricklyPear.TiltDir.NORTH));
        }
        return state;
    }
}

