/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.structures.PMStructures;

public class BigStructure
extends Structure {
    public static final HashMap<String, ForgeConfigSpec.BooleanValue> CONFIG_KEYS = new HashMap();
    public static final Codec<BigStructure> CODEC;
    private final String startPoolName;
    private final String configKey;
    private final int size;
    private final PMStructures.StructureGenType genType;

    public BigStructure(Structure.StructureSettings config, String startPoolName, String configKey, int size, PMStructures.StructureGenType genType) {
        super(config);
        this.startPoolName = startPoolName;
        this.size = size;
        this.configKey = configKey;
        this.genType = genType;
    }

    public BigStructure(Structure.StructureSettings config, String startPoolName, String configKey, int size, String genTypeStr) {
        this(config, startPoolName, configKey, size, PMStructures.StructureGenType.valueOf(genTypeStr.toUpperCase()));
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Boolean shouldGenerate = (Boolean)CONFIG_KEYS.get(this.configKey).get();
        if (shouldGenerate.booleanValue()) {
            ResourceKey key;
            RegistryAccess regAccess;
            Registry structPoolRegistry;
            Optional startPool;
            ChunkGenerator chunkGenerator = context.f_226622_();
            WorldgenRandom worldgenRand = context.f_226626_();
            RandomSource rand = worldgenRand.m_213769_();
            int heightVariation = switch (this.genType) {
                case PMStructures.StructureGenType.UNDERGROUND -> rand.m_188503_(60);
                case PMStructures.StructureGenType.SKY -> rand.m_188503_(20);
                default -> 0;
            };
            int startY = this.genType.startHeight() + heightVariation;
            ChunkPos chunkpos = context.f_226628_();
            BlockPos structPos = new BlockPos(chunkpos.m_45604_(), startY, chunkpos.m_45605_());
            Optional<Heightmap.Types> heightMap = Optional.empty();
            if (this.genType.isGround()) {
                heightMap = Optional.of(Heightmap.Types.WORLD_SURFACE_WG);
                Holder biome = chunkGenerator.m_62218_().m_203407_(QuartPos.m_175400_((int)structPos.m_123341_()), QuartPos.m_175400_((int)structPos.m_123342_()), QuartPos.m_175400_((int)structPos.m_123343_()), context.f_226624_().m_224579_());
                if (this.genType == PMStructures.StructureGenType.GROUND && biome.m_203656_(Tags.Biomes.IS_WATER) || this.genType == PMStructures.StructureGenType.UNDERWATER) {
                    heightMap = Optional.of(Heightmap.Types.OCEAN_FLOOR_WG);
                } else if (this.genType == PMStructures.StructureGenType.DRY_GROUND && (biome.m_203656_(Tags.Biomes.IS_WATER) || biome.m_203565_(PMBiomes.GLACIER) || biome.m_203565_(PMBiomes.SUBGLACIAL_VOLCANIC_FIELD))) {
                    return Optional.empty();
                }
            }
            if ((startPool = (structPoolRegistry = (regAccess = context.f_226621_()).m_175515_(Registries.f_256948_)).m_203636_(key = PMRegistries.createResourceKey(Registries.f_256948_, this.startPoolName))).isPresent()) {
                return this.addPieces(context, (Holder<StructureTemplatePool>)((Holder)startPool.get()), structPos, heightMap);
            }
            ParadiseMod.LOG.error("Structure pool element \"" + this.startPoolName + "\" doesn't seem to exist!");
        }
        return Optional.empty();
    }

    private Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, BlockPos structPos, Optional<Heightmap.Types> heightMap) {
        int placeY;
        RegistryAccess regAccess = context.f_226621_();
        ChunkGenerator chunkgenerator = context.f_226622_();
        StructureTemplateManager structuretemplatemanager = context.f_226625_();
        LevelHeightAccessor heightaccessor = context.f_226629_();
        WorldgenRandom worldgenrandom = context.f_226626_();
        Registry structPoolRegistry = regAccess.m_175515_(Registries.f_256948_);
        Rotation rotation = Rotation.m_221990_((RandomSource)worldgenrandom);
        StructureTemplatePool templatepool = (StructureTemplatePool)startPool.m_203334_();
        StructurePoolElement poolElement = templatepool.m_227355_((RandomSource)worldgenrandom);
        if (poolElement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece piece = new PoolElementStructurePiece(structuretemplatemanager, poolElement, structPos, 0, rotation, poolElement.m_214015_(structuretemplatemanager, structPos, rotation));
        BoundingBox structBox = piece.m_73547_();
        int placeX = (structBox.m_162399_() + structBox.m_162395_()) / 2;
        int placeZ = (structBox.m_162401_() + structBox.m_162398_()) / 2;
        if (heightMap.isPresent()) {
            placeY = structPos.m_123342_() + chunkgenerator.m_223221_(placeX, placeZ, heightMap.get(), heightaccessor, context.f_226624_());
            piece.m_6324_(0, placeY, 0);
        } else {
            placeY = structPos.m_123342_();
        }
        return Optional.of(new Structure.GenerationStub(new BlockPos(placeX, placeY, placeZ), builder -> {
            ArrayList<PoolElementStructurePiece> list = new ArrayList<PoolElementStructurePiece>();
            list.add(piece);
            if (this.size > 0) {
                AABB aabb = new AABB((double)(placeX - 128), (double)(placeY - 128), (double)(placeZ - 128), (double)(placeX + 129), (double)(placeY + 129), (double)(placeZ + 129));
                VoxelShape shape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)structBox)), (BooleanOp)BooleanOp.f_82685_);
                JigsawPlacement.m_227210_((RandomState)context.f_226624_(), (int)this.size, (boolean)true, (ChunkGenerator)chunkgenerator, (StructureTemplateManager)structuretemplatemanager, (LevelHeightAccessor)heightaccessor, (RandomSource)worldgenrandom, (Registry)structPoolRegistry, (PoolElementStructurePiece)piece, list, (VoxelShape)shape);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)builder).m_142679_(arg_0));
            }
        }));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)PMStructures.BIG_STRUCTURE.get();
    }

    static {
        PMConfig config = PMConfig.SETTINGS;
        CONFIG_KEYS.put("mediumDarkDungeon", config.structures.mediumDarkDungeon);
        CONFIG_KEYS.put("darkTower", config.structures.darkTower);
        CONFIG_KEYS.put("brickPyramids", config.structures.brickPyramids);
        CONFIG_KEYS.put("terrariums", config.structures.terrariums);
        CONFIG_KEYS.put("minerBases", config.structures.minerBases);
        CONFIG_KEYS.put("largeDarkDungeon", config.structures.largeDarkDungeon);
        CONFIG_KEYS.put("badlandsPyramids", config.structures.badlandsPyramids);
        CONFIG_KEYS.put("darkDesertPyramids", config.structures.darkDesertPyramids);
        CONFIG_KEYS.put("skyWheels", config.structures.skyWheels);
        CONFIG_KEYS.put("enderOutpost", config.structures.enderOutposts);
        CONFIG_KEYS.put("wickerMan", config.structures.wickerMan);
        CONFIG_KEYS.put("traderTent", config.structures.traderTent);
        CONFIG_KEYS.put("monastery", config.structures.monastery);
        CONFIG_KEYS.put("conduit", config.structures.conduit);
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BigStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)Codec.STRING.fieldOf("start_pool").forGetter(structure -> structure.startPoolName), (App)Codec.STRING.fieldOf("config_key").forGetter(structure -> structure.configKey), (App)Codec.INT.fieldOf("size").orElse((Object)1).forGetter(structure -> structure.size), (App)Codec.STRING.fieldOf("gen_type").forGetter(structure -> structure.genType.name().toLowerCase())).apply((Applicative)instance, BigStructure::new)).codec();
    }
}

