/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.building.FenceGates;
import net.paradisemod.building.Fences;
import net.paradisemod.building.Trapdoors;
import net.paradisemod.redstone.Redstone;
import net.paradisemod.world.Ores;
import net.paradisemod.world.PMWorld;
import net.paradisemod.worldgen.features.BasicFeature;

public class Buoy
extends BasicFeature {
    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        if (PMConfig.SETTINGS.structures.buoys.shouldGenerate(rand)) {
            int by;
            int z;
            int x;
            int z2;
            int x2;
            BlockPos newPos = pos.m_175288_(62);
            Block trapdoor = Blocks.f_50216_;
            Block fence = Blocks.f_50132_;
            Block fenceGate = Blocks.f_50192_;
            switch (rand.m_188503_(3)) {
                case 0: {
                    trapdoor = Trapdoors.RUSTED_IRON_TRAPDOOR.get();
                    fence = Fences.RUSTED_IRON_FENCE.get();
                    fenceGate = FenceGates.RUSTED_IRON_FENCE_GATE.get();
                }
                case 1: {
                    int z3;
                    int x3;
                    ITag<Block> lanterns = Utils.getBlockTag(PMTags.Blocks.BUOY_LANTERNS);
                    if (lanterns.isEmpty()) {
                        return false;
                    }
                    for (x3 = 0; x3 <= 2; ++x3) {
                        for (z3 = 0; z3 <= 2; ++z3) {
                            world.m_7731_(newPos.m_7918_(x3, 0, z3), (BlockState)((BlockState)((BlockState)trapdoor.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)Half.TOP)).m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(rand)), 8);
                        }
                    }
                    for (x3 = 0; x3 <= 2; ++x3) {
                        for (z3 = 0; z3 <= 2; ++z3) {
                            world.m_7731_(newPos.m_7918_(x3, 1, z3), fence.m_49966_(), 8);
                        }
                    }
                    world.m_7731_(newPos.m_7918_(1, 1, 1), ((Block)lanterns.getRandomElement(rand).get()).m_49966_(), 8);
                    world.m_7731_(newPos.m_7918_(1, 1, 0), (BlockState)fenceGate.m_49966_().m_61124_((Property)FenceGateBlock.f_54117_, (Comparable)Direction.NORTH), 8);
                    PMWorld.updateBlockStates((LevelAccessor)world, newPos, 3, 2, 3);
                    return true;
                }
            }
            ITag<Block> lights = Utils.getBlockTag(PMTags.Blocks.BUOY_LIGHTS);
            if (lights.isEmpty()) {
                return false;
            }
            for (x2 = 0; x2 <= 5; ++x2) {
                for (z2 = 0; z2 <= 5; ++z2) {
                    world.m_7731_(newPos.m_7918_(x2, 1, z2), Fences.RUSTED_IRON_FENCE.get().m_49966_(), 8);
                }
            }
            for (x2 = 1; x2 <= 4; ++x2) {
                for (z2 = 1; z2 <= 4; ++z2) {
                    world.m_7731_(newPos.m_7918_(x2, 1, z2), Blocks.f_50016_.m_49966_(), 8);
                }
            }
            for (x2 = 0; x2 <= 5; ++x2) {
                for (z2 = 0; z2 <= 5; ++z2) {
                    world.m_7731_(newPos.m_7918_(x2, 0, z2), (BlockState)((BlockState)((BlockState)Trapdoors.RUSTED_IRON_TRAPDOOR.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)Half.TOP)).m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(rand)), 8);
                }
            }
            world.m_7731_(newPos.m_7918_(2, 1, 5), (BlockState)FenceGates.RUSTED_IRON_FENCE_GATE.get().m_49966_().m_61124_((Property)FenceGateBlock.f_54117_, (Comparable)Direction.NORTH), 8);
            Block lamp = (Block)lights.getRandomElement(rand).get();
            for (x = 2; x <= 3; ++x) {
                for (z = 2; z <= 3; ++z) {
                    for (by = 1; by <= 2; ++by) {
                        world.m_7731_(newPos.m_7918_(x, by, z), (BlockState)lamp.m_49966_().m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true)), 8);
                    }
                }
            }
            for (x = 2; x <= 3; ++x) {
                for (z = 2; z <= 3; ++z) {
                    world.m_7731_(newPos.m_7918_(x, 3, z), Buoy.genLever(rand), 8);
                }
            }
            for (x = 2; x <= 3; ++x) {
                for (z = 2; z <= 3; ++z) {
                    for (by = -1; by <= 0; ++by) {
                        world.m_7731_(newPos.m_7918_(x, by, z), Ores.RUSTED_IRON_BLOCK.get().m_49966_(), 8);
                    }
                }
            }
            PMWorld.updateBlockStates((LevelAccessor)world, newPos, 6, 2, 6);
            return true;
        }
        return false;
    }

    private static BlockState genLever(RandomSource rand) {
        if (rand.m_188499_()) {
            return (BlockState)((BlockState)((BlockState)Blocks.f_50164_.m_49966_().m_61124_((Property)LeverBlock.f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LeverBlock.f_54117_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(rand));
        }
        return (BlockState)((BlockState)((BlockState)Redstone.MOSSY_COBBLESTONE_LEVER.get().m_49966_().m_61124_((Property)LeverBlock.f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LeverBlock.f_54117_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(rand));
    }
}

