/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.paradisemod.base.PMConfig;
import net.paradisemod.world.PMWorld;
import net.paradisemod.worldgen.structures.SmallStructure;

public class CreatorHeads
extends SmallStructure {
    private static final ResourceLocation CHAOS_HEAD = new ResourceLocation("paradisemod", "chaos_head");
    private static final ResourceLocation NETHERNOAH_HEAD = new ResourceLocation("paradisemod", "nethernoah_head");

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        if (PMConfig.SETTINGS.structures.creatorMonuments.shouldGenerate(rand)) {
            ResourceLocation location = rand.m_188499_() ? CHAOS_HEAD : NETHERNOAH_HEAD;
            StructureTemplate template = (StructureTemplate)world.m_6018_().m_215082_().m_230407_(location).get();
            Vec3i size = template.m_163801_();
            int level = PMWorld.getLowestY((LevelAccessor)world, pos, pos.m_121955_(size)) + 1;
            if (level < 63) {
                return false;
            }
            BlockPos newPos = new BlockPos(pos.m_123341_(), level, pos.m_123343_());
            if (!CreatorHeads.checkArea(world, newPos, size)) {
                return false;
            }
            return this.genStructureFromTemplate(template, world, rand, newPos, generator, false);
        }
        return false;
    }
}

