/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.redstone.Lamps;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.structures.SmallStructure;

public class GroundStructure
extends SmallStructure {
    @Nullable
    private Holder<Biome> biome = null;
    private final ResourceLocation structure;
    private final boolean overGrow;
    private final PMConfig.WorldGenOption settings;
    private final ArrayList<Supplier<Block>> supportBlocks = new ArrayList();
    private final SupportType support;

    public GroundStructure(String name, boolean overGrow, PMConfig.WorldGenOption settings, SupportType support, Block ... supportBlocks) {
        this.structure = new ResourceLocation("paradisemod:" + name);
        this.overGrow = overGrow;
        this.settings = settings;
        for (Block block : supportBlocks) {
            this.supportBlocks.add(() -> block);
        }
        this.support = support;
    }

    @SafeVarargs
    public GroundStructure(String name, boolean overGrow, PMConfig.WorldGenOption settings, SupportType support, Supplier<Block> ... supportBlocks) {
        this.structure = new ResourceLocation("paradisemod:" + name);
        this.overGrow = overGrow;
        this.settings = settings;
        this.supportBlocks.addAll(Arrays.asList(supportBlocks));
        this.support = support;
    }

    public GroundStructure(String name, boolean overGrow, PMConfig.WorldGenOption settings, SupportType support) {
        this.structure = new ResourceLocation("paradisemod", name);
        this.overGrow = overGrow;
        this.settings = settings;
        this.support = support;
    }

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        if (this.settings.shouldGenerate(rand)) {
            StructureTemplate template = (StructureTemplate)world.m_6018_().m_215082_().m_230407_(this.structure).get();
            Vec3i size = template.m_163801_();
            int level = this.support == SupportType.SOLID || this.support == SupportType.STILTS ? PMWorld.getHighestY((LevelAccessor)world, pos, pos.m_121955_(size)) : PMWorld.getLowestY((LevelAccessor)world, pos, pos.m_121955_(size));
            if (level < 63) {
                return false;
            }
            BlockPos newPos = pos.m_175288_(level);
            if (this.structure.toString() == "paradisemod:rebels_1") {
                newPos = pos.m_175288_(level - 1);
            }
            if (GroundStructure.checkArea(world, newPos, size)) {
                return this.genStructureFromTemplate(template, world, rand, newPos, generator, this.support != SupportType.IN_GROUND || this.overGrow);
            }
        }
        return false;
    }

    @Override
    protected void postProcessStructure(StructureTemplate template, WorldGenLevel world, RandomSource rand, BlockPos pos, StructurePlaceSettings settings, ChunkGenerator generator) {
        int sizeX = template.m_163801_().m_123341_();
        int sizeY = template.m_163801_().m_123342_();
        int sizeZ = template.m_163801_().m_123343_();
        this.biome = world.m_204166_(pos);
        this.postProcessByBlock(world, template, pos, (curState, curPos) -> {
            BlockPos.MutableBlockPos newPos;
            int x = curPos.m_123341_() - pos.m_123341_();
            int y = curPos.m_123342_() - pos.m_123342_();
            int z = curPos.m_123343_() - pos.m_123343_();
            BlockState curStateAbove = world.m_8055_(curPos.m_7494_());
            BlockState curStateBelow = world.m_8055_(curPos.m_7495_());
            if (this.overGrow) {
                if (curState.m_60713_(Blocks.f_49990_) && curStateAbove.m_60713_(Blocks.f_50016_) && rand.m_188503_(3) == 0) {
                    world.m_7731_(curPos.m_7494_(), Blocks.f_50196_.m_49966_(), 32);
                }
                if (curState.m_60815_() && curStateAbove.m_60713_(Blocks.f_49990_) && rand.m_188503_(7) == 0) {
                    world.m_7731_(curPos.m_7494_(), Blocks.f_50037_.m_49966_(), 32);
                }
                if (curState.m_60713_(Blocks.f_50222_)) {
                    switch (rand.m_188503_(3)) {
                        case 0: {
                            world.m_7731_(curPos, Blocks.f_50223_.m_49966_(), 32);
                            break;
                        }
                        case 1: {
                            world.m_7731_(curPos, Blocks.f_50224_.m_49966_(), 32);
                            break;
                        }
                    }
                }
                if (rand.m_188503_(10) == 0 && (this.biome.m_203656_(BiomeTags.f_207610_) || this.biome.m_203656_(Tags.Biomes.IS_SWAMP)) && curState.m_60815_()) {
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!world.m_8055_(curPos.m_121945_(direction)).m_60795_()) continue;
                        switch (direction) {
                            case EAST: {
                                world.m_7731_(curPos.m_122029_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)), 32);
                                break;
                            }
                            case WEST: {
                                world.m_7731_(curPos.m_122024_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)), 32);
                                break;
                            }
                            case NORTH: {
                                world.m_7731_(curPos.m_122012_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)), 32);
                                break;
                            }
                            case SOUTH: {
                                world.m_7731_(curPos.m_122019_(), (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)), 32);
                            }
                        }
                    }
                }
            }
            if (y == 0 && this.support != SupportType.IN_GROUND && curState.m_60815_()) {
                newPos = curPos.m_7495_().m_122032_();
                block10 : switch (this.support) {
                    case SOLID: {
                        while (!world.m_8055_((BlockPos)newPos).m_60815_()) {
                            world.m_7731_((BlockPos)newPos, this.supportBlocks.get(rand.m_188503_(this.supportBlocks.size())).get().m_49966_(), 32);
                            newPos.m_122173_(Direction.DOWN);
                            if (newPos.m_123342_() >= 30) continue;
                            break block10;
                        }
                        break;
                    }
                    case STILTS: {
                        if (!(x == 0 && z == 0 || x == 0 && z == sizeZ - 1 || x == sizeX - 1 && z == 0) && (x != sizeX - 1 || z != sizeZ - 1)) break;
                        while (!world.m_8055_((BlockPos)newPos).m_60815_()) {
                            world.m_7731_((BlockPos)newPos, this.supportBlocks.get(rand.m_188503_(this.supportBlocks.size())).get().m_49966_(), 32);
                            newPos.m_122173_(Direction.DOWN);
                            if (newPos.m_123342_() >= 30) continue;
                            break block10;
                        }
                        break;
                    }
                }
            }
            if (curState.m_60713_(Blocks.f_50652_) && rand.m_188503_(3) == 0) {
                world.m_7731_(curPos, Blocks.f_50079_.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50375_)) {
                world.m_7731_(curPos, Blocks.f_50016_.m_49966_(), 32);
                world.m_7731_(curPos.m_7494_(), Blocks.f_50016_.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50261_)) {
                world.m_7731_(curPos, (BlockState)this.getColoredLamp(rand).m_49966_().m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true)), 32);
            }
            if (curState.m_60713_(Blocks.f_50155_) && curStateBelow.m_60795_()) {
                newPos = curPos.m_7495_().m_122032_();
                Direction facing = (Direction)curState.m_61143_((Property)LadderBlock.f_54337_);
                while (!world.m_8055_((BlockPos)newPos).m_60815_()) {
                    world.m_7731_((BlockPos)newPos, (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)facing), 32);
                    newPos.m_122173_(Direction.DOWN);
                    if (newPos.m_123342_() >= 30) continue;
                    break;
                }
            }
        });
        PMWorld.updateBlockStates((LevelAccessor)world, pos, sizeX, sizeY, sizeZ);
    }

    private Block getColoredLamp(RandomSource rand) {
        ResourceKey key = (ResourceKey)this.biome.m_203543_().get();
        for (Map.Entry<DyeColor, ResourceKey<Biome>> entry : PMBiomes.ROSE_FIELDS_BY_COLOR.entrySet()) {
            DyeColor color = entry.getKey();
            ResourceKey<Biome> biome = entry.getValue();
            if (key != biome) continue;
            return Lamps.REDSTONE_LAMPS.get(color).get();
        }
        if (this.biome.m_203565_(Biomes.f_48151_)) {
            return Lamps.BLUE_REDSTONE_LAMP.get();
        }
        if (this.biome.m_203656_(BiomeTags.f_207607_) || this.biome.m_203656_(PMTags.Biomes.ROCKY_DESERTS) || this.biome.m_203656_(PMTags.Biomes.COLD_ROCKY_DESERTS)) {
            return Lamps.BROWN_REDSTONE_LAMP.get();
        }
        if (this.biome.m_203565_(Biomes.f_48149_) || this.biome.m_203565_(Biomes.f_186762_)) {
            return Lamps.CYAN_REDSTONE_LAMP.get();
        }
        if (this.biome.m_203656_(Tags.Biomes.IS_SWAMP) || this.biome.m_203565_(PMBiomes.TEMPERATE_RAINFOREST)) {
            return Lamps.GREEN_REDSTONE_LAMP.get();
        }
        if (this.biome.m_203656_(Tags.Biomes.IS_CONIFEROUS) || this.biome.m_203656_(Tags.Biomes.IS_COLD) || this.biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            return Lamps.LIGHT_BLUE_REDSTONE_LAMP.get();
        }
        if (this.biome.m_203656_(BiomeTags.f_207610_)) {
            return Lamps.LIME_REDSTONE_LAMP.get();
        }
        if (this.biome.m_203656_(BiomeTags.f_215816_)) {
            return Lamps.ORANGE_REDSTONE_LAMP.get();
        }
        if (this.biome.m_203656_(Tags.Biomes.IS_DRY) && !this.biome.m_203656_(BiomeTags.f_207607_) && !this.biome.m_203656_(PMTags.Biomes.ROCKY_DESERTS) && !this.biome.m_203656_(PMTags.Biomes.COLD_ROCKY_DESERTS)) {
            return Lamps.YELLOW_REDSTONE_LAMP.get();
        }
        if (this.biome.m_203565_(PMBiomes.AUTUMN_FOREST)) {
            Block[] autumnLamps = new Block[]{Lamps.YELLOW_REDSTONE_LAMP.get(), Lamps.ORANGE_REDSTONE_LAMP.get(), Lamps.RED_REDSTONE_LAMP.get(), Lamps.BLUE_REDSTONE_LAMP.get()};
            return autumnLamps[rand.m_188503_(4)];
        }
        return Blocks.f_50261_;
    }

    public static enum SupportType {
        IN_GROUND,
        SOLID,
        STILTS;

    }
}

