/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.structures.SmallStructure;

public class Home
extends SmallStructure {
    private Direction direction = Direction.EAST;
    private boolean isBalcony = false;
    @Nullable
    private Holder<Biome> biome = null;
    private List<Block> wood = List.of();

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        if (PMConfig.SETTINGS.structures.homes.shouldGenerate(rand)) {
            int y;
            this.biome = world.m_204166_(pos);
            this.wood = Home.getWood(rand, this.biome);
            if (this.biome.m_203656_(Tags.Biomes.IS_WATER) || this.biome.m_203656_(PMTags.Biomes.SALT) || this.biome.m_203656_(PMTags.Biomes.VOLCANIC)) {
                return false;
            }
            this.direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
            ResourceLocation home = new ResourceLocation("paradisemod:starter_house/" + this.direction.name().toLowerCase());
            ResourceLocation balcony = new ResourceLocation("paradisemod:starter_house/balcony_" + this.direction.name().toLowerCase());
            int[] homeSize = new int[]{6, 7};
            if (this.direction.m_122434_() == Direction.Axis.Z) {
                homeSize = new int[]{7, 6};
            }
            if ((y = PMWorld.getHighestY((LevelAccessor)world, pos, pos.m_7918_(homeSize[0], 0, homeSize[1]))) < 2) {
                return false;
            }
            BlockPos homePos = pos.m_175288_(y);
            BlockPos balconyPos = this.getBalconyPos(homePos);
            if (!Home.checkArea(world, homePos, new Vec3i(10, 8, 10))) {
                return false;
            }
            this.isBalcony = this.needsBalcony(world, balconyPos);
            if (this.direction == Direction.WEST) {
                this.genStructureFromTemplate(home, world, rand, homePos.m_122030_(3), generator, true);
            } else if (this.direction == Direction.NORTH) {
                this.genStructureFromTemplate(home, world, rand, homePos.m_122020_(3), generator, true);
            } else {
                this.genStructureFromTemplate(home, world, rand, homePos, generator, true);
            }
            if (this.isBalcony) {
                if (this.direction == Direction.WEST) {
                    this.genStructureFromTemplate(balcony, world, rand, balconyPos.m_122030_(3), generator, true);
                } else if (this.direction == Direction.NORTH) {
                    this.genStructureFromTemplate(balcony, world, rand, balconyPos.m_122020_(3), generator, true);
                } else {
                    this.genStructureFromTemplate(balcony, world, rand, balconyPos, generator, true);
                }
            }
            if (balconyPos.m_123341_() < homePos.m_123341_() && balconyPos.m_123343_() < homePos.m_123343_()) {
                PMWorld.updateBlockStates((LevelAccessor)world, balconyPos, 9, 8, 9);
            } else {
                PMWorld.updateBlockStates((LevelAccessor)world, homePos, 9, 8, 9);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void postProcessStructure(StructureTemplate template, WorldGenLevel world, RandomSource rand, BlockPos pos, StructurePlaceSettings settings, ChunkGenerator generator) {
        List<Block> coloredBlocks = Home.getColoredBlocks(rand, this.biome);
        Block fence = this.wood.get(0);
        Block fenceGate = this.wood.get(1);
        Block craftingTable = this.wood.get(2);
        Block log = this.wood.get(3);
        Block plate = this.wood.get(4);
        Block planks = this.wood.get(5);
        Block door = this.wood.get(7);
        Block chest = this.wood.get(8);
        Block trapdoor = this.wood.get(9);
        Block bookShelf = this.wood.get(10);
        Block lantern = coloredBlocks.get(1);
        Block bed = coloredBlocks.get(3);
        BlockPos newPos = pos;
        if (this.direction == Direction.EAST && !this.isBalcony) {
            newPos = pos.m_122019_();
        }
        this.postProcessByBlock(world, 9, 8, 9, newPos, (curState, curPos) -> {
            Direction facing;
            if (curState.m_60713_(Blocks.f_50091_)) {
                world.m_7731_(curPos, craftingTable.m_49966_(), 32);
            }
            if (curState.m_60713_(Blocks.f_50705_)) {
                world.m_7731_(curPos, planks.m_49966_(), 32);
            }
            if (world.m_8055_(curPos).m_60713_(Blocks.f_50681_)) {
                world.m_7731_(curPos, lantern.m_49966_(), 32);
            }
            if (world.m_8055_(curPos).m_60713_(Blocks.f_50028_)) {
                BedPart part = (BedPart)world.m_8055_(curPos).m_61143_((Property)BedBlock.f_49440_);
                Direction bedDir = (Direction)world.m_8055_(curPos).m_61143_((Property)BedBlock.f_54117_);
                world.m_7731_(curPos, (BlockState)((BlockState)bed.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)part)).m_61124_((Property)BedBlock.f_54117_, (Comparable)bedDir), 32);
            }
            if (world.m_8055_(curPos).m_60713_(Blocks.f_50132_)) {
                world.m_7731_(curPos, fence.m_49966_(), 32);
            }
            if (world.m_8055_(curPos).m_60713_(Blocks.f_50087_)) {
                facing = (Direction)curState.m_61143_((Property)ChestBlock.f_51478_);
                ChestType type = (ChestType)curState.m_61143_((Property)ChestBlock.f_51479_);
                world.m_7731_(curPos, Blocks.f_50016_.m_49966_(), 32);
                world.m_7731_(curPos, (BlockState)((BlockState)chest.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)type), 32);
                BlockEntity tile = world.m_7702_(curPos);
                if (tile instanceof ChestBlockEntity) {
                    ChestBlockEntity chestTile = (ChestBlockEntity)tile;
                    if (this.biome.m_203565_(PMBiomes.GLOWING_FOREST) || this.biome.m_203565_(PMBiomes.CRYSTAL_FOREST)) {
                        chestTile.m_59626_(new ResourceLocation("chests/buried_treasure"), rand.m_188505_());
                    } else {
                        chestTile.m_59626_(new ResourceLocation("paradisemod:chests/starter_chest"), rand.m_188505_());
                    }
                }
            }
            if (world.m_8055_(curPos).m_60713_(Blocks.f_50167_)) {
                world.m_7731_(curPos, plate.m_49966_(), 32);
            }
            if (world.m_8055_(curPos).m_60713_(Blocks.f_50078_)) {
                world.m_7731_(curPos, bookShelf.m_49966_(), 32);
            }
            if (world.m_8055_(curPos).m_60713_(Blocks.f_50192_)) {
                Direction gateDir = (Direction)world.m_8055_(curPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                world.m_7731_(curPos, (BlockState)fenceGate.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)gateDir), 32);
            }
            if (curState.m_60713_(Blocks.f_50154_)) {
                facing = (Direction)curState.m_61143_((Property)DoorBlock.f_52726_);
                Boolean open = (Boolean)curState.m_61143_((Property)DoorBlock.f_52727_);
                DoorHingeSide hinge = (DoorHingeSide)curState.m_61143_((Property)DoorBlock.f_52728_);
                DoubleBlockHalf half = (DoubleBlockHalf)curState.m_61143_((Property)DoorBlock.f_52730_);
                if (half == DoubleBlockHalf.LOWER) {
                    world.m_7731_(curPos, (BlockState)((BlockState)((BlockState)((BlockState)door.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)open)).m_61124_((Property)DoorBlock.f_52728_, (Comparable)hinge)).m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER), 32);
                    world.m_7731_(curPos.m_7494_(), (BlockState)((BlockState)((BlockState)((BlockState)door.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)open)).m_61124_((Property)DoorBlock.f_52728_, (Comparable)hinge)).m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 32);
                }
            }
            if (curState.m_60713_(Blocks.f_50216_)) {
                facing = (Direction)curState.m_61143_((Property)TrapDoorBlock.f_54117_);
                Half half = (Half)curState.m_61143_((Property)TrapDoorBlock.f_57515_);
                world.m_7731_(curPos, (BlockState)((BlockState)trapdoor.m_49966_().m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)facing)).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)half), 32);
            }
            if (curState.m_60713_(Blocks.f_50398_)) {
                BlockPos.MutableBlockPos stiltPos = new BlockPos.MutableBlockPos(curPos.m_123341_(), curPos.m_123342_() - 1, curPos.m_123343_());
                while (!world.m_8055_((BlockPos)stiltPos).m_60815_()) {
                    world.m_7731_((BlockPos)stiltPos, log.m_49966_(), 32);
                    stiltPos.m_122173_(Direction.DOWN);
                    if (stiltPos.m_123342_() >= -34) continue;
                }
                world.m_7731_(curPos, planks.m_49966_(), 32);
            }
        });
        PMWorld.updateBlockStates((LevelAccessor)world, newPos, 9, 8, 9);
    }

    private boolean needsBalcony(WorldGenLevel world, BlockPos balconyPos) {
        for (int i = 0; i < 6; ++i) {
            BlockPos newPos = balconyPos.m_122030_(i);
            if (this.direction.m_122434_() == Direction.Axis.Z) {
                newPos = balconyPos.m_122020_(i);
            }
            if (world.m_8055_(newPos).m_60815_()) continue;
            return true;
        }
        return false;
    }

    private BlockPos getBalconyPos(BlockPos basePos) {
        return switch (this.direction) {
            default -> basePos.m_122030_(6).m_122019_();
            case Direction.WEST -> basePos.m_122025_(3);
            case Direction.NORTH -> basePos.m_122029_().m_122013_(3);
            case Direction.SOUTH -> basePos.m_122020_(6);
        };
    }
}

