/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.PMConfig;
import net.paradisemod.worldgen.structures.PMStructures;
import net.paradisemod.worldgen.structures.postprocessors.StructurePostProcessor;

public class ImprovedPoolElement
extends StructurePoolElement {
    private static final Codec<Either<ResourceLocation, StructureTemplate>> TEMPLATE_CODEC = Codec.of(ImprovedPoolElement::encodeTemplate, (Decoder)ResourceLocation.f_135803_.map(Either::left));
    public static final Codec<ImprovedPoolElement> CODEC = RecordCodecBuilder.create((T builder) -> builder.group(ImprovedPoolElement.templateCodec(), ImprovedPoolElement.processorsCodec(), (App)ImprovedPoolElement.m_210538_(), (App)Codec.STRING.optionalFieldOf("post_processor").forGetter(element -> element.postProcessorName)).apply((Applicative)builder, ImprovedPoolElement::new));
    protected final Either<ResourceLocation, StructureTemplate> template;
    protected final Holder<StructureProcessorList> processors;
    private final Optional<String> postProcessorName;

    protected ImprovedPoolElement(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> processors, StructureTemplatePool.Projection projection, Optional<String> postProcessorName) {
        super(projection);
        this.template = template;
        this.processors = processors;
        this.postProcessorName = postProcessorName;
    }

    public Vec3i m_213577_(StructureTemplateManager structureTemplateManager, Rotation rotation) {
        StructureTemplate template = this.getTemplate(structureTemplateManager);
        return template.m_163808_(rotation);
    }

    public List<StructureTemplate.StructureBlockInfo> m_213638_(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, RandomSource random) {
        StructureTemplate structuretemplate = this.getTemplate(structureTemplateManager);
        ObjectArrayList jigsaws = structuretemplate.m_230335_(pos, new StructurePlaceSettings().m_74379_(rotation), Blocks.f_50678_, true);
        Util.m_214673_((ObjectArrayList)jigsaws, (RandomSource)random);
        return jigsaws;
    }

    public BoundingBox m_214015_(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation) {
        StructureTemplate template = this.getTemplate(structureTemplateManager);
        return template.m_74633_(new StructurePlaceSettings().m_74379_(rotation), pos);
    }

    public boolean m_213695_(StructureTemplateManager structureTemplateManager, WorldGenLevel world, StructureManager structureManager, ChunkGenerator generator, BlockPos offset, BlockPos pos, Rotation rotation, BoundingBox chunkBox, RandomSource rand, boolean keepJigsaws) {
        StructureTemplate template = this.getTemplate(structureTemplateManager);
        StructurePlaceSettings placeSettings = this.getSettings(rotation, chunkBox, keepJigsaws);
        BoundingBox box = template.m_74633_(placeSettings, offset);
        if (template.m_230328_((ServerLevelAccessor)world, offset, pos, placeSettings, rand, 2)) {
            if (this.postProcessorName.isPresent()) {
                StructurePostProcessor.Constructor postProcessor;
                if (((Boolean)PMConfig.SETTINGS.structures.debugMode.get()).booleanValue()) {
                    world.m_7731_(pos, Blocks.f_50214_.m_49966_(), 16);
                    world.m_7731_(offset, Blocks.f_50211_.m_49966_(), 16);
                }
                if ((postProcessor = PMStructures.STRUCT_POST_PROCESSORS.get(this.postProcessorName.get())) != null) {
                    postProcessor.construct(new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162398_()), new BlockPos(box.m_162399_(), box.m_162400_(), box.m_162401_())).run(world, generator, rand);
                } else {
                    ParadiseMod.LOG.error("Structure post processor \"" + this.postProcessorName.get() + "\" doesn't seem to exist!");
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public StructurePoolElementType<ImprovedPoolElement> m_207234_() {
        return (StructurePoolElementType)PMStructures.IMPROVED_ELEMENT.get();
    }

    public String toString() {
        return "ImprovedElement[" + String.valueOf(this.template) + "]";
    }

    private StructurePlaceSettings getSettings(Rotation rotation, BoundingBox boundingBox, boolean offset) {
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74381_(boundingBox).m_74379_(rotation).m_74402_(true).m_74392_(false).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_).m_74405_(true);
        if (!offset) {
            placeSettings.m_74383_((StructureProcessor)JigsawReplacementProcessor.f_74122_);
        }
        ((StructureProcessorList)this.processors.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)placeSettings).m_74383_(arg_0));
        this.m_210539_().m_210609_().forEach(arg_0 -> ((StructurePlaceSettings)placeSettings).m_74383_(arg_0));
        return placeSettings;
    }

    private StructureTemplate getTemplate(StructureTemplateManager structureTemplateManager) {
        return (StructureTemplate)this.template.map(arg_0 -> ((StructureTemplateManager)structureTemplateManager).m_230359_(arg_0), Function.identity());
    }

    private static <T> DataResult<T> encodeTemplate(Either<ResourceLocation, StructureTemplate> template, DynamicOps<T> options, T element) {
        Optional optional = template.left();
        return !optional.isPresent() ? DataResult.error(() -> "Can not serialize a runtime pool element") : ResourceLocation.f_135803_.encode((Object)((ResourceLocation)optional.get()), options, element);
    }

    private static <E extends ImprovedPoolElement> RecordCodecBuilder<E, Holder<StructureProcessorList>> processorsCodec() {
        return StructureProcessorType.f_74468_.fieldOf("processors").forGetter(element -> element.processors);
    }

    private static <E extends ImprovedPoolElement> RecordCodecBuilder<E, Either<ResourceLocation, StructureTemplate>> templateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(element -> element.template);
    }

    public static Function<StructureTemplatePool.Projection, ImprovedPoolElement> create(String id) {
        return projection -> new ImprovedPoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)new ResourceLocation(id)), (Holder<StructureProcessorList>)new Holder.Direct((Object)new StructureProcessorList(List.of())), (StructureTemplatePool.Projection)projection, Optional.empty());
    }

    public static Function<StructureTemplatePool.Projection, ImprovedPoolElement> create(String id, String postProcessorName, Holder<StructureProcessorList> processors) {
        return projection -> new ImprovedPoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)new ResourceLocation(id)), processors, (StructureTemplatePool.Projection)projection, Optional.of(postProcessorName));
    }

    public static Function<StructureTemplatePool.Projection, ImprovedPoolElement> create(String id, Optional<String> postProcessorName, Holder<StructureProcessorList> processors) {
        return projection -> new ImprovedPoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)new ResourceLocation(id)), processors, (StructureTemplatePool.Projection)projection, postProcessorName);
    }

    public static Function<StructureTemplatePool.Projection, ImprovedPoolElement> create(String id, String postProcessorName) {
        return projection -> new ImprovedPoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)new ResourceLocation(id)), (Holder<StructureProcessorList>)new Holder.Direct((Object)new StructureProcessorList(List.of())), (StructureTemplatePool.Projection)projection, Optional.of(postProcessorName));
    }
}

