/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.paradisemod.base.PMConfig;
import net.paradisemod.redstone.Plates;
import net.paradisemod.world.PMWorld;
import net.paradisemod.worldgen.features.BasicFeature;

public class LandMine
extends BasicFeature {
    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        OptionalInt y;
        if (PMConfig.SETTINGS.structures.landmines.shouldGenerate(rand) && (y = PMWorld.getGroundLevel((LevelAccessor)world, -56, 320, pos)).isPresent()) {
            BlockPos newPos = pos.m_175288_(y.getAsInt() + 1);
            List<Block> validBlocks = List.of(Blocks.f_50069_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_50122_, Blocks.f_50440_, Blocks.f_50493_);
            List<Block> plates = List.of(Blocks.f_50165_, Plates.DIORITE_PRESSURE_PLATE.get(), Plates.ANDESITE_PRESSURE_PLATE.get(), Plates.GRANITE_PRESSURE_PLATE.get(), Plates.GRASS_PRESSURE_PLATE.get(), Plates.DIRT_PRESSURE_PLATE.get());
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Block ground = world.m_8055_(newPos.m_7918_(x, -1, z)).m_60734_();
                    if (validBlocks.contains(ground)) continue;
                    return false;
                }
            }
            int index = 0;
            for (Block block : validBlocks) {
                if (world.m_8055_(newPos.m_7495_()).m_60713_(block)) break;
                ++index;
            }
            world.m_7731_(newPos, plates.get(index).m_49966_(), 1);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    world.m_7731_(newPos.m_7918_(x, -2, z), Blocks.f_50077_.m_49966_(), 1);
                }
            }
            return true;
        }
        return false;
    }
}

