/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.PMWorld;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.features.PMFeatures;
import net.paradisemod.worldgen.structures.BigStructure;
import net.paradisemod.worldgen.structures.Buoy;
import net.paradisemod.worldgen.structures.CreatorHeads;
import net.paradisemod.worldgen.structures.GroundStructure;
import net.paradisemod.worldgen.structures.Home;
import net.paradisemod.worldgen.structures.ImprovedPoolElement;
import net.paradisemod.worldgen.structures.LandMine;
import net.paradisemod.worldgen.structures.ResearchBase;
import net.paradisemod.worldgen.structures.RogueEndSpike;
import net.paradisemod.worldgen.structures.SmallDarkDungeon;
import net.paradisemod.worldgen.structures.UndergroundStructure;
import net.paradisemod.worldgen.structures.VillageRuin;
import net.paradisemod.worldgen.structures.postprocessors.BrickDungeonPostProcessor;
import net.paradisemod.worldgen.structures.postprocessors.DarkDungeonPostProcessor;
import net.paradisemod.worldgen.structures.postprocessors.MonasteryPostProcessor;
import net.paradisemod.worldgen.structures.postprocessors.StructurePostProcessor;
import net.paradisemod.worldgen.structures.postprocessors.TerrariumPostProcessor;
import net.paradisemod.worldgen.structures.postprocessors.TraderTentPostProcessor;
import net.paradisemod.worldgen.structures.processors.BrickDungeonProcessor;
import net.paradisemod.worldgen.structures.processors.ConduitProcessor;
import net.paradisemod.worldgen.structures.processors.DarkDungeonProcessor;
import net.paradisemod.worldgen.structures.processors.TerrariumProcessor;

public class PMStructures {
    public static final HashMap<ResourceKey<Structure>, StructureFactory> STRUCTURES = new HashMap();
    protected static final HashMap<String, StructurePostProcessor.Constructor> STRUCT_POST_PROCESSORS = new HashMap();
    private static int LAST_SALT = 0;
    private static final Random STRUCT_SET_SALT_RAND = new Random(420777L);
    private static final DeferredRegister<StructureType<?>> STRUCT_TYPES = PMRegistries.createRegistry(Registries.f_256938_);
    private static final DeferredRegister<StructureProcessorType<?>> STRUCT_PROCESSORS = PMRegistries.createRegistry(Registries.f_256983_);
    private static final DeferredRegister<StructurePoolElementType<?>> POOL_ELEMENT_TYPES = PMRegistries.createRegistry(Registries.f_257024_);
    public static final RegistryObject<StructurePoolElementType<ImprovedPoolElement>> IMPROVED_ELEMENT = POOL_ELEMENT_TYPES.register("improved_element", () -> () -> ImprovedPoolElement.CODEC);
    public static final RegistryObject<StructureType<BigStructure>> BIG_STRUCTURE;
    public static final ResourceKey<PlacedFeature> BUOY;
    public static final ResourceKey<PlacedFeature> LANDMINE;
    public static final ResourceKey<PlacedFeature> RUNWAY;
    public static final ResourceKey<PlacedFeature> EASTER_EGG_1;
    public static final ResourceKey<PlacedFeature> EASTER_EGG_2;
    public static final ResourceKey<PlacedFeature> REBELS_1;
    public static final ResourceKey<PlacedFeature> REBELS_2;
    public static final ResourceKey<PlacedFeature> BLACK_CROSS;
    public static final ResourceKey<PlacedFeature> DEEP_DARK_BLACK_CROSS;
    public static final ResourceKey<PlacedFeature> GOLD_CROSS;
    public static final ResourceKey<PlacedFeature> DEEP_DARK_GOLD_CROSS;
    public static final ResourceKey<PlacedFeature> RUINS;
    public static final ResourceKey<PlacedFeature> SMALL_STRONGHOLD;
    public static final ResourceKey<PlacedFeature> CREATOR_HEADS;
    public static final ResourceKey<PlacedFeature> RESEARCH_BASE;
    public static final ResourceKey<PlacedFeature> HOME;
    public static final ResourceKey<PlacedFeature> SMALL_DARK_DUNGEON;
    public static final ResourceKey<PlacedFeature> ROGUE_SPIKE;
    public static final RegistryObject<StructureProcessorType<BrickDungeonProcessor>> BRICK_DUNGEON_PROCESSOR;
    public static final RegistryObject<StructureProcessorType<TerrariumProcessor>> TERRARIUM_PROCESSOR;
    public static final RegistryObject<StructureProcessorType<DarkDungeonProcessor>> DARK_DUNGEON_PROCESSOR;
    public static final RegistryObject<StructureProcessorType<ConduitProcessor>> CONDUIT_PROCESSOR;
    public static final ResourceKey<Structure> BRICK_PYRAMID;
    public static final ResourceKey<Structure> MEDIUM_DARK_DUNGEON;
    public static final ResourceKey<Structure> LARGE_DARK_DUNGEON;
    public static final ResourceKey<Structure> DARK_TOWER;
    public static final ResourceKey<Structure> MINER_BASE;
    public static final ResourceKey<Structure> TERRARIUM;
    public static final ResourceKey<Structure> OCEAN_TERRARIUM;
    public static final ResourceKey<Structure> BADLANDS_PYRAMID;
    public static final ResourceKey<Structure> DARK_DESERT_PYRAMID;
    public static final ResourceKey<Structure> WICKER_MAN;
    public static final ResourceKey<Structure> TRADER_TENT;
    public static final ResourceKey<Structure> SKY_WHEEL;
    public static final ResourceKey<Structure> ENDER_OUTPOST;
    public static final ResourceKey<Structure> MONASTERY;
    public static final ResourceKey<Structure> CONDUIT;

    public static void init(IEventBus eventBus) {
        STRUCT_TYPES.register(eventBus);
        STRUCT_PROCESSORS.register(eventBus);
        POOL_ELEMENT_TYPES.register(eventBus);
    }

    public static void buildStructSets(BootstapContext<StructureSet> context) {
        ParadiseMod.LOG.debug("Generating structure sets...");
        HolderGetter structGetter = context.m_255420_(Registries.f_256944_);
        PMStructures.buildStructSet(context, BADLANDS_PYRAMID, 32, 8);
        PMStructures.buildStructSet(context, TRADER_TENT, 16, 8);
        PMStructures.buildStructSet(context, CONDUIT, 32, 16);
        PMStructures.buildStructSet(context, "surface_dungeons", 64, 32, PMStructures.createEntry((HolderGetter<Structure>)structGetter, BRICK_PYRAMID), PMStructures.createEntry((HolderGetter<Structure>)structGetter, WICKER_MAN), PMStructures.createEntry((HolderGetter<Structure>)structGetter, MONASTERY));
        PMStructures.buildStructSet(context, "dark_dungeons", 32, 8, PMStructures.createEntry((HolderGetter<Structure>)structGetter, LARGE_DARK_DUNGEON), PMStructures.createEntry((HolderGetter<Structure>)structGetter, DARK_DESERT_PYRAMID), PMStructures.createEntry((HolderGetter<Structure>)structGetter, MEDIUM_DARK_DUNGEON, 2), PMStructures.createEntry((HolderGetter<Structure>)structGetter, DARK_TOWER, 3));
        PMStructures.buildStructSet(context, "terrariums", 32, 16, PMStructures.createEntry((HolderGetter<Structure>)structGetter, TERRARIUM), PMStructures.createEntry((HolderGetter<Structure>)structGetter, OCEAN_TERRARIUM));
        PMStructures.buildStructSet(context, ENDER_OUTPOST, 32, 8);
        PMStructures.buildStructSet(context, MINER_BASE, 32, 16);
        PMStructures.buildStructSet(context, SKY_WHEEL, 128, 64);
    }

    public static void buildStructPools(BootstapContext<StructureTemplatePool> context) {
        ParadiseMod.LOG.debug("Generating template pools...");
        HolderGetter structPoolGetter = context.m_255420_(Registries.f_256948_);
        PMStructures.dungeonPool(context, "badlands_pyramid/bottom", new StructureProcessor[0]);
        PMStructures.dungeonPool(context, "badlands_pyramid/pyramid", new StructureProcessor[0]);
        PMStructures.dungeonPool(context, "dark_desert_pyramid/bottom", new StructureProcessor[0]);
        PMStructures.dungeonPool(context, "dark_desert_pyramid/pyramid", new StructureProcessor[0]);
        PMStructures.structPool(context, "wicker_man/floor", new StructureProcessor[0]);
        PMStructures.structPool(context, "wicker_man/shrine", "brick_dungeon", new StructureProcessor[0]);
        PMStructures.dungeonPool(context, "brick_pyramid/1", new StructureProcessor[0]);
        PMStructures.dungeonPool(context, "brick_pyramid/2", new StructureProcessor[0]);
        PMStructures.dungeonPool(context, "brick_pyramid/3", new StructureProcessor[0]);
        PMStructures.dungeonPool(context, "brick_pyramid/4", new StructureProcessor[0]);
        PMStructures.dungeonPool(context, "dark_tower/bottom", new StructureProcessor[0]);
        PMStructures.structPool(context, "monastery/base", "monastery", new StructureProcessor[0]);
        PMStructures.structPool(context, "monastery/shrine", "monastery", new StructureProcessor[0]);
        PMStructures.structPool(context, "conduit", new ConduitProcessor());
        Holder<StructureTemplatePool> darkTowerTop = PMStructures.dungeonPool(context, "dark_tower/top", new StructureProcessor[0]);
        PMStructures.createMultiElemPool(context, "dark_tower/middle_or_top", darkTowerTop, Pair.of(ImprovedPoolElement.create("paradisemod:dungeons/dark_tower/middle"), (Object)2), Pair.of(ImprovedPoolElement.create("paradisemod:dungeons/dark_tower/top"), (Object)1));
        PMStructures.dungeonPool(context, "ender_outpost/bottom", new StructureProcessor[0]);
        Holder<StructureTemplatePool> enderOutpostTop = PMStructures.dungeonPool(context, "ender_outpost/top", new StructureProcessor[0]);
        Holder<StructureTemplatePool> enderOutpostTopInverted = PMStructures.dungeonPool(context, "ender_outpost/top_inverted", new StructureProcessor[0]);
        PMStructures.createMultiElemPool(context, "ender_outpost/middle_or_top", enderOutpostTop, Pair.of(ImprovedPoolElement.create("paradisemod:dungeons/ender_outpost/middle"), (Object)2), Pair.of(ImprovedPoolElement.create("paradisemod:dungeons/ender_outpost/top"), (Object)1));
        PMStructures.createMultiElemPool(context, "ender_outpost/middle_or_top_inverted", enderOutpostTopInverted, Pair.of(ImprovedPoolElement.create("paradisemod:dungeons/ender_outpost/middle_inverted"), (Object)2), Pair.of(ImprovedPoolElement.create("paradisemod:dungeons/ender_outpost/top_inverted"), (Object)1));
        PMStructures.dungeonPool(context, "large_dark_dungeon/1", "dark_dungeon", new DarkDungeonProcessor());
        PMStructures.dungeonPool(context, "large_dark_dungeon/2", "dark_dungeon", new DarkDungeonProcessor());
        PMStructures.dungeonPool(context, "large_dark_dungeon/3", "dark_dungeon", new DarkDungeonProcessor());
        PMStructures.dungeonPool(context, "large_dark_dungeon/4", "dark_dungeon", new DarkDungeonProcessor());
        PMStructures.dungeonPool(context, "medium_dark_dungeon", "dark_dungeon", new DarkDungeonProcessor());
        PMStructures.dungeonPool(context, "miner_base", "brick_dungeon", new BrickDungeonProcessor());
        PMStructures.dungeonPool(context, "sky_wheel", new StructureProcessor[0]);
        PMStructures.createMultiElemPool(context, "terrarium", (Holder<StructureTemplatePool>)structPoolGetter.m_255043_(Pools.f_127186_), Pair.of(ImprovedPoolElement.create("paradisemod:terrarium", "terrarium", PMStructures.createProcessorList(new TerrariumProcessor())), (Object)1), Pair.of(ImprovedPoolElement.create("paradisemod:village_terrarium", "terrarium", PMStructures.createProcessorList(new TerrariumProcessor())), (Object)1));
        PMStructures.createMultiElemPool(context, "trader_tent", (Holder<StructureTemplatePool>)structPoolGetter.m_255043_(Pools.f_127186_), Pair.of(ImprovedPoolElement.create("paradisemod:trader_tent/left", "trader_tent"), (Object)1), Pair.of(ImprovedPoolElement.create("paradisemod:trader_tent/right", "trader_tent"), (Object)1));
    }

    private static StructureSet.StructureSelectionEntry createEntry(HolderGetter<Structure> structGetter, ResourceKey<Structure> key, int weight) {
        return StructureSet.m_210017_((Holder)structGetter.m_255043_(key), (int)weight);
    }

    private static StructureSet.StructureSelectionEntry createEntry(HolderGetter<Structure> structGetter, ResourceKey<Structure> key) {
        return StructureSet.m_210015_((Holder)structGetter.m_255043_(key));
    }

    private static void buildStructSet(BootstapContext<StructureSet> context, ResourceKey<Structure> key, int spacing, int separation) {
        HolderGetter structGetter = context.m_255420_(Registries.f_256944_);
        PMStructures.buildStructSet(context, key.m_135782_().m_135815_(), spacing, separation, PMStructures.createEntry((HolderGetter<Structure>)structGetter, key));
    }

    private static void buildStructSet(BootstapContext<StructureSet> context, String name, int spacing, int separation, StructureSet.StructureSelectionEntry ... entries) {
        int salt;
        while ((salt = STRUCT_SET_SALT_RAND.nextInt(1, Integer.MAX_VALUE)) == LAST_SALT) {
        }
        LAST_SALT = salt;
        context.m_255272_(PMRegistries.createModResourceKey(Registries.f_256998_, name), (Object)new StructureSet(List.of(entries), (StructurePlacement)new RandomSpreadStructurePlacement(spacing, separation, RandomSpreadType.LINEAR, salt)));
    }

    private static Holder<StructureProcessorList> createProcessorList(StructureProcessor ... processors) {
        return new Holder.Direct((Object)new StructureProcessorList(List.of(processors)));
    }

    private static Holder<StructureTemplatePool> dungeonPool(BootstapContext<StructureTemplatePool> context, String name, String postProcessorName, StructureProcessor ... processors) {
        return PMStructures.structPoolInternal(context, name, "dungeons/" + name, Optional.of(postProcessorName), processors);
    }

    private static Holder<StructureTemplatePool> structPool(BootstapContext<StructureTemplatePool> context, String name, String postProcessorName, StructureProcessor ... processors) {
        return PMStructures.structPoolInternal(context, name, name, Optional.of(postProcessorName), processors);
    }

    private static Holder<StructureTemplatePool> dungeonPool(BootstapContext<StructureTemplatePool> context, String name, StructureProcessor ... processors) {
        return PMStructures.structPoolInternal(context, name, "dungeons/" + name, Optional.empty(), processors);
    }

    private static Holder<StructureTemplatePool> structPool(BootstapContext<StructureTemplatePool> context, String name, StructureProcessor ... processors) {
        return PMStructures.structPoolInternal(context, name, name, Optional.empty(), processors);
    }

    private static Holder<StructureTemplatePool> structPoolInternal(BootstapContext<StructureTemplatePool> context, String name, String structName, Optional<String> postProcessorName, StructureProcessor ... processors) {
        HolderGetter structPoolGetter = context.m_255420_(Registries.f_256948_);
        Function<StructureTemplatePool.Projection, ImprovedPoolElement> element = ImprovedPoolElement.create("paradisemod:" + structName, postProcessorName, PMStructures.createProcessorList(new StructureProcessor[0]));
        if (processors.length > 0) {
            element = ImprovedPoolElement.create("paradisemod:" + structName, postProcessorName, PMStructures.createProcessorList(processors));
        }
        return PMStructures.createMultiElemPool(context, name, (Holder<StructureTemplatePool>)structPoolGetter.m_255043_(Pools.f_127186_), Pair.of(element, (Object)1));
    }

    private static Holder<StructureTemplatePool> createMultiElemPool(BootstapContext<StructureTemplatePool> context, String name, Holder<StructureTemplatePool> fallback, Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> ... elements) {
        ResourceKey key = PMRegistries.createModResourceKey(Registries.f_256948_, name);
        context.m_255272_(key, (Object)new StructureTemplatePool(fallback, List.of(elements), StructureTemplatePool.Projection.RIGID));
        HolderGetter structPoolGetter = context.m_255420_(Registries.f_256948_);
        return structPoolGetter.m_255043_(key);
    }

    private static <P extends StructureProcessor> RegistryObject<StructureProcessorType<P>> regStructProcessor(String name, Codec<P> processorCodec) {
        return Utils.handlePossibleException(() -> STRUCT_PROCESSORS.register(name, () -> () -> processorCodec));
    }

    private static ResourceKey<Structure> createStructure(String name, String configKey, String startPoolName, int size, StructureGenType genType, TagKey<Biome> biomeTag, GenerationStep.Decoration step, TerrainAdjustment terrainAdaptation) {
        ResourceKey structKey = PMRegistries.createModResourceKey(Registries.f_256944_, name);
        STRUCTURES.put(structKey, biomeGetter -> {
            HolderSet.Named biomeList = biomeGetter.m_254956_(biomeTag);
            Structure.StructureSettings structSettings = new Structure.StructureSettings((HolderSet)biomeList, new HashMap(), step, terrainAdaptation);
            return new BigStructure(structSettings, "paradisemod:" + startPoolName, configKey, size, genType);
        });
        return structKey;
    }

    private static ResourceKey<PlacedFeature> getSmallStructure(String name, Supplier<BasicFeature> structure, PlacementModifier ... placements) {
        return PMFeatures.regPlacedFeature("small_structure/" + name, structure, (cfgFeatureGetter, featureGetter) -> FeatureConfiguration.f_67737_, placements);
    }

    private static <T extends Structure> RegistryObject<StructureType<T>> regStructType(String name, Codec<T> structureCodec) {
        return Utils.handlePossibleException(() -> STRUCT_TYPES.register(name, () -> () -> structureCodec));
    }

    static {
        STRUCT_POST_PROCESSORS.put("brick_dungeon", BrickDungeonPostProcessor::new);
        STRUCT_POST_PROCESSORS.put("terrarium", TerrariumPostProcessor::new);
        STRUCT_POST_PROCESSORS.put("dark_dungeon", DarkDungeonPostProcessor::new);
        STRUCT_POST_PROCESSORS.put("trader_tent", TraderTentPostProcessor::new);
        STRUCT_POST_PROCESSORS.put("monastery", MonasteryPostProcessor::new);
        BIG_STRUCTURE = PMStructures.regStructType("big_structure", BigStructure.CODEC);
        BUOY = PMStructures.getSmallStructure("buoy", Buoy::new, new PlacementModifier[0]);
        LANDMINE = PMStructures.getSmallStructure("landmine", LandMine::new, new PlacementModifier[0]);
        RUNWAY = PMStructures.getSmallStructure("runway", () -> new GroundStructure("runway", false, PMConfig.SETTINGS.structures.runways, GroundStructure.SupportType.SOLID, Blocks.f_50222_), new PlacementModifier[0]);
        EASTER_EGG_1 = PMStructures.getSmallStructure("easter_egg_1", () -> new UndergroundStructure("easter_egg_1", true, PMConfig.SETTINGS.structures.eastereggs), new PlacementModifier[0]);
        EASTER_EGG_2 = PMStructures.getSmallStructure("easter_egg_2", () -> new GroundStructure("easter_egg_2", true, PMConfig.SETTINGS.structures.eastereggs, GroundStructure.SupportType.STILTS, Blocks.f_50222_, Blocks.f_50224_, Blocks.f_50223_), new PlacementModifier[0]);
        REBELS_1 = PMStructures.getSmallStructure("rebels_1", () -> new GroundStructure("rebels_1", false, PMConfig.SETTINGS.structures.blackAndGold, GroundStructure.SupportType.IN_GROUND), new PlacementModifier[0]);
        REBELS_2 = PMStructures.getSmallStructure("rebels_2", () -> new UndergroundStructure("rebels_2", true, PMConfig.SETTINGS.structures.blackAndGold), new PlacementModifier[0]);
        BLACK_CROSS = PMStructures.getSmallStructure("black_cross", () -> new GroundStructure("black_cross", true, PMConfig.SETTINGS.structures.blackCross, GroundStructure.SupportType.STILTS, Blocks.f_50222_, Blocks.f_50224_, Blocks.f_50223_), new PlacementModifier[0]);
        DEEP_DARK_BLACK_CROSS = PMStructures.getSmallStructure("deep_dark_black_cross", () -> new GroundStructure("black_cross_deep_dark", false, PMConfig.SETTINGS.structures.blackCross, GroundStructure.SupportType.STILTS, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS), new PlacementModifier[0]);
        GOLD_CROSS = PMStructures.getSmallStructure("gold_cross", () -> new GroundStructure("gold_cross", true, PMConfig.SETTINGS.structures.goldCross, GroundStructure.SupportType.STILTS, Blocks.f_50222_, Blocks.f_50224_, Blocks.f_50223_), new PlacementModifier[0]);
        DEEP_DARK_GOLD_CROSS = PMStructures.getSmallStructure("deep_dark_gold_cross", () -> new GroundStructure("gold_cross_deep_dark", false, PMConfig.SETTINGS.structures.goldCross, GroundStructure.SupportType.STILTS, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS), new PlacementModifier[0]);
        RUINS = PMStructures.getSmallStructure("ruins", VillageRuin::new, PlacementUtils.f_195352_);
        SMALL_STRONGHOLD = PMStructures.getSmallStructure("small_stronghold", () -> new UndergroundStructure("dungeons/small_stronghold", true, PMConfig.SETTINGS.structures.smallStronghold), new PlacementModifier[0]);
        CREATOR_HEADS = PMStructures.getSmallStructure("creator_heads", CreatorHeads::new, new PlacementModifier[0]);
        RESEARCH_BASE = PMStructures.getSmallStructure("research_base", ResearchBase::new, new PlacementModifier[0]);
        HOME = PMStructures.getSmallStructure("home", Home::new, new PlacementModifier[0]);
        SMALL_DARK_DUNGEON = PMStructures.getSmallStructure("small_dark_dungeon", SmallDarkDungeon::new, new PlacementModifier[]{CountPlacement.m_191628_((int)10), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158929_())});
        ROGUE_SPIKE = PMStructures.getSmallStructure("rogue_spike", RogueEndSpike::new, new PlacementModifier[0]);
        BRICK_DUNGEON_PROCESSOR = PMStructures.regStructProcessor("brick_dungeon", BrickDungeonProcessor.CODEC);
        TERRARIUM_PROCESSOR = PMStructures.regStructProcessor("terrarium", TerrariumProcessor.CODEC);
        DARK_DUNGEON_PROCESSOR = PMStructures.regStructProcessor("dark_dungeon", DarkDungeonProcessor.CODEC);
        CONDUIT_PROCESSOR = PMStructures.regStructProcessor("conduit", ConduitProcessor.CODEC);
        BRICK_PYRAMID = PMStructures.createStructure("brick_pyramid", "brickPyramids", "brick_pyramid/1", 4, StructureGenType.GROUND, (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        MEDIUM_DARK_DUNGEON = PMStructures.createStructure("medium_dark_dungeon", "mediumDarkDungeon", "medium_dark_dungeon", 1, StructureGenType.UNDERGROUND, PMTags.Biomes.DEEP_DARK, GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY);
        LARGE_DARK_DUNGEON = PMStructures.createStructure("large_dark_dungeon", "largeDarkDungeon", "large_dark_dungeon/1", 4, StructureGenType.GROUND, PMTags.Biomes.DEEP_DARK, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        DARK_TOWER = PMStructures.createStructure("dark_tower", "darkTower", "dark_tower/bottom", 12, StructureGenType.GROUND, PMTags.Biomes.DEEP_DARK, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        MINER_BASE = PMStructures.createStructure("miner_base", "minerBases", "miner_base", 1, StructureGenType.UNDERGROUND, PMTags.Biomes.MINER_BASE_BIOMES, GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY);
        TERRARIUM = PMStructures.createStructure("terrarium", "terrariums", "terrarium", 1, StructureGenType.UNDERGROUND, PMTags.Biomes.MINER_BASE_BIOMES, GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY);
        OCEAN_TERRARIUM = PMStructures.createStructure("ocean_terrarium", "terrariums", "terrarium", 1, StructureGenType.UNDERWATER, (TagKey<Biome>)BiomeTags.f_207603_, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        BADLANDS_PYRAMID = PMStructures.createStructure("badlands_pyramid", "badlandsPyramids", "badlands_pyramid/pyramid", 2, StructureGenType.GROUND, (TagKey<Biome>)BiomeTags.f_207607_, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        DARK_DESERT_PYRAMID = PMStructures.createStructure("dark_desert_pyramid", "darkDesertPyramids", "dark_desert_pyramid/pyramid", 2, StructureGenType.GROUND, PMTags.Biomes.DARK_DESERTS, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        WICKER_MAN = PMStructures.createStructure("wicker_man", "wickerMan", "wicker_man/shrine", 2, StructureGenType.DRY_GROUND, (TagKey<Biome>)BiomeTags.f_207596_, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        TRADER_TENT = PMStructures.createStructure("trader_tent", "traderTent", "trader_tent", 1, StructureGenType.DRY_GROUND, (TagKey<Biome>)BiomeTags.f_207596_, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        SKY_WHEEL = PMStructures.createStructure("sky_wheel", "skyWheels", "sky_wheel", 1, StructureGenType.SKY, PMTags.Biomes.MINER_BASE_BIOMES, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, TerrainAdjustment.NONE);
        ENDER_OUTPOST = PMStructures.createStructure("ender_outpost", "enderOutpost", "ender_outpost/bottom", 12, StructureGenType.GROUND, (TagKey<Biome>)BiomeTags.f_215818_, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        MONASTERY = PMStructures.createStructure("monastery", "monastery", "monastery/base", 2, StructureGenType.DRY_GROUND, PMTags.Biomes.MINER_BASE_BIOMES, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        CONDUIT = PMStructures.createStructure("conduit", "conduit", "conduit", 2, StructureGenType.UNDERWATER, (TagKey<Biome>)Tags.Biomes.IS_WATER, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
    }

    protected static enum StructureGenType {
        UNDERGROUND(-32),
        GROUND(1),
        UNDERWATER(1),
        DRY_GROUND(1),
        SKY(256);

        private final int startHeight;

        private StructureGenType(int startHeight) {
            this.startHeight = startHeight;
        }

        protected int startHeight() {
            return this.startHeight;
        }

        protected boolean isGround() {
            return this == UNDERWATER || this == DRY_GROUND || this == GROUND;
        }
    }

    @FunctionalInterface
    public static interface StructureFactory
    extends PMWorld.WorldgenFactory<Structure> {
        public Structure create(HolderGetter<Biome> var1);

        @Override
        default public Structure generate(BootstapContext<Structure> context) {
            HolderGetter biomeGetter = context.m_255420_(Registries.f_256952_);
            return this.create((HolderGetter<Biome>)biomeGetter);
        }
    }
}

