/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.world.Ores;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.worldgen.structures.SmallStructure;

public class ResearchBase
extends SmallStructure {
    private Direction direction = Direction.EAST;
    private BaseType baseType = null;

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        this.baseType = BaseType.fromBiome((Holder<Biome>)world.m_204166_(pos));
        if (this.baseType != null && PMConfig.SETTINGS.structures.bases.shouldGenerate(rand)) {
            int y;
            this.direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
            ResourceLocation base = new ResourceLocation("paradisemod:" + this.baseType.name().toLowerCase() + "_base/base_" + this.direction.name().toLowerCase());
            ResourceLocation balcony = new ResourceLocation("paradisemod:" + this.baseType.name().toLowerCase() + "_base/balcony_" + this.direction.name().toLowerCase());
            int[] baseSize = new int[]{6, 7};
            if (this.direction.m_122434_() == Direction.Axis.Z) {
                baseSize = new int[]{7, 6};
            }
            if ((y = PMWorld.getHighestY((LevelAccessor)world, pos, pos.m_7918_(baseSize[0], 0, baseSize[1]))) < 2) {
                return false;
            }
            BlockPos basePos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            BlockPos balconyPos = this.getBalconyPos(basePos);
            if (!ResearchBase.checkArea(world, basePos, new Vec3i(10, 8, 10))) {
                return false;
            }
            boolean useBase = false;
            boolean useBalcony = false;
            switch (this.direction) {
                case WEST: 
                case NORTH: {
                    useBalcony = true;
                    break;
                }
                default: {
                    useBase = true;
                }
            }
            boolean hasBalcony = this.needsBalcony(world, balconyPos);
            if (this.direction == Direction.WEST) {
                this.genStructureFromTemplate(base, world, rand, basePos.m_122030_(3), generator, hasBalcony && useBase);
            } else if (this.direction == Direction.NORTH) {
                this.genStructureFromTemplate(base, world, rand, basePos.m_122020_(3), generator, hasBalcony && useBase);
            } else {
                this.genStructureFromTemplate(base, world, rand, basePos, generator, hasBalcony && useBase);
            }
            if (hasBalcony) {
                if (this.direction == Direction.WEST) {
                    return this.genStructureFromTemplate(balcony, world, rand, balconyPos.m_122030_(3), generator, useBalcony);
                }
                if (this.direction == Direction.NORTH) {
                    return this.genStructureFromTemplate(balcony, world, rand, balconyPos.m_122020_(3), generator, useBalcony);
                }
                return this.genStructureFromTemplate(balcony, world, rand, balconyPos, generator, useBalcony);
            }
            if (balconyPos.m_123341_() < basePos.m_123341_() && balconyPos.m_123343_() < basePos.m_123343_()) {
                PMWorld.updateBlockStates((LevelAccessor)world, balconyPos, 10, 8, 10);
            } else {
                PMWorld.updateBlockStates((LevelAccessor)world, basePos, 10, 8, 10);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void postProcessStructure(StructureTemplate template, WorldGenLevel world, RandomSource rand, BlockPos pos, StructurePlaceSettings settings, ChunkGenerator generator) {
        int[] nArray;
        BlockState stiltBlock = this.baseType.stiltBlock.get().m_49966_();
        if (this.direction.m_122434_() == Direction.Axis.Z) {
            int[] nArray2 = new int[2];
            nArray2[0] = 6;
            nArray = nArray2;
            nArray2[1] = 9;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 9;
            nArray = nArray3;
            nArray3[1] = 6;
        }
        int[] size = nArray;
        BlockPos newPos = pos.m_122030_(this.direction == Direction.SOUTH ? 1 : 0);
        this.postProcessByBlock(world, size[0], 0, size[1], newPos, (curState, curPos) -> {
            int x = curPos.m_123341_() - newPos.m_123341_();
            int z = curPos.m_123343_() - newPos.m_123343_();
            if (x == 0 && z == 0 || x == 0 && z == size[1] - 1 || x == size[0] - 1 && z == 0 || x == size[0] - 1 && z == size[1] - 1) {
                BlockPos.MutableBlockPos stiltPos = new BlockPos.MutableBlockPos(curPos.m_123341_(), curPos.m_123342_() - 1, curPos.m_123343_());
                BlockState blockToReplace = world.m_8055_((BlockPos)stiltPos);
                while (!blockToReplace.m_60815_() || blockToReplace.m_60713_(Blocks.f_50125_)) {
                    world.m_7731_((BlockPos)stiltPos, stiltBlock, 32);
                    stiltPos.m_122173_(Direction.DOWN);
                    if (stiltPos.m_123342_() < 30) break;
                    blockToReplace = world.m_8055_((BlockPos)stiltPos);
                }
            }
        });
    }

    private boolean needsBalcony(WorldGenLevel world, BlockPos balconyPos) {
        for (int i = 0; i < 6; ++i) {
            BlockPos newPos = balconyPos.m_122030_(i);
            if (this.direction.m_122434_() == Direction.Axis.Z) {
                newPos = balconyPos.m_122020_(i);
            }
            if (world.m_8055_(newPos).m_60815_()) continue;
            return true;
        }
        return false;
    }

    private BlockPos getBalconyPos(BlockPos basePos) {
        return switch (this.direction) {
            default -> basePos.m_122030_(6);
            case Direction.WEST -> basePos.m_122025_(3).m_122019_();
            case Direction.NORTH -> basePos.m_122013_(3);
            case Direction.SOUTH -> basePos.m_122020_(6).m_122029_();
        };
    }

    private static enum BaseType {
        SALT(Ores.COMPACT_SALT_BLOCK),
        GLACIER(() -> Blocks.f_50354_),
        VOLCANIC(() -> Blocks.f_50080_);

        private final Supplier<Block> stiltBlock;

        private BaseType(Supplier<Block> stiltBlock) {
            this.stiltBlock = stiltBlock;
        }

        @Nullable
        private static BaseType fromBiome(Holder<Biome> biome) {
            if (biome.m_203565_(PMBiomes.SALT_FLAT) || biome.m_203565_(PMBiomes.SALT_CAVE)) {
                return SALT;
            }
            if (biome.m_203565_(PMBiomes.GLACIER) || biome.m_203565_(PMBiomes.SUBGLACIAL_VOLCANIC_FIELD) || biome.m_203565_(PMBiomes.UNDERGROUND_GLACIER) || biome.m_203565_(PMBiomes.POLAR_WINTER)) {
                return GLACIER;
            }
            if (biome.m_203656_(PMTags.Biomes.VOLCANIC)) {
                return VOLCANIC;
            }
            return null;
        }
    }
}

