/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.PMConfig;
import net.paradisemod.misc.Chests;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.worldgen.features.BasicFeature;
import net.paradisemod.worldgen.structures.SmallStructure;

public class SmallDarkDungeon
extends BasicFeature {
    private static final List<EntityType<?>> MOBS = List.of(EntityType.f_20501_, EntityType.f_20558_, EntityType.f_20479_, EntityType.f_20554_, EntityType.f_20524_, EntityType.f_20497_);

    @Override
    protected boolean placeFeature(WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator) {
        if (PMConfig.SETTINGS.structures.smallDarkDungeon.shouldGenerate(rand) && SmallStructure.checkArea(world, pos, new Vec3i(7, 7, 7)) && SmallDarkDungeon.isUndergroundAreaValid(world, pos, 7, 7, 7)) {
            int z;
            int y;
            int x;
            for (x = 0; x < 7; ++x) {
                for (y = 0; y < 7; ++y) {
                    for (z = 0; z < 7; ++z) {
                        BlockPos newPos = pos.m_7918_(x, y, z);
                        BlockState blockstate = world.m_8055_(newPos);
                        if (blockstate.m_60713_(Blocks.f_152550_)) {
                            world.m_7731_(newPos, Blocks.f_152589_.m_49966_(), 32);
                            continue;
                        }
                        if (blockstate.m_60795_()) continue;
                        world.m_7731_(newPos, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS.get().m_49966_(), 32);
                    }
                }
            }
            for (x = 1; x < 6; ++x) {
                for (y = 1; y < 6; ++y) {
                    for (z = 1; z < 6; ++z) {
                        world.m_7731_(pos.m_7918_(x, y, z), Blocks.f_50016_.m_49966_(), 32);
                    }
                }
            }
            for (x = 0; x < 7; ++x) {
                for (int z2 = 0; z2 < 7; ++z2) {
                    BlockPos newPos = pos.m_7918_(x, 0, z2);
                    BlockState blockstate = world.m_8055_(newPos);
                    if (blockstate.m_60713_(Blocks.f_152550_)) {
                        world.m_7731_(newPos, Blocks.f_152589_.m_49966_(), 32);
                        continue;
                    }
                    world.m_7731_(newPos, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS.get().m_49966_(), 32);
                }
            }
            BlockPos chest1Pos = pos.m_7918_(1, 1, 1);
            world.m_7731_(chest1Pos, (BlockState)((BlockState)Chests.BLACKENED_OAK_CHEST.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.RIGHT), 32);
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)rand, (BlockPos)chest1Pos, (ResourceLocation)BuiltInLootTables.f_78742_);
            BlockPos chest2Pos = pos.m_7918_(2, 1, 1);
            world.m_7731_(chest2Pos, (BlockState)((BlockState)Chests.BLACKENED_OAK_CHEST.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT), 32);
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)rand, (BlockPos)chest2Pos, (ResourceLocation)BuiltInLootTables.f_78742_);
            BlockPos chest3Pos = pos.m_7918_(5, 1, 5);
            world.m_7731_(chest3Pos, (BlockState)((BlockState)Chests.BLACKENED_OAK_CHEST.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.WEST)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT), 32);
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)rand, (BlockPos)chest3Pos, (ResourceLocation)BuiltInLootTables.f_78742_);
            BlockPos chest4Pos = pos.m_7918_(5, 1, 4);
            world.m_7731_(chest4Pos, (BlockState)((BlockState)Chests.BLACKENED_OAK_CHEST.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.WEST)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.RIGHT), 32);
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)rand, (BlockPos)chest4Pos, (ResourceLocation)BuiltInLootTables.f_78742_);
            BlockPos spawnerPos = pos.m_7918_(3, 1, 3);
            world.m_7731_(spawnerPos, Blocks.f_50085_.m_49966_(), 32);
            BlockEntity tile = world.m_7702_(spawnerPos);
            if (tile instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)tile;
                spawner.m_252803_(MOBS.get(rand.m_188503_(MOBS.size())), rand);
            } else {
                ParadiseMod.LOG.error("Failed to fetch mob spawner entity at ({}, {}, {})", (Object)spawnerPos.m_123341_(), (Object)spawnerPos.m_123342_(), (Object)spawnerPos.m_123343_());
            }
            return true;
        }
        return false;
    }
}

