/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.worldgen.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.paradisemod.ParadiseMod;
import net.paradisemod.world.PMWorld;
import net.paradisemod.worldgen.features.BasicFeature;

public abstract class SmallStructure
extends BasicFeature {
    protected void postProcessStructure(StructureTemplate template, WorldGenLevel world, RandomSource rand, BlockPos pos, StructurePlaceSettings settings, ChunkGenerator generator) {
    }

    protected final void postProcessByBlock(WorldGenLevel world, StructureTemplate template, BlockPos pos, BlockProcessor processor) {
        Vec3i size = template.m_163801_();
        this.postProcessByBlock(world, size.m_123341_(), size.m_123342_(), size.m_123343_(), pos, processor);
    }

    protected final void postProcessByBlock(WorldGenLevel world, int sizeX, int sizeY, int sizeZ, BlockPos pos, BlockProcessor processor) {
        for (BlockPos curPos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(sizeX, sizeY, sizeZ))) {
            processor.process(world.m_8055_(curPos), curPos);
        }
    }

    protected final boolean genStructureFromTemplate(StructureTemplate template, WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator, boolean postProcess) {
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.m_74392_(false);
        boolean success = template.m_230328_((ServerLevelAccessor)world, pos, pos, settings, rand, 2);
        if (postProcess && success) {
            this.postProcessStructure(template, world, rand, pos, settings, generator);
        }
        return success;
    }

    protected final boolean genStructureFromTemplate(ResourceLocation templateName, WorldGenLevel world, RandomSource rand, BlockPos pos, ChunkGenerator generator, boolean postProcess) {
        StructureTemplate template = world.m_6018_().m_215082_().m_230407_(templateName).orElse(null);
        if (template == null) {
            ParadiseMod.LOG.error("Unable to generate " + String.valueOf(templateName));
            ParadiseMod.LOG.error("Does the associated structure file exist?");
            return false;
        }
        return this.genStructureFromTemplate(template, world, rand, pos, generator, postProcess);
    }

    protected static boolean checkArea(WorldGenLevel world, BlockPos structurePos, Vec3i size) {
        for (BlockPos newPos : BlockPos.m_121940_((BlockPos)structurePos, (BlockPos)structurePos.m_121955_(size))) {
            if (!PMWorld.doNotReplace((LevelAccessor)world, newPos)) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    protected static interface BlockProcessor {
        public void process(BlockState var1, BlockPos var2);
    }
}

